# -*- coding: utf-8 -*-
# == Schema Information
# Schema version: 20090304040015
#
# Table name: account_items
#
#  id                   :integer       not null, primary key
#  domain_id            :integer       not null
#  code                 :string(30)    not null
#  name                 :string(150)   not null
#  taxation_calculation :string(1)
#  created_at           :string(14)
#  updated_at           :string(14)
#  created_by           :integer
#  updated_by           :integer
#  created_in           :integer
#  updated_in           :integer
#  lock_version         :integer       default(0), not null
#

class AccountItem < ActiveRecord::Base
  untranslate_all
  timestamps_as_string
  user_monitor

  def compute_tax?
    case self.taxation_calculation
    when '1'
      true
    when '2'
      false
    else
      raise "must not happen! #{self.taxation_calculation}"
    end
  end
end
