# 画面生成の helper を与える。
module ProductGeneratorHelper
  # 削除画面かどうかを判定する。
  def display_destroy?
    return controller.action_name == "display_destroy"
  end

  # 機能の種類を選択する select box を返す。
  def type_selector
    constant_select_tag(Product::LABEL_TYPE, "product[type]", @product, "type")
  end

  # 各画面で利用するボタンを設定する check box を返す。
  def check_boxes_for_buttons
    "#{@display.attributes["type"]}::BUTTON_TYPE".constantize.map do |pair|
      name = "button_#{pair.last}"
      check_box_with_label("display[]", name, h(s_(pair.first)))
    end.join("<br />")
  end

  # 画面に対する操作へのリンクを返す。
  def links_for_operations(with_destroy)
    links = [["memo.png", "e", "display_edit", s_("rfw|button|Edit")]]
    links << ["delete.png", "d", "display_destroy", s_("rfw|button|Delete")] if with_destroy
    links.map do |image, suffix, action, alt|
      link_to_view_motion(image_tag(image, {:alt => alt}),
        "display", "#{@display.id}#{suffix}",
        {}, {:action => action, :id => @display.id},
        :class => "reloadable_link")
    end.join(" ")
  end

  # ビジネスロジックのパスを設定する check box を返す。
  def program_field(x)
    check_box_with_label("display", "logic_#{x}", h(s_(DisplayToEdit::LOGIC_TYPE[x])))
  end

  # 項目ごとの行を返す。
  def item_tr(header, data, options={})
    data_colspan = options[:colspan] || 3
    if data_colspan && 1 < data_colspan
      colspan = %Q| colspan="#{data_colspan}"|
    end
    %Q|<tr><th colspan="2">#{h(header)}</th><td#{colspan}>#{data} #{options[:example]}</td></tr>|
  end

  # 項目のレイアウトを選択するための select box を返す。
  def layout_selector
    x = @display.is_a?(DisplayToList) ? "list" : "show"
    select "item", "layout", InputOption.options_for_select("item_layout_#{x}", @display.items.size+2).map {|x| [x.first, x.last.to_i]}
  end

  # 項目の位置を選択するための select box を返す。
  def position_selector
    size = @display.items.size
    options = ((size == 0) ? [] : (1..size).map {|i| [i, i]})
    options.unshift([h(s_("rfw|Option|none")), ""])
    select "item", "position", options
  end

  # 項目をソートする場合の順方向を選択する select box を返す。
  def direction_selector
    constant_select_tag(Item::LABEL_DIRECTION, "item[direction]", @item, "direction", h(s_("rfw|Option|none")))
  end

  # 入力の種類を選択するための select box を返す。
  def input_type_selector
    constant_select_tag(Item::LABEL_INPUT_TYPE, "item[input_type]", @item, "input_type")
  end

  # 入力の初期値を選択するための select box を返す。
  def input_initializer_selector
    constant_select_tag(Item::LABEL_INPUT_INITIALIZER, "item[input_initializer]", @item, "input_initializer")
  end

  # <em>column_name</em> を検証する部品を設定するための input 群を返す。
  def inputs_for_validates(column_name)
    count = Item::VALIDATES_COLUMN_PARAMETER_COUNT[column_name.to_sym]
    colspan = ' colspan="2"' if count == 1
    result = check_box_with_label("item", column_name, h(Item.human_attribute_name(column_name)))
    (1..count).each do |i|
      parameter_column_name = "#{column_name}_#{i}"
      result << "</td><td#{colspan}>"
      result << Item.human_attribute_name(parameter_column_name) << ":"
      result << text_field("item", parameter_column_name)
    end
    return result
  end
end
