module PjcSegmentChecklistHelper
  include NarrowingHelper::Helper
# -*- coding: utf-8 -*-

  # 新規作成画面へのボタンを返す。
  def td_button_new
    if session[:segment_checklist_list_type] == "LIST" && @product.modifiable? && (!@it.respond_to?(:writable?) || @it.writable?)
      b = link_to_view_motion(h(s_("rfw|button|New")),
                              @sub_view, "create",
                              {"_" => "&suffix;"},
                              {:action => "new", :product_id => params[:product_id], :list_type=>"LIST"},
                              :class => "button reloadable_link")
    else
      b = "&nbsp;&nbsp;"
    end
    content_tag(:td, b, :class => "button_new")
  end

  # (指定されていれば)CSV出力画面へのリンクを返す。
  def td_to_csv
    return "" unless @display.csv?
    link = link_to_view_motion(h(s_("rfw|link_to|CSV")),
                               "view_output",
                               "output",
                               {:controller => "output", :action => "edit", :id => @display.id},
                               {:controller => "output", :action => "edit", :id => @display.id},
                               {:id => "output", :class => "button"})
    content_tag(:td, link, :class => "right")
  end

  # (指定されていれば)絞り込みの窓を返す。

  # 権限で許可されていないカラムの部品を返す。
  def not_permitted_column
      filtered_message = s_("rfw|not_permitted_column|[FILTERED]")
      return MergeableTag.new(:td, filtered_message, :class => "not_permitted_column")
  end

  include ItemTableLayout

  # 詳細画面および編集画面で詳細情報を表示するための table を返す。
  def with_table(&block)
    table = to_table_layout(@items) do |item|
      if item.is_a?(Item)
        yield item
      else
        nil
      end
    end

    rows = table.map do |row|
      if row[0].nil?
        content_tag(:tr, content_tag(:td, "&nbsp;", :class => "blank", :colspan => 4))
      else
        cols = row.map do |col|
          if col && col[0] != nil
            th = MergeableTag.new(:th, "")
            if row[1].nil?
              td = MergeableTag.new(:td, "", :colspan => 3)
            else
              td = MergeableTag.new(:td, "")
            end
            col.each do |c|
              th.merge(c[0])
              td.merge(c[1])
            end
            [th.to_s, td.to_s].join("")
          else
            [
              content_tag(:th, "", :class => "blank"),
              content_tag(:td, "", :class => "blank", :colspan => 3),
            ].join("")
          end
        end
        content_tag(:tr, cols.join(""))
      end
    end
    if @list_type == "JUDGMENT_LIST"
      rows.shift
      rows.shift
      rows.shift
      rows.shift
      rows.shift
    else
      rows = rows[0,5]
    end
    if @list_type == "JUDGMENT_LIST" && @form_type == "judgment_edit"
      rows.unshift(content_tag(:tr, content_tag(:td, @it[:judgment_of].to_s + s_("PjcSegmentChecklist|times") + "&nbsp;&nbsp;&nbsp;" + s_("PjcSegmentChecklist|Document management number") + ":", :colspan=>"4")))
    end
    return content_tag(:table, rows.join(""), :class => "header w_detail")
  end

  # 項目の一覧を含む table を返す。
  def items_to_table
    with_table do |item|
      [
        MergeableTag.new(:th, h(item.human_name)),
        item_to_td(item, @it)
      ]
    end
  end

  # 項目の一覧に対応する input の table を返す。
  def items_to_table_input
    table = with_table do |item|
      if @list_type == "JUDGMENT_LIST"
        if item.layout.to_i > 10
          options = {}
          options[:class] = "required" if item.required?
          label = content_tag(:label, h(item.human_name), :for => "it_#{item.column_name}")
          [
            MergeableTag.new(:th, label, options),
            item_to_td_input(item, :it)
          ]
        else
        end
      else
        if item.layout.to_i < 10
        options = {}
        options[:class] = "required" if item.required?
        options[:width] = "120"
        label = content_tag(:label, h(item.human_name), :for => "it_#{item.column_name}")
        [
          MergeableTag.new(:th, label, options),
          item_to_td_input(item, :it)
        ]
        end
      end
    end
    table + hidden_field(:it, "lock_version")
  end

  # 項目 <em>i</em> からヘッダを返す。
  def item_to_th(i)
    options = {}
    options[:style] = i.style if i.style
    options[:class] = "required" if i.required?
    MergeableTag.new(:th, h(i.human_name), options)
  end

  def open_and_close(i, it, d_code)
    old = PjcSegmentChecklistTask.find(:all,:conditions=>{:parent_id=>it.id}).map(&:id).join(",").split(/,/)
    new = @ids.join(",").split(/,/)
    b = ""
    if old == nil || old == "" || old == []
      b = "&nbsp;&nbsp;&nbsp;&nbsp;"
    elsif old - new != old
      b = link_to_view_motion(image_tag("close.gif", :alt => s_("PjcSegmentChecklist|close")),
            @current_view, Menu.find(:first, :conditions=>{:product_id=>@checklist_product_id}).id,
            {:id => nil, "_" => "_#{it.id}"},
            {:action => "list", :id => nil, :product_id => @checklist_product_id, :list=>@product.displays.find_by_code(d_code).id, :close_mark=>it.id, :project=>@selected_project, :segment=>@selected_segment, :segment_checklist=>@selected_segment_checklist, :task_ids=>@ids},
            {:class => "reloadable_link"})
    elsif old - new == old
      b = link_to_view_motion(image_tag("open.gif", :alt => s_("PjcSegmentChecklist|open")),
            @current_view, Menu.find(:first, :conditions=>{:product_id=>@checklist_product_id}).id,
            {:id => nil, "_" => "_#{it.id}"},
            {:action => "list", :id => nil, :product_id => @checklist_product_id, :list=>@product.displays.find_by_code(d_code).id, :open_mark=>it.id, :project=>@selected_project, :segment=>@selected_segment, :segment_checklist=>@selected_segment_checklist, :task_ids=>@ids},
            {:class => "reloadable_link"})
    end

    return b
  end
  
  def copy_cut_paste(i,it)
    b = link_to_view_motion(image_tag("copy.png", :alt => s_("PjcSegmentChecklist|copy")),
          @current_view, Menu.find(:first, :conditions=>{:product_id=>@checklist_product_id}).id,
          {:id => nil, "_" => "_#{it.id}_copy"},
          {:action => "list", :id => nil, :product_id => @checklist_product_id, :list=>@product.displays.find_by_code("TASK_LIST").id, :project=>@selected_project, :segment=>@selected_segment, :segment_checklist=>@selected_segment_checklist, :task_ids=>@ids ,:do_type=>"copy", :do_mark =>it.id},
          {:class => "reloadable_link"})
    b = b + "&nbsp;&nbsp;" + link_to_view_motion(image_tag("cut.png", :alt => s_("PjcSegmentChecklist|cut")),
            @current_view, Menu.find(:first, :conditions=>{:product_id=>@checklist_product_id}).id,
            {:id => nil, "_" => "_#{it.id}_cut"},
            {:action => "list", :id => nil, :product_id => @checklist_product_id, :list=>@product.displays.find_by_code("TASK_LIST").id, :project=>@selected_project, :segment=>@selected_segment, :segment_checklist=>@selected_segment_checklist, :task_ids=>@ids, :do_type=>"cut", :do_mark =>it.id},
            {:class => "reloadable_link"})
      if params[:do_type] == "copy"
        b = b + "&nbsp;&nbsp;" + link_to_view_motion(image_tag("paste.png", :alt => s_("PjcSegmentChecklist|paste")),
              "view_detail", Menu.find(:first, :conditions=>{:product_id=>@checklist_product_id}).id,
              {:id => it.id, "_" => "_#{it.id}_paste"},
              {:action => "new", :id => it, :product_id => @checklist_product_id, :list=>@product.displays.find_by_code("TASK_LIST").id,:list_type=>"TASK_LIST", :project=>@selected_project, :segment=>@selected_segment, :segment_checklist=>@selected_segment_checklist, :task_ids=>@ids, :do_type=>"cut", :do_mark =>it.id, :paste=>"paste"},
              {:class => "reloadable_link"})
      elsif params[:do_type] == "cut"
        if @can_paste_ids.include?("#{it.id}")
          b = b + "&nbsp;&nbsp;" + link_to_view_motion(image_tag("paste.png", :alt => s_("PjcSegmentChecklist|paste")),
                "view_detail", Menu.find(:first, :conditions=>{:product_id=>@checklist_product_id}).id,
                {:id => it.id, "_" => "_#{it.id}_paste"},
                {:action => "new", :id => it, :product_id => @checklist_product_id, :list=>@product.displays.find_by_code("TASK_LIST").id,:list_type=>"TASK_LIST", :project=>@selected_project, :segment=>@selected_segment, :segment_checklist=>@selected_segment_checklist, :task_ids=>@ids, :do_type=>"cut", :do_mark =>it.id, :paste=>"paste"},
                {:class => "reloadable_link"})
        end
      else
      end
    return b
  end

  def segment_checklist_task_add(i,it)
    b = link_to_view_motion(image_tag("pen.png", :alt => s_("PjcSegmentChecklist|task add")),
          @sub_view, Menu.find(:first, :conditions=>{:product_id=>@checklist_product_id}).id,
          {:id => it.id, "_" => "_#{it.id}"},
          {:action => "new", :id => it, :product_id => @checklist_product_id, :list=>@product.displays.find_by_code("TASK_LIST").id, :project=>@selected_project, :segment=>@selected_segment, :segment_checklist=>@selected_segment_checklist, :list_type=>"TASK_LIST", :form_type=>"task_new"},
          {:class => "reloadable_link"})
     return b
  end
  
  # 項目から td を返す。
  def item_to_td(i, it)
    return not_permitted_column unless i.readable?
    unless i.column_name == "judgment_result" || i.column_name == "judgment_person" || i.column_name == "judgment_date" || i.column_name == "judgment_number" || i.column_name == "judgment_comment"
      begin
        data = i.to_data(it)
        if data.is_a? Proc
          data = data.call(binding())
        end
      rescue Item::Error => e
        logger.error("ERROR: Item::Error: #{e.inspect}")
        return MergeableTag.new(:td, h(e.to_s), :class => "formError")
      rescue NoMethodError => e
        logger.error("ERROR: column not found: #{@model_class}\##{i.column_name} #{e.inspect}\n#{e.backtrace.join("\n")}")
        message = s_("rfw|formError|column not found")
        return MergeableTag.new(:td, h(message), :class => "formError")
      end
    end

    case i.decorator
    when "front"
      content = h("#{i.decorator_parameter}#{data}")
    when "back"
      content = h("#{data}#{i.decorator_parameter}")
    when "currency"
      content = number_to_currency(data, :unit => "", :precision => 0)
    when "size" # for test
      content = h(number_to_human_size(data))
    when "nl2br"
      content = h(data).gsub(/\r?\n/) { "<br />" }
    else
      content = h(data)
    end

    if url = i.link_url(it)
      content = link_to(content, url)
    end
    
    options = {
      :align => i.align,
      :class => "item",
    }
    options[:style] = i.style
    options[:style] ||= ""
    if @display.code == "JUDGMENT_LIST"
      judgment_info = PjcSegmentChecklistJudgment.find(:first, :conditions=>{:segment_checklist_task_id=>it.id}, :order=>"judgment_of desc")
      if judgment_info
      else
        judgment_info = PjcSegmentChecklistJudgment.new
        judgment_info.judgment_result = "1"
        judgment_info.judgment_person_id = 0
        judgment_info.judgment_of = ""
        judgment_info.judgment_date = ""
        judgment_info.judgment_comment = ""
      end
    end
    case i.column_name
    when "task_name"
      if @copy_ids
        if @copy_ids.include?("#{it.id}")
          options[:style] += "background-color:#A7FFFF;"
#          options[:bgcolor] = "#A7FFFF"
        end
      end
      if @cut_ids
        if @cut_ids.include?("#{it.id}")
          options[:style] += "background-color:#FFFF9C;"
#          options[:bgcolor] = "#FFFF9C"
        end
      end
      content = open_and_close(i, it, "TASK_LIST") + content
      content += segment_checklist_task_add(i,it)
      content = "&nbsp;" * 5 * it.task_level.to_i + content
      content = content + "<br>" + "&nbsp;" * 5 * it.task_level.to_i + "&nbsp;&nbsp;&nbsp;" +  copy_cut_paste(i,it)
    when "judgment_name"
      content = open_and_close(i, it, "JUDGMENT_LIST") + content
      content = "&nbsp;" * 5 * it.task_level.to_i + content
      content = content
    when "judgment_result"
      if it.task_judgment != "1"
        content = "" 
      elsif judgment_info.judgment_result == "2"
        content = s_("PjcSegmentChecklist|judgment OK") 
      elsif judgment_info.judgment_result == "3"  
        content = s_("PjcSegmentChecklist|judgment NG") 
      else
        content = s_("PjcSegmentChecklist|judgment NOT") 
      end
    when "judgment_person"
      if Person.find(:first,:conditions=>{:id=>judgment_info.judgment_person_id})
        content = Person.find(:first,:conditions=>{:id=>judgment_info.judgment_person_id}).name
      else
        content = ""
      end
    when "judgment_number"  
      content = judgment_info.judgment_of
    when "judgment_date"
      if judgment_info.judgment_date == ""
        content = ""
      else
        content = Time.parse(judgment_info.judgment_date).strftime("%Y/%m/%d")
      end
    when "judgment_comment"
      content = judgment_info.judgment_comment
    when "task_judgment"
      if content == "1"
        content = s_("PjcSegmentChecklist|able") 
      else
        content = s_("PjcSegmentChecklist|disable")
      end
    end
    
    content = content_tag(:div, content)
    return MergeableTag.new(:td, content, options)
  end

  # 項目から td にラップされた input を返す。
  def item_to_td_input(i, object_name)
    it = instance_variable_get("@#{object_name}")
    return item_to_td(i, it) if i.is_a?(ItemPseudo)
#    it[:judgment_person] = ""
#    it[:judgment_date] = ""
#    it[:judgment_result] = ""
#    it[:judgment_comment] = ""
#    it[:confirm_person] = ""
#    it[:confirm_date] = ""
#    it[:confirm_comment] = ""
    begin
      data = it.__send__(i.column_name)
    rescue NoMethodError
      logger.error("ERROR: column not found: #{@model_class}\##{i.column_name}")
      message = s_("rfw|formError|column not found")
      return MergeableTag.new(:td, h(message), :class => "formError")
    end

    field_options = {}
    field_options[:readonly] = "readonly" unless i.writable?
    field_options[:readonly] = "readonly" if i.write_protected?
    text_options = {
      :size  => i.size_for_input_field,
      :style => i.style_for_input_field,
    }
    text_options.update(field_options)
    i.column_name
    case i.input_type
    when "picker"
      e = picker_tags(i, object_name, it)
    when "text"
      if i.method_chain && i.write_protected?
        text_options[:value] = i.to_data(it)
        e = text_field object_name, i.column_name, text_options
      else
        e = text_field object_name, i.column_name, text_options
      end
    when "textarea"
      e = text_area object_name, i.column_name, text_options
    when "radio"
      choices = i.split_into_input_options(it, session) do |name, value|
        radio_button_with_label(object_name, i.column_name, value, h(name), field_options)
      end
      unless i.required?
        choices.unshift(radio_button_with_label(object_name, i.column_name, "", h(s_("rfw|InputOption|(blank)")), field_options))
      end
      e = choices.join
    when "checkbox"
      e = check_box(object_name, i.column_name, field_options) + i.input_parameter.to_s
    when "select"
      choices = i.split_into_input_options(it, session) do |name, value|
        [h(name), value]
      end
      unless i.required?
        choices.unshift([h(s_("rfw|InputOption|(blank)")), ""])
      end
      e = select(object_name, i.column_name, choices, field_options)
    else
      logger.error("ERROR: invalid input type: #{i.input_type} (#{@model_class}\##{i.column_name})")
      message = s_("rfw|formError|invalid input type")
      return MergeableTag.new(:td, h(message), :class => "formError")
    end
    
    a = {:class => "input_item"}
    a[:style] = i.style if i.style
    return MergeableTag.new(:td, e, a)
  end

  #
  def detail_to_tr(d, script=nil, options={}, &block)
    tds = @detail_items.map {|i| yield(i, d)}
    tds.unshift(content_tag(:td, "&nbsp;", :class => "handle"))
    if script
      link = link_to_function(h(s_("rfw|button|Destroy")), script, :class => "button")
      tds.push(content_tag(:td, link))
    end
    options.update({:class => cycle("even", "odd", :name => "details_to_table")})
    content_tag(:tr, tds, options)
  end

  #
  def with_details(tail=nil, &block)
    ths = @detail_items.map {|i| item_to_th(i)}
    ths.unshift(content_tag(:th, "&nbsp;"))
    ths.push(content_tag(:th, "&nbsp;")) if tail
    head = content_tag(:thead, content_tag(:tr, ths))
    foot = content_tag(:tfoot, "")
    body = content_tag(:tbody, yield, {:id => "details_table_body"})
    table = content_tag(:table, [head, foot, body],{:id => "details_table", :class => "details w_detail"})
    return table + (tail || "")
  end

  # 
  def details_to_table
    return "" unless @product.is_a?(ProductDetailed)
    with_details do
      @details.map {|d| detail_to_tr(d) {|i,d| item_to_td(i,d)}}
    end
  end

  #
  def details_to_table_input
    return "" unless @product.is_a?(ProductDetailed)
    tail = sortable_details
    tail += hidden_field_tag("new_details", @new_details.to_json)
    tail += hidden_field_tag("old_details", @old_details.to_json)
    tail += hidden_field_tag("order_details", @details.map {|detail| "details_#{detail.id}"}.to_json)
    d = @product.detail_class.new
    @detail_items.each do |i|
      i.initialize_column_of(d)
    end
    temp = "new_details_#{rand(65536)}#{Time.now.to_i}"
    instance_variable_set("@#{temp}", d)
    tr = detail_to_tr(d, "App.remove_new_details(this,\#{n});", :id => temp) {|i,d| item_to_td_input(i, temp)}
    tr = tr.gsub(temp, "new_details_\#{n}")
    link = link_to_remote(h(s_("rfw|button|New")), {
                            :before => "App.add_new_details('#{escape_javascript(tr)}');",
                            :update => "space_details",
                            :url => {:action => "add_detail"},
                          }, {
                            :class => "button",
                          })
    tail += content_tag(:div, link, :class => "right")
    tail += content_tag(:div, "", :id => "space_details")
    with_details(tail) do
      rows = []
      @details.each do |d|
        unless @old_details.include?(d.id)
          html_id = "details_#{d.id}"
          rows << detail_to_tr(d, "App.remove_old_details(this,#{d.id});", :id => html_id) {|i,d| item_to_td_input(i, html_id)}
        end
      end
      rows += @new_details.map do |n|
        d = instance_variable_get("@new_details_#{n}")
        html_id = "new_details_#{n}"
        detail_to_tr(d, "App.remove_new_details(this,#{n});", :id => html_id) {|i,d| item_to_td_input(i, html_id)}
      end
      rows
    end
  end

  def sortable_details
    sortable_element("details_table_body",
                     :format => "/^(details_[0-9]+|new_details_[0-9]+)$/",
                     :complete => visual_effect(:highlight, "details_table"),
                     :url => {:action => "order_details"},
                     :constraint => false,
                     :ghosting => true,
                     :handle => "handle",
                     :tag => "tr")
  end

  def picker_tags(i, object_name, it)
    case App::PICKER_MODE
    when :ajax
      ajax_picker_tags(i, object_name, it)
    when :dom
      tags = rfw_picker_tags(i, object_name, it)
      if i.is_a?(ItemPolymorphic)
        em = error_message_on(object_name, "#{i.column_name}_id")
        em += error_message_on(object_name, "#{i.column_name}_type")
      else
        em = error_message_on(object_name, i.column_name)
      end
      unless em.blank?
        tags = content_tag(:div, tags, :class => "fieldWithErrors") + em
      end
      tags
    else
      raise "unknown picker mode: #{App::PICKER_MODE}"
    end
  end

  # カレンダー選択部品による入力部品を返す。
  def ajax_calendar_picker_tags(i, object_name, it)
    picker_field = i.picker_field(it, object_name)

    if flash[:pick] && picker_field === flash[:pick][:field] && flash[:pick][:return_value]
      it[i.column_name] = flash[:pick][:return_value]
    end

    e = text_field object_name, i.column_name, :size => i.size_for_input_field
    e << " "
    e << submit_tag(s_("rfw|submit_tag|Pick Date"), :name => "picker[#{picker_field}]", :onclick => "$('#{object_name}_#{i.column_name}').addClassName('selected')", :disabled => !i.writable?)
    # hidden link for ajax
    e << link_to_view_motion("",
      @sub_view, picker_field, {},
      {
        :controller => "calendar",
        :action => "calendar",
        :return_field => picker_field,
        :view => @sub_view,
        :return_format => i.calendar_format,
        :alert_holiday => i.calendar_alert_holiday?,
      }, :style => "display:none")
    return e
  end

  # 選択部品による入力部品を返す。
  def ajax_picker_tags(i, object_name, it)
    return ajax_calendar_picker_tags(i, object_name, it) if i.calendar?
    case i
    when ItemProper
      case i.picked_atom
      when "company"
        submit_text = s_("rfw|submit_tag|Pick Company")
      when "organization"
        submit_text = s_("rfw|submit_tag|Pick Organization")
      when "person"
        submit_text = s_("rfw|submit_tag|Pick Person")
      when "post"
        submit_text = s_("rfw|submit_tag|Pick Post")
      when "group"
        submit_text = s_("rfw|submit_tag|Pick Group")
      else
        raise ArgumentError, "invalid picked atom: #{i.picked_atom}"
      end
      picker_field = i.picker_field(it, object_name)
      picked_class = i.picked_atom.classify.constantize
      if flash[:pick] && picker_field == flash[:pick][:field]
        values = i.picked_values(flash[:pick])
        v = values.find {|x| x.is_a?(picked_class)}
        it[i.column_name] = v.id
      elsif v = picked_class.find_by_id(it[i.column_name])
        values = i.picked_references(v)
      else
        values = i.picked_keys.map {|k| k.classify.constantize.new}
      end
      e = ""
      i.picked_keys.each_with_index do |k,n|
        e << text_field_tag("picker_#{picker_field}_#{k}", values[n].name, :readonly => true, :size => i.size_for_input_field)
        e << " "
      end
      onclick = i.picked_keys.map do |k|
        "$('picker_#{picker_field}_#{k}').addClassName('selected');"
      end.join("")
      e << submit_tag(submit_text, :name => "picker[#{picker_field}]", :onclick => onclick, :disabled => (i.readonly? || !i.writable?))
      unless error_message_on(object_name, i.column_name).blank?
        e = content_tag(:div, e, :class => "fieldWithErrors")
      end
      # hidden link for ajax
      e << link_to_view_motion("",
                               @sub_view, picker_field, {},
                               {
                                 :controller   => "picker",
                                 :action       => i.picked_atom,
                                 :return_field => picker_field,
                                 :view         => @sub_view,
                               }, :style       => "display:none")
      e << hidden_field(object_name, i.column_name)
      return e
    when ItemPolymorphic
      picker_field = i.picker_field(it, object_name)
      if flash[:pick] && picker_field == flash[:pick][:field]
        if ( k = flash[:pick][:lump_pick] ) && ( v = k.classify.constantize.find_by_id(flash[:pick][k.to_sym]) )
          it.__send__("#{i.column_name}=", v)
        end
      elsif v = it.__send__(i.column_name)
      else
        v = nil
      end
      e = ""
      e << text_field_tag("picker_#{picker_field}", v ? v.name : "", :readonly => true, :size => i.size_for_input_field)
      onclick = "$('picker_#{picker_field}').addClassName('selected');"
      e << submit_tag(s_("rfw|submit_tag|Pick"), :name => "picker[#{picker_field}]", :onclick => onclick, :disabled => (i.readonly? || !i.writable?))
      unless error_message_on(object_name, i.column_name).blank?
        e = content_tag(:div, e, :class => "fieldWithErrors")
      end
      # hidden link for ajax
      e << link_to_view_motion("",
                               @sub_view, picker_field, {},
                               {
                                 :controller   => "picker",
                                 :action       => "lump",
                                 :return_field => picker_field,
                                 :view         => @sub_view,
                               }, :style       => "display:none")
      e << hidden_field(object_name, "#{i.column_name}_id")
      e << hidden_field(object_name, "#{i.column_name}_type")
      return e
    when ItemPlural
      picker_field = i.picker_field(it, object_name)
      if flash[:pick] && picker_field == flash[:pick][:field]
        if ( k = flash[:pick][:lump_pick] ) && ( picked_one = k.classify.constantize.find_by_id(flash[:pick][k.to_sym]) )
          values = picked_one.__send__(i.data_method_name)
          it[i.column_name] = values.map(&:id).join(",")
        else
          values = []
        end
      else
        v = it.__send__(i.column_name)
        values = i.datum_class.joints(v)
      end
      e = ""
      e << text_field_tag("picker_#{picker_field}", values.map(&:name).join(","), :readonly => true, :size => i.size_for_input_field)
      onclick = "$('picker_#{picker_field}').addClassName('selected');"
      e << submit_tag(s_("rfw|submit_tag|Pick"), :name => "picker[#{picker_field}]", :onclick => onclick, :disabled => (i.readonly? || !i.writable?))
      unless error_message_on(object_name, i.column_name).blank?
        e = content_tag(:div, e, :class => "fieldWithErrors")
      end
      # hidden link for ajax
      e << link_to_view_motion("",
                               @sub_view, picker_field, {},
                               {
                                 :controller   => "picker",
                                 :action       => "lump",
                                 :return_field => picker_field,
                                 :view         => @sub_view,
                               }, :style       => "display:none")
      e << hidden_field(object_name, i.column_name)
      return e
    else
      raise ArgumentError, "invalid item type: #{i.class}"
    end
  end

  def rfw_calendar_tags(i, object_name, it)
    picker_field = i.picker_field(it, object_name)
    rfw_picker([{
                  :type => "text",
                  :name => rfw_name_for(object_name, i.column_name),
                  :value => rfw_value_for(object_name, i.column_name),
                  :key => "return_value",
                  :html => { :size => i.size_for_input_field }
                }],
               {
                 :controller => 'pick/calendar',
                 :action => "search",
                 :return_format => i.calendar_format,
                 :alert_holiday => i.calendar_alert_holiday?,
                 :escape => false,
               },
               s_('rfw|submit_tag|Pick Date'))
  end

  # 選択部品によって選択された内容を表示する際の名前は picked_name が優先される。
  def rfw_picked_name(picked_one)
    return picked_one.picked_name if picked_one.respond_to?(:picked_name)
    picked_one.name
  end

  def rfw_picker_tags(i, object_name, it)
    # pjc3用拡張Picker処理 add 3Lines 2009/2/27 h.nakamura
    if ["destination", "bizcardcompany", "bizcardorganization", "bizcardbranch", "bizcardperson"].include?(i.input_parameter) then
      return rfw_exstra_picker_tags(i, object_name, it)
    end

    return rfw_calendar_tags(i, object_name, it) if i.calendar?

    case i
    when ItemProper
      options = i.rfw_picker_options(it, object_name)
      id = rfw_value_for(object_name, i.column_name)
      unless id.blank?
        found = i.picked_atom.classify.constantize.find_by_id(id)
        name = rfw_picked_name(found) if found
      end
      rfw_picker([{
                    :type => 'text',
                    :name => "#{rfw_name_for(object_name, i.column_name)}_name",
                    :value => name,
                    :key => options[:return_field_name],
                    :html => { :readonly => true, :size => i.size_for_input_field }
                  },
                  {
                    :type => 'hidden',
                    :name => rfw_name_for(object_name, i.column_name),
                    :value => id,
                    :key => options[:return_field_id]
                  },
                 ],
                 { :controller => options[:controller], :action => 'search' },
                 s_(options[:submit_text])) do |x_id|
        # * プロジェクト
        # * 業務
        # * 案件
        # に関する選択部品の場合には選択が完了した時点で変化があれば一度サーバに送信して編集画面を再描画する。
        if i.input_parameter =~ /\A(?:matter|project)/
          "function() {new Form.Element.Observer($('#{x_id}').previous('input'), 0.3, function(element, value) {element.form.onsubmit();});}"
        elsif i.picking_record?
          # rfw[record_model_name] を動的に指定する。
          "Rfw.embedHiddenParameters.bindAsEventListener($('#{x_id}'), {record_model_name: '#{i.picked_atom.classify}'})"
        else
          ''
        end
      end
    when ItemPolymorphic
      picker_field = i.picker_field(it, object_name)
      id = rfw_value_for(object_name, "#{i.column_name}_id")
      model_class = rfw_value_for(object_name, "#{i.column_name}_type")
      value = nil
      unless id.blank? || model_class.blank?
        found = model_class.constantize.find_by_id(id)
        value = rfw_picked_name(found) if found
      end
      rfw_picker([{
                    :type => 'text',
                    :name => "picker_#{picker_field}",
                    :value => value,
                    :key => 'model_value',
                    :html => { :readonly => true, :size => i.size_for_input_field }
                  },
                  {
                    :type => 'hidden',
                    :name => rfw_name_for(object_name, "#{i.column_name}_type"),
                    :value => model_class,
                    :key => 'model_name'
                  },
                  {
                    :type => 'hidden',
                    :name => rfw_name_for(object_name, "#{i.column_name}_id"),
                    :value => id,
                    :key => 'model_id'
                  },
                 ],
                 { :controller => 'pick/lump', :action => 'search', :mode => 'company' },
                 s_('rfw|submit_tag|Pick'))
    when ItemPlural
      picker_field = i.picker_field(it, object_name)
      ids = rfw_value_for(object_name, i.column_name)
      values = Person.joints(ids).map(&:name)
      rfw_picker([{
                    :type => 'text',
                    :name => "picker_#{picker_field}",
                    :value => values.join(','),
                    :key => 'people_names',
                    :html => { :readonly => true, :size => i.size_for_input_field  } },
                  {
                    :type => 'hidden',
                    :name => rfw_name_for(object_name, i.column_name),
                    :value => ids,
                    :key => 'people_ids'
                  },
                 ],
                 { :controller => 'pick/lump_people', :action => 'search', :mode => 'company' },
                 s_('rfw|submit_tag|Pick'))
    else
      raise ArgumentError, "invalid item type: #{i.class}"
    end
  end

  # メール送信部品による選択の情報を返す。
  def mailto_info
    mail = params[:mail] || {}
    if mail[:recipients]
      if mail[:recipients].is_a?(String)
        mail[:recipients] = mail[:recipients].split(/,/).map(&:to_i)
      end
      recipients = Person.find(mail[:recipients])
      info = select_tag "_mail_info", options_from_collection_for_select(recipients, "id", "name_with_in", 0)
      mail[:recipients] = mail[:recipients].join(",")
    else
      recipients = []
      info = ""
    end
    num = text_field_tag "_mail_num", recipients.size, :readonly => true, :size => 2, :class => "mail_num", :id => nil
    info << ns_("rfw|mailto_info|%{num} person", "%{num} people", recipients.size) % { :num => num }
    mail.keys.each do |key|
      info << hidden_field_tag("mail[#{key}]", mail[key], :id => nil)
    end
    return info
  end

  # 詳細画面へのリンクを返す。
  def display_aspect(controller, view)
    url = {:controller => controller, :action => "show", :id => @it.id, :type => @model_class, :product_id => @product.id}
    if /\Ashow/ =~ params[:action] || request.xhr?
      javascript_tag(remote_function(:update => view, :url => url))
    else
      link = link_to_view_motion(s_(controller), view, "show", {}, url, :class => "autoload button")
      content_tag(:div, link, :class => "left_buttons")
    end
  end

  # タブとして表示する詳細画面へのリンクを返す。
  def display_aspect_as_tab(controller, view)
    url = {:controller => controller, :action => "show_as_tab", :id => @it.id, :type => @model_class, :product_id => @product.id}
    if /\Ashow/ =~ params[:action] || request.xhr?
      javascript_tag(remote_function(:update => view, :url => url))
    else
      link = link_to_view_motion(s_(controller), view, "show_as_tab", {}, url, :class => "autoload button")
      content_tag(:div, link, :class => "left_buttons")
    end
  end

  # サマリへのリンクを返す。
  def summary_aspect(controller)
    url = {:controller => controller, :action => "summary", :id => @it.id, :type => @model_class, :product_id => @product.id}
    javascript_tag(remote_function(:update => "summary_#{controller.pluralize}", :url => url))
  end

  # 関連文書を選択するためのリンクを返す。
  def link_to_select_document(it)
    return "" if @relatable && (it == @relatable || @product.document_nodes_for(@relatable).include?(it))
    link_to_remote(tree_icon_open,
                   :update => "document_table_base",
                   :complete => visual_effect(:highlight, "document_table", :queue => {:scope => "document", :limit => 2, :position => "end"}),
                   :url => {:controller => "document", :action => "select", :id => params[:id], :type => params[:type], :product_id => params[:relatable_product_id], :target_id => it.id, :target_type => it.class.to_s, :target_product_id => @product.id})
  end

  # 一覧検索(汎用検索)の設定画面へのリンクを返す。
  def link_to_search
    return "" unless @product.search?

    if @display.searching? then
      caption = h(s_("rfw|Product|Looking for"))
      serching =" searching"
    else
      caption = h(s_("rfw|Product|Search"))
      serching =""
    end

    link_to_remote(caption,
                   { :update => "view_search",
                     :url => {:controller => "search", :action => "index"},
                     :with => "'display_id=' + $F('list')",
                   },
                   {:class => "button#{serching}"})
  end

  # 一覧の設定画面へのリンクを返す。
  def link_to_list
    link_to_view_motion(h(s_("rfw|Product|List")), "view_list", @product.id,
                        {},
                        {:controller => "list", :action => "index", :id => @product.id},
                        {:class => "button reloadable_link"})
  end

  # 画面上下に配置されるボタン群を返す。
  def button_box(suffix)
    buttons = {}
    if params[:form_type] == "task_new" || @form_type == "judgment_add"
      buttons[:left] = link_to_close({:id => nil, "_" => suffix}, {:action => "list", :id => nil}, :class => "button")
    elsif params[:id] && @display.button_back? ||  @form_type == "judgment_edit"
      buttons[:left] = link_to_view_motion(h(s_("rfw|button|Back")),
                                           @current_view, "show",
                                           {:id => params[:id], "_" => suffix},
                                           {:action => "show", :id => params[:id],:project=>params[:project], :segment=>params[:segment], :segment_checklist=>params[:segment_checklist], :list_type=>@list_type },
                                           :class => "button reloadable_link") 
    elsif @display.button_close?
      buttons[:left] = link_to_close({:id => nil, "_" => suffix}, {:action => "list", :id => nil}, :class => "button")
    end
    buttons[:center] = ""
    if @display.button_edit? && @product.modifiable?
      if @list_type == "JUDGMENT_LIST" && (@it.judgment != true || @judgment_info == nil || @judgment_info == [])
      else
        buttons[:center] += link_to_view_motion(h(s_("rfw|button|Edit")),
                                        @current_view, "edit",
                                        {:id => @it.id, "_" => suffix},
                                        {:action => "edit", :id => @it,:project=>params[:project], :segment=>params[:segment], :segment_checklist=>params[:segment_checklist], :list_type=>@list_type  ,:edit=>"edit"},
                                        :class => "button reloadable_link")
      end
    end
    if @display.button_copy? && @product.modifiable?
      buttons[:center] += link_to_view_motion(h(s_("rfw|button|Copy")),
                                              @current_view, "copy",
                                              {:id => @it.id, "_" => suffix},
                                              {:action => "new", :id => @it},
                                              :class => "button reloadable_link")
    end
    if @submit_tag
      buttons[:center] += @submit_tag
    end
    if @display.button_delete? && @product.modifiable? && @list_type != "JUDGMENT_LIST"
      url = {:action => "destroy", :id => @it }
      if display_workflow? && @wf_config.issue_id
        if User.current.admin?
          # keep url
        elsif @wf_config.issueable? # TODO: issueable? is neither neccesary nor sufficient
          url = url.merge(:workflow => {:issue_id => @wf_config.issue_id})
        else
          url = nil
        end
      end
      if url
        buttons[:right] = link_to_view_motion(h(s_("rfw|button|Destroy")),
                                              @current_view, "destroy",
                                              {:id => @it.id, "_" => suffix},
                                              url,
                                              :confirm => s_('rfw|confirm|Are you sure?'),
                                              :method => :post,
                                              :class => "button reloadable_link")
      end
    end
    return lcr_button_box(buttons)
  end

  def display_workflow?
    return false if %w[new create_document].include?(params[:action])
    return @display.workflow_enabled?
  end

  # ワークフローで使用するボタン群を返す
  def workflow_buttons(config, dom_id)
    html_buttons = []
    buttons = config.buttons || []
    if config.issueable?
      buttons.each do |v|
        action, label = v.key, v.value
        html_buttons << workflow_button(label, "wf_#{action}", dom_id)
      end
    else
      possible_responses = config.possible_responses
      buttons.each do |v|
        action, label = v.key, v.value
        if config.configurable? && action == 'configure'
          html_buttons << workflow_button(label, "wf_#{action}", dom_id)
        else
          # config 以外
          if possible_responses && possible_responses.include?(action)
            html_buttons << workflow_button(label, "wf_#{action}", dom_id)
          else
            html_buttons << workflow_button(label, "wf_#{action}", dom_id, { :disabled => 'true', :onclick => 'return false' })
          end
        end
      end
    end
    html_buttons.join("\n")
  end

  # ワークフローで使用するボタン(リンク)を一つ返す
  def workflow_button(label, action, dom_id, options = {})
    html_options = { :class => 'button' }
    html_options.merge!(options)
    link_to_remote(label,
                   { :update => dom_id,
                     :url => {
                       :id => @it.id,
                       :product_id => @product.id,
                       :workflow_dom_id => dom_id,
                       :action => action,
                       :method => :post } },
                   html_options)
  end

  # ワークフローの編集画面で使用するラジオボタン群を返す
  def workflow_actions(config)
    checked_value = params[:workflow][:action]
    html_actions = []
    buttons = config.buttons || []
    checked = nil
    if config.issueable?
      buttons.each do |v|
        action, label = v.key, v.value
        next if /config/ =~ action
        checked ||= (action == checked_value)
        html_actions << workflow_action(label, action, (action == checked_value))
      end
    else
      possible_responses = config.possible_responses
      buttons.each do |v|
        action, label = v.key, v.value
        next if /config/ =~ action
        checked ||= (action == checked_value)
        if possible_responses && possible_responses.include?(action)
          html_actions << workflow_action(label, action, (action == checked_value))
        else
          html_actions << workflow_action(label, action, (action == checked_value), { :disabled => 'true'})
        end
      end
    end
    html_actions << workflow_action(_('Do Nothing'), 'do_nothing', !checked)
    html_actions.join("\n")
  end

  # ワークフローで使用するラジオボタンを一つ返す
  def workflow_action(label, action, checked = false, options = {})
    tag =  radio_button_tag("workflow[action]", action, checked, options)
    tag << label_tag("workflow_action_#{action}", label)
  end

  # ワークフローで使用するコンボボックスの選択肢を返す
  def workflow_options(container, key = :id, option_name = nil, selected = nil)
    return nil unless container
    option_values = { }
    container.each do |d|
      option_values[d.name] = d.__send__(key).to_s
    end
    if option_name
      options_for_select(option_values, params[:workflow][option_name][selected])
    else
      options_for_select(option_values, params[:workflow][selected])
    end
  end

  # ワークフローで使用するラジオボタンを返す
  # FIXME: ラベルと値を分ける
  def workflow_radio_buttons(labels)
    checked_value = params[:workflow][:option][:cache] || labels.last
    html = []
    labels.each do |label|
      html << radio_button_tag("workflow[option][cache]", label, (label == checked_value))
      html << label_tag("workflow_option_cache_#{label}", _(label))
    end
    html.join("\n")
  end

  include RandomId

  # ワークフローで使用する picker を返す
  def workflow_picker_tags(i, object_name, it, assignment_id, index)
    submit_text = s_("rfw|submit_tag|Pick Person")
    option = params[:workflow][:option]
    stored_value = option[object_name.to_sym] ? option[object_name.to_sym][assignment_id.to_s].values[index] : nil
    picker_field = "workflow_person_#{object_name}_#{assignment_id}_#{index}"
    picked_class = Person
    if flash[:pick] && picker_field == flash[:pick][:field]
      values = i.picked_values(flash[:pick])
      stored_value = flash[:pick][:person]
    elsif v = picked_class.find_by_id(it[i.column_name])
      values = i.picked_references(v)
    else
      values = i.picked_keys.map {|k| k.classify.constantize.new}
    end
    e = ""
    i.picked_keys.each_with_index do |k,n|
      name = nil
      if stored_value.blank?
        stored_value = values[n].id
        name = values[n].name
      else
        name = picked_class.find(stored_value.to_i).name
      end
      e << text_field_tag("picker_#{picker_field}_#{k}", name, :readonly => true, :size => i.size_for_input_field)
      e << " "
    end
    onclick = i.picked_keys.map do |k|
      "$('picker_#{picker_field}_#{k}').addClassName('selected');"
    end.join("")
    e << submit_tag(submit_text, :name => "picker[#{picker_field}]", :onclick => onclick, :disabled => (i.readonly? || !i.writable?))
    unless error_message_on(object_name, i.column_name).blank?
      e = content_tag(:div, e, :class => "fieldWithErrors")
    end
    # hidden link for ajax
    e << link_to_view_motion("",
                             @sub_view, picker_field, {},
                             {
                               :controller   => "picker",
                               :action       => i.picked_atom,
                               :return_field => picker_field,
                               :view         => @sub_view,
                             }, :style       => "display:none")
    e << hidden_field_tag("workflow[option][#{object_name}][#{assignment_id}][#{index}]", stored_value)
    return e
  end

  # ワークフローで使用する picker を複数出力する
  # item_options = :input_parameter => 'person', :model_name => 'MatterReport'
  def workflow_picker_lines(config, object_name, it, item_options = { })
    lines = []
    item = ItemPseudo.new(item_options)
    case object_name
    when 'assignment'
      return if config.assignments.blank?
      max = workflow_assignee_maximum(config.assignments)
      c = config.assignments.first
      max.times do |n|
        lines << content_tag(:tr) do
          content_tag(:th, "#{object_name.capitalize} #{c.name}") +
            content_tag(:td, workflow_picker_tags(item, object_name, it, c.id, n))
        end
      end
    when 'candidates'
      return if config.candidateable.blank?
      config.candidateable.each do |c|
        c.assignee_maximum.times do |n|
          lines << content_tag(:tr) do
            content_tag(:th, "#{object_name.capitalize} #{c.name}") +
              content_tag(:td, workflow_picker_tags(item, object_name, it, c.id, n))
          end
        end
      end
    else
      raise "must not happen. object_name = #{object_name}"
    end
    lines.join("\n")
  end

  def workflow_assignee_maximum(assignments)
    return 0 if assignments.blank?
    assignments.map{|a| a.assignee_maximum }.max
  end

  def workflow_error_messages_for(response, *params)
    if @workflow_error
      # FIXME correct message
      message = [ content_tag(:h4, s_("rfw|message|workflow web service returns an error")),
                  content_tag(:p, response.information),
                ]
      return content_tag(:div, message.join, :class => "errorExplanation")
    end
  end

  def td_to_narrow
    return "" unless @display.narrowing?
    inputs = @display.narrowing_value_keys.map do |key|
      {:type => "hidden", :name => "narrowing_value_#{key}", :value => session[key], :key => key}
    end
    inputs.unshift({:type => "hidden", :name => "display_id", :value => @display.id, :key => "display_id"})
    inputs.unshift({
                     :type => "hidden",
                     :name => "display_narrowing_id",
                     :value => @display.active_display_narrowing(session).id,
                     :key => "display_narrowing_id"
                   })
    inputs.push({
                  :type => "text",
                  :name => "narrowing_text",
                  :value => narrowing_text,
                  :key => "narrowing_text",
                  :html => {:readonly => true,:size => "45"},
                })
    title = s_("rfw|submit_tag|Pick #{@display.active_display_narrowing(session).name}")
    picker = rfw_picker(inputs, {:controller => @display.narrowing_controller_path(session), :action => @display.narrowing_action_name(session)}, title) do |id|
      "function() {new Form.Element.Observer($('#{id}').previous(), 0.3, function(element, value) {element.form.onsubmit();});}"
    end
    content_tag(:td, picker)
  end

  def add_task_err
    mes = ""
    if @not_add_task_err == true
      count = 1
      mes = ns_("rfw|message|There was a problem with the following field.",
          "There were problems with the following fields.",
          count)
    elsif @code_err == true && @name_err == true 
      count = 2
      mes = ns_("rfw|message|There was a problem with the following field.",
      "There were problems with the following fields.",
      count)
    elsif @code_err == true || @name_err == true
      count = 1
      mes = ns_("rfw|message|There was a problem with the following field.",
          "There were problems with the following fields.",
          count)
    else
      return
    end
    return [
      '<div class="errorExplanation_base">',
      '<div class="errorExplanation_head">',
      image_tag("error.png"),
      ns_("rfw|message|%{num} error prohibited this data from being saved",
        "%{num} errors prohibited this data from being saved",
        count) % { :num => count },
      '</div>',
      '<div class="errorExplanation_detail">',
      mes,
      '</div>',
      '</div>',
    ].join("")
  end
  
end

