module Pick::PostHelper
  include Picker::Helper

  def has_children?(company_id)
    picker_model_class("post", "Post").exists?(:company_id => company_id)
  end

  def expanded?
    !@post_name.blank?
  end

  def link_to_pick_result(post)
    if params[:rfw][:company_id]
      rfw_link_to_pick(h(post.name),
                       {
                         :post_id      => post.id,
                         :post_name    => post.name,
                         :company_id   => post.company.id,
                         :company_name => post.company.name,
                       })
    else
      rfw_link_to_pick(h(post.name),
                       {
                         :post_id   => post.id,
                         :post_name => post.name,
                       })
    end
  end

end
