module Pick::DiversityHelper
  include Pick::LumpHelper

  def rfw_link_to_pick_as_element(name, values, target, template, html_options = {})
    id = "rfw_link_to_pick_#{random_id}"
    html_options.update(:id => id)
    link = link_to_function name, "", html_options
    link << javascript_tag(<<-JS)
      (function(){
        if ($('#{id}')) {
          $('#{id}').observe('click', Rfw.pickAsElement.bindAsEventListener($('#{id}'), #{values.to_json}, #{target}, '#{template}'));
        }
      }).defer();
    JS
    link
  end

  def link_to_pick_group_members(group)
    case group
    when picker_model_class("diversity", "Company")
      t = "company_members"
    when picker_model_class("diversity", "Organization")
      t = "organization_members"
    when picker_model_class("diversity", "Group")
      t = "group_members"
    when picker_model_class("diversity", "PersonalGroup")
      t = "personal_group_members"
    else
    end
    g_ms = Array.new
    group.__send__("#{t}").each do |g_m|
     g_ms << picker_model_class("diversity", "Person").find(g_m.person_id)
    end
    values = group.people
    values = values & g_ms
    values = values.sort_by(&:id)
    values = values.map{|person| { :id => person.id, :name => person.name } }
    name = "person_\#{id}_#{random_id}"
    rfw_link_to_pick_as_element(h(group.name),
                                values,
                                '$$("div.mailto > ul")[0]',
                                check_box_template(name))
  end

  def link_to_pick_person(person)
      name = "person_#{person.id}_#{random_id}"
      rfw_link_to_pick_as_element(h(person.name),
                                  [{ :id => person.id, :name => person.name }],
                                  '$$("div.mailto > ul")[0]',
                                  check_box_template(name))
  end

  def link_to_pick_result
    rfw_link_to_pick(s_("rfw|Mail Picker|OK"),
                     {
                       :mailto_ids => '(function(){ return $$("input.mailto_result").select(function(e){ return e.type == "checkbox" && e.checked }).map(function(e){ return e.value }).join(",") })',
                       :mailto_names => '(function(){ return $$("label.mailto_result").select(function(e){ return $(e.readAttribute("for")).checked }).map(function(e){ return e.innerHTML }).join(",") })',
                     },
                     { :class => 'button' })
  end

  def check_box_template(name)
    id = "li_\#{id}_#{random_id}"
    tags = ''
    # using prototype.js Template class
    tags << check_box_tag(name, '#{id}', true, :class => ['mailto_result'])
    tags << label_tag(name, '#{name}', :class => ['mailto_result'])
    content_tag(:li, tags, :id => id, :class => ['person_#{id}'])
  end
end
