# -*- coding: utf-8 -*-
# ファイル出力の helper を与える。
module OutputHelper
  # ファイル出力設定画面のボタンを返す。
  def output_button_box(x)
    link_to_output = submit_tag(h(s_("rfw|ConfigOutput|Output")))
    link_to_clear  = link_to_view_motion(h(s_("rfw|ConfigOutput|Clear")), "output", "clear", {"_" => x}, {:action => "clear", :id => @display_to_list.id}, :class => "button")

    @lcr_buttons = {
      :left   => link_to_close({"_" => x}, {:controller => "menu", :action => "list"}, :class => "button"),
      :center => link_to_output,
      :right  => link_to_clear,
    }
    return lcr_button_box(@lcr_buttons, "w_lcr_button_box_half")
  end

  # 必要な場合はダウンロードするためのスクリプトを返す
  def download
    return '' unless params[:action] == 'save'
    return '' unless @config_output.errors.empty?
    create_url   = url_for(:controller => 'output',
                           :action     => 'create',
                           :id         => @display_to_list.id,
                           :path       => @tempfile)
    download_url = url_for(:controller => 'output',
                           :action     => 'download',
                           :id         => @display_to_list.id,
                           :path       => @tempfile)
    js = javascript_tag(
           remote_function(:failure => 'alert(request.status.toString() + "\n" + request.responseText);',
                           :success => "(function(){ location.href='#{download_url}';}).defer();",
                           :url     => create_url))
    return js
  end

  # ファイル出力の対象になる項目のテーブルを返す。
  def tbody_items
    content = @config_output_items.map do |config_output_item|
      tr_item(config_output_item)
    end.join
    return content_tag(:tbody, content, :id => "config_output_items_tbody")
  end

  # ファイル出力の対象になる項目のノードを返す。
  def tr_item(config_output_item)
    @config_output_item = config_output_item
    return <<-HTML
    <tr id="config_output_item_#{@config_output_item.id}">
     <td>#{check_box "config_output_item[]", "enabled"}</td>
     <td>#{text_field "config_output_item[]", "name"}/#{@config_output_item.item.name}</td>
     <td class="handle"><img src="/images/drag_handle.png" width=22 height=22 class="iepngfix" /></td>
    </tr>
    HTML
  end

  # ファイル出力の対象になる項目を並び替え可能にする。
  def sortable_items
    sortable_element("config_output_items_tbody",
                     :complete => visual_effect(:highlight, "config_output_items"),
                     :url => {:action => "sort", :id => params[:id]},
                     :constraint => false,
                     :handle => "handle",
                     :tag => "tr")
  end
end
