# To change this template, choose Tools | Templates
# and open the template in the editor.

module DiversityPickerHelper
  # 選択画面のボタン群を返す。
  def picker_button_box
    @picker_button_box ||= lcr_button_box({
        :left => link_to_close({"_" => "&suffix;"}, @return_to_url, :class => "button"),
        :center => link_to_view_motion(s_("rfw|button|Clear"),
          @current_view, "clear", {"_"=>"&suffix;"},
          @pass_params_link.merge({:action => "pick"}), :class => "button"),
      }, "w_lcr_button_box_half")
    return @picker_button_box
  end

  # メールアドレス選択画面のボタン群を返す。
  def mail_picker_button_box
    @picker_button_box ||= lcr_button_box({
        :left => link_to_close({"_" => "&suffix;"}, @return_to_url, :class => "button"),
        :right => submit_tag(h(s_("rfw|Mail Picker|OK")), :name => "pick", :id => nil),
      }, "w_lcr_button_box_half")
    return @picker_button_box
  end

  # 選択肢のリンクの一覧を返す。
  def picker_list_leaf(model_name, list, options={})
    unless list.blank?
      key = "#{model_name}_id".to_sym
      list = list.map do |it|
        li_leaf_link(model_name, it, options.merge(:action => "pick", key => it.id))
      end
      return '<ul class="picker_list">' + list.join("") + '</ul>'
    end
  end

  # 選択肢のリンクを返す。
  def li_leaf_link(model_name, it, options)
    return [
      "<li>",
      tree_icon_leaf,
      link_to_view_motion(h(it.name_with_in),
        @current_view, "#{model_name}#{it.id}", {},
        @pass_params_link.merge(options), :class => "pick"),
      "</li>",
      ].join(" ")
  end

  # 選択肢のリンクの一覧を返す。
  def picker_table_leaf(model_name, records)
    if records.blank?
      contents = []
    else
      contents = records.map do |record|
        tr_leaf_link(model_name, record, @pass_params_form)
      end
    end
    contents.unshift(content_tag(:tr, [s_("rfw|Picker|Code"), s_("rfw|Picker|Name")].map {|x| content_tag(:th, h(x))}.join))
    return content_tag(:table, contents.join, :class => "picker_list", :border => 1)
  end

  # 選択肢のリンクを返す。
  def tr_leaf_link(model_name, record, options)
    contents = []
    [@record_code, @record_name].each do |m|
      if m
        record_options = {
          "#{@record_id}".to_sym => record.__send__(@record_id),
          "#{@record_name}".to_sym => record.__send__(@record_name),
          "#{@record_code}".to_sym => record.__send__(@record_code),
        }
        x = link_to_view_motion(h(record.__send__(m)),
                                @current_view, "#{model_name}#{record.id}__#{m}", {},
                                options.merge(record_options), :class => "pick")
        contents << content_tag(:td, x)
      end
    end
    return content_tag(:tr, contents.join, :class => "pick")
  end

  # 選択肢の集合に対するリンクの一覧を返す。
  def picker_list_branch_link(model_name, list)
    unless list.blank?
      key = "#{model_name}_id".to_sym
      selected_id = params[key]
      action = params[:action]
      list = list.map do |it|
        li_branch_link(model_name, it, selected_id, :action => action, key => it.id)
      end
      return '<ul class="picker_list">' + list.join("") + '</ul>'
    end
  end

  # 選択肢の集合に対するリンクを返す。
  def li_branch_link(model_name, it, selected_id, options)
    if it.id == selected_id
      css_class = "tree_icon pick selected"
      tree_icon = tree_icon_open
      name = '<span class="selected">' + h(it.name_with_in) + '</span>'
    else
      css_class = "tree_icon pick"
      tree_icon = tree_icon_close
      name = h(it.name_with_in)
    end
    return [
      "<li>",
      link_to_view_motion(tree_icon,
        @current_view, "#{model_name}#{it.id}", {},
        @pass_params_link.merge(options), :class => css_class),
      name,
      "</li>",
    ].join(" ")
  end

  # 一括選択について選択肢の集合に対するリンクの一覧を返す。
  def picker_list_branch_links_for_lump(model_name, list)
    unless list.blank?
      key = "#{model_name}_id".to_sym
      selected_id = params[key]
      list = list.map do |it|
        li_branch_links_for_lump(model_name, it, selected_id, key => it.id)
      end
      return '<ul class="picker_list">' + list.join("") + '</ul>'
    end
  end

  # 一括選択について選択肢の集合に対するリンクを返す。
  def li_branch_links_for_lump(model_name, it, selected_id, options)
    if it.id == selected_id
      css_class = "pick selected"
      tree_icon = tree_icon_open
    else
      css_class = "pick"
      tree_icon = tree_icon_close
    end
    options = @pass_params_link.merge(options)
    return [
      "<li>",
      link_to_view_motion(tree_icon,
        @current_view, "#{model_name}#{it.id}", {},
        options.merge({:action => "lump"}), :class => "tree_icon "+css_class),
      link_to_view_motion(h(it.name_with_in),
        @current_view, "#{model_name}#{it.id}pick", {},
        options.merge({:action => "pick", :lump_pick => model_name}), :class => css_class),
      "</li>",
    ].join(" ")
  end

  # その選択肢から分岐した子への submit 群を返す。
  def picker_list_branch_submit_tags(model_name, list)
    unless list.blank?
      key = "#{model_name}_id".to_sym
      selected_id = params[key]
      list = list.map do |it|
        li_branch_submit_tags(model_name, it, selected_id)
      end
      return '<ul class="picker_list">' + list.join("") + '</ul>'
    end
  end

  # その選択肢から分岐した子への submit を返す。
  def li_branch_submit_tags(model_name, it, selected_id)
    if it.id == selected_id
      css_class = "pick selected"
      tree_icon = tree_icon_open_without_tag
    else
      css_class = "pick"
      tree_icon = tree_icon_close_without_tag
    end
    return [
      "<li>",
      submit_tag("&tree_icon;", :name => "#{model_name}[open#{it.id}]", :class => "tree_icon "+css_class).sub(/&amp;tree_icon;/) { tree_icon },
      submit_tag(h(it.name_with_in), :name => "#{model_name}[pick#{it.id}]", :class => css_class),
      "</li>",
    ].join("")
  end
end
