# -*- coding: utf-8 -*-
module DestinationHelper
  # 行き先に配置する button box を返す。
  def destination_button_box
    @destination_button_box ||= lcr_button_box({
        :left => link_to_close({"_" => "&suffix;"}, @return_to_url, :class => "button"),
      })
    return @destination_button_box
  end
  
  # 選択肢のリンクの一覧を返す。
  def picker_destination_link(it)
    options ={:action => "pick",
              :return_value => it.name,
              :departure =>it.departure,
              :arrival =>it.arrival,
              :fare =>it.fare,
              :one_way_or_round_trip =>it.one_way_or_round_trip,
              :total_amount =>(it.fare.to_i*it.one_way_or_round_trip.to_i),
              }
    unless it.blank?
    link_to_view_motion(h(it.name),
                        @current_view,
                        "destination_#{it.id}",
                        {},
                        @pass_params_link.merge(options),
                        :class => "pick")
    end
  end

end
