# -*- coding: utf-8 -*-
# ユーザーを制御する。
class UserController < ApplicationController
  # layout  'user'

  TOKEN_FOR_SINGLE_SIGN_ON = :X0034343_A34343_B34343

  skip_before_filter :authenticate_user, :only => [ :login, :signup, :forgot_password, :auto ]

  # 該当するメールキューが存在しない場合のエラー。
  class MailQueueNotFound < NotFoundException; end
  # 該当する宛先が存在しない場合のエラー
  class RecipientNotFound < NotFoundException; end

  # 自動ログインを行う。
  def auto
    begin
      queue = MailQueue.find(params[:id])
    rescue ActiveRecord::RecordNotFound
      raise MailQueueNotFound, "no such mail queue"
    end
    user_id = params[:u]
    unless !user_id.blank? && (user = User.find_by_id(user_id)) && queue.recipients.include?(user.person)
      raise RecipientNotFound, "no such recipient"
    end
    session[:fragment] = [:auto, fragment_for(:menu => queue.menu, :document => queue.document)]
    session[:return_to] = return_to = "/" # default
    if session[:user_id] # already login
      if session[:user_id] == user.id
        redirect_to session[:return_to]
        session[:return_to] = nil
        return
      else
        logout(false) # user mismatch
      end
    end
    if queue.product.mail_skip_auth? && skip_authentication(user.login)
      redirect_to session[:return_to]
      session[:return_to] = nil
      return
    end
    @user = user
    render :action => "login"
  end

  # ログイン認証を行う。
  def login
    unless params[TOKEN_FOR_SINGLE_SIGN_ON].blank?
      return skip_authentication(params[TOKEN_FOR_SINGLE_SIGN_ON])
    end

    unless params[:fragment].blank?
      session[:fragment] = [:params, params[:fragment]]
    end

    if request.xhr?
      render :update do |page|
        page.insert_html :before, "view_main", "\n<!-- fragment saved -->\n" # dummy
      end
      return
    end

    return if generate_blank_form
    user = User.authenticate(params["user"]["login"], params["user"]["password"], true)
    @user = user || User.new(params["user"])
    if user
      unless user.lockout?
        reset_session
        @current_user = Thread.current[:user] = user
        init_login_session(user)
        if user.password_expire?
          create_login_history(user, LoginHistory::RESULT_PASSWORD_EXPIRED)
          reset_session_all
          redirect_to :action => "change_password"
          return
        end
        flash["notice"] = s_("rfw|flash|notice|Login succeeded")
        create_login_history(user, LoginHistory::RESULT_LOGIN_SUCCEEDED)
        redirect_back_or_default
        return
      end
    end

    @login = params["user"]["login"]
    flash['message'] = s_("rfw|flash|message|Login failed")
    create_login_history(user, LoginHistory::RESULT_LOGIN_FAILED)
  end

  # TODO: remove signup
=begin
  def signup
    return if generate_blank_form
    @user = User.new(
      :login => params['user'][:login],
      :password => params['user'][:password],
      :password_confirmation => params['user'][:password_confirmation],
      :email => params['user'][:email],
      :first_name => params['user'][:first_name],
      :last_name => params['user'][:last_name]
    )
    @user.person = Person.find(:first) # FIXME
    begin
      User.transaction do
        @user.password_needs_confirmation = true
        if @user.save
          key = @user.generate_security_token
          url = url_for(:action => 'welcome')
          url += "?user[id]=#{@user.id}&key=#{key}"
          UserNotify.deliver_signup(@user, params['user']['password'], url)
          flash['notice'] = s_("rfw|flash|notice|Signup successful! Please check your registered email account to verify your account registration and continue with the login.")
          redirect_to :action => 'login'
        end
      end
    rescue Exception => ex
      report_exception ex
      flash['message'] = s_("rfw|flash|message|Error creating account: confirmation email not sent")
    end
  end
=end

  # ログアウトする。
  def logout(will_redirect=true)
    create_login_history(@current_user, LoginHistory::RESULT_LOGOUT)
    reset_login_session
    reset_session
    if will_redirect
      redirect_to :action => 'login'
    end
  end

  # パスワードを変更する。
  def change_password
    return if generate_filled_in
    params['user'].delete('form')
    begin
      @user.change_password(params['user']['password'], params['user']['password_confirmation'])
      @user.save!
    rescue Exception => ex
      report_exception ex
      flash.now['message'] = s_("rfw|flash|message|Your password could not be changed at this time. Please retry.")
      render and return
    end
    # succeeded to change
    redirect_to :controller => "menu", :action => "index"
    begin
      UserNotify.deliver_change_password(@user, params['user']['password'])
    rescue Exception => ex
      report_exception ex
    end
  end

  # パスワードを忘れた場合の処理を行う。
  def forgot_password
    if authenticated_user?
      flash['message'] = s_("rfw|flash|message|You are currently logged in. You may change your password now.")
      redirect_to :action => 'change_password'
      return
    end

    return if generate_blank_form

    login = params['user']['login']
    if login.empty?
      flash.now['message'] = s_("rfw|flash|message|Please enter a valid login name.")
    elsif (user = User.find_by_login(login)).nil?
      flash.now['message'] = s_("rfw|flash|message|We could not find a user with the login %{login}") % {:login => CGI.escapeHTML(login)}
    else
      begin
        User.transaction do
          key = user.generate_security_token
          url = url_for(:action => 'change_password')
          url += "?user[id]=#{user.id}&key=#{key}"
          UserNotify.deliver_forgot_password(user, url)
          flash['notice'] = s_("rfw|flash|notice|Instructions on resetting your password have been emailed to %{login}.") % {:login => CGI.escapeHTML(login)}
          unless authenticated_user?
            redirect_to :action => 'login'
            return
          end
          redirect_back_or_default
        end
      rescue Exception => ex
        report_exception ex
        flash.now['message'] = s_("rfw|flash|message|Your password could not be emailed to %{login}") % {:login => CGI.escapeHTML(login)}
      end
    end
  end

  # ユーザー情報の変更を行う。
  def edit
    return if generate_filled_in
    if params['user']['form']
      form = params['user'].delete('form')
      begin
        case form
        when "edit"
          unclean_params = params['user']
          user_params = unclean_params.delete_if { |k,v| not User::CHANGEABLE_FIELDS.include?(k) }
          @user.attributes = user_params
          @user.save
          flash.now['notice'] = s_("rfw|flash|notice|User has been updated.")
        when "change_password"
          change_password
        when "delete"
          delete
        else
          raise "unknown edit action"
        end
      rescue Exception => ex
        logger.warn ex
        logger.warn ex.backtrace
      end
    end
  end

  # ユーザーを削除する。
  def delete
    @user = @current_user || User.find_by_id( session[:user_id] )
    begin
      @user.update_attribute( :deleted, true )
      logout
    rescue Exception => ex
      flash.now['message'] = s_("rfw|flash|message|Error: %{ex}.") % {:ex => ex}
      redirect_back_or_default
    end
  end

  # ログイン後に表示する。
  def welcome
  end

  # protected
  private

  def protect?(action)
    if ['login', 'signup', 'forgot_password'].include?(action)
      return false
    else
      return true
    end
  end

  # Generate a template user for certain actions on get
  def generate_blank_form
    if request.method == :get || !params[:user]
      @user = User.new
      render
      return true
    end
    return false
  end

  # Generate a template user for certain actions on get
  def generate_filled_in
    @user = @current_user || User.find_by_id( session[:user_id] )
    case request.method
    when :get
      render
      return true
    end
    return false
  end

  def report_exception( ex )
    logger.warn ex
    logger.warn ex.backtrace.join("\n")
  end
end
