class PjcTaskController < ApplicationController

  def index
      set_task
      redirect_to :action => :schedule_list
      @task_tree_close_all = true
  end
  
  def set_task
      root = PjcTask.root
      @full_set = root.full_set
      @task = root.children
  end
  
  def schedule_list
      @login_user = User.current
      # プロダクトID
      if params[:product_id]
        @menu_select_product_id = params[:product_id]
        session[:menu_select_product_id] = params[:product_id]
      else
        @menu_select_product_id = session[:menu_select_product_id]
      end
      begin
        @menu_id=Menu.find(:first,:conditions =>["product_id =?",@menu_select_product_id]).id
      rescue
        @menu_id=0
      end
      view_in :m
      prepare_display_to_list
      if @display.narrowing? 
        if params[:narrowing_text] || params[:pj_segment_id]
          session[:display_narrowing] ||= HashWithIndifferentAccess.new
          if params[:pj_segment_id]
            display_narrowing = DisplayNarrowing.find(:first,:conditions =>["display_id =? and column_name =?",@display.id,"segment_id"])
          elsif params[:display_narrowing_id].blank? || params[:display_narrowing_id].to_i == 0
            display_narrowing = @display.active_display_narrowing(session)
          else
            display_narrowing = DisplayNarrowing.find(params[:display_narrowing_id].to_i)
          end
          dns = DisplayNarrowing.find(:all, :select => "display_id", :conditions => {:narrowing_id => display_narrowing.narrowing_id})
          dns.map(&:display_id).each do |display_id|
            session[:display_narrowing][display_id] ||= HashWithIndifferentAccess.new
            session[:display_narrowing][display_id][:id] = display_narrowing.narrowing_id
          end
          @display.narrowing_value_keys.each do |key|
            session[key] = nil
          end
          @display.narrowing_value_keys(session).each do |key|
            unless params[:pj_segment_id]
              session[key] = params[:"narrowing_value_#{key}"]
            else
              session[:project_segment_id] =params[:pj_segment_id]
            end
          end
        end
        @display.narrow_to(session)
      end
      @items.each{|item|
        next unless item.condition_pattern == 'custom'
        keys = item.condition_value.split(';').last.split(',').map{|v| v.strip.to_sym }
        hash = {}
        keys.each{|k| hash[k] = params[k] }
        if hash.values.reject{|v| v.blank? }.empty?
          item.condition_hash = session["#{@display.id}_#{item.id}}"]
        else
          item.condition_hash = hash
          session["#{@display.id}_#{item.id}}"] = item.condition_hash
        end
      }
      # 初めてmenu一覧から進捗一覧を選択するときに、画面のdisplay_idをsessionとして記録する
      if params[:task_record] 
         session[:task_display_id] = @display.id
         session[:selected_task_id] =nil   # コピーアンドペーストの選択
      end       
      display_id = @display.id
      domain_id = @login_user.domain_id
      person_id = @login_user.person_id
      # 画面を変更すると、全部のsessionを空になる
      unless display_id == session[:task_display_id]
          session[:select_unit] =nil    #金額の選択
          session[:task_memories] =nil  #check_boxの選択
          session[:appointed_day] =nil  #選択した日付
          session[:center_day] =nil     #選択した中心の日
          session[:period_selection] =nil    # 期間の選択
          session[:chart_switch] =nil        # チャートの選択
          session[:person_chart_switch] =nil # チャートの選択
          session[:rate_chart_switch] =nil        # グラフタイプの選択
          session[:person_rate_chart_switch] =nil # グラフタイプの選択
          session[:chart_move_type] =nil     # チャートタイプの選択
          session[:selected_task_id] =nil    # コピーアンドペーストの選択
      end
      #######################
      # 履歴ID(menuテーブルのtaskのmotion項目の中に履歴product_id追加)
      if params[:record_product_id]
          @task_record_product_id = params[:record_product_id]
          session[:record_product_id] = params[:record_product_id]
      else
          @task_record_product_id = session[:record_product_id]       
      end

      # 金額の情報
      if params[:unit] && (display_id == session[:task_display_id])
         @select_unit = params[:unit].to_i
         session[:select_unit] = params[:unit].to_i
      else
         @select_unit = session[:select_unit].to_i
      end
      # EVM画面遷移の情報 menuから直接表示する時、まずDBから記憶内容を取得する
      if params[:task_record]
         task_memory =PjcTaskMemory.find(:first, :conditions =>["domain_id =? and display_id = ? and person_id = ?",domain_id,display_id,person_id]) 
         if task_memory.display_type == true
            @select_evm_list = "list"
         else
            @select_evm_list = "evm_list"
         end 
      elsif params[:evm_list]
         @select_evm_list = params[:evm_list]
         session[:evm_list] = params[:evm_list]
      elsif session[:evm_list]
         @select_evm_list = session[:evm_list]
      elsif task_memory =PjcTaskMemory.find(:first, :conditions =>["domain_id =? and display_id = ? and person_id = ?",domain_id,display_id,person_id]) 
         if task_memory.display_type == true
            @select_evm_list = "list"
         else
            @select_evm_list = "evm_list"
         end
      end
    
      # チェックボックスの情報
      if params[:task_memory] && (display_id == session[:task_display_id])
         @task_memories = params[:task_memory]
         session[:task_memories] = params[:task_memory]
      else
         @task_memories = session[:task_memories]    
      end
      # menuから直接表示する時、まずDBから記憶内容を取得する
      if params[:task_record] || (display_id != session[:task_display_id]) 
         #@params[:task_memory]がnilの場合、まずDatabaseから記憶内容を取得する。（メニュー押下時）
         @task_memory = PjcTaskMemory.find(:first, :conditions => ["domain_id =? and display_id = ? and person_id = ?",domain_id, display_id, person_id ])
         unless @task_memory
           @task_memory = PjcTaskMemory.new
         end
         session[:task_memories] = @task_memory.attributes
      elsif params[:task_memory] 
         @task_memory ||= PjcTaskMemory.new
         @task_memory.attributes = params[:task_memory]
      else
         @task_memory ||= PjcTaskMemory.new
         @task_memory.attributes = session[:task_memories]  
      end
      # コピーアンドペースト
      if session[:selected_task_id]
         @selected_task_id = session[:selected_task_id]
         @selected_task_name = session[:selected_task_name]
         @selected_task_code = session[:selected_task_code]
         @task_date_type = session[:task_date_type]
      else
         @selected_task_id =nil
         @selected_task_name =nil
         @selected_task_code =nil
         @task_date_type =nil         
      end
      open_and_shut_list(display_id, person_id, params[:task_id], params[:task_open_and_shut])
      unit_choice
      evm_list(domain_id, person_id, display_id)
          
      if @display.code == "CHART_LIST"
          # 実績と予定の切り替え
          if params[:rate_chart_switch]
             @rate_chart_switch = params[:rate_chart_switch]
             session[:rate_chart_switch] = params[:rate_chart_switch]
          elsif session[:rate_chart_switch]
             @rate_chart_switch = session[:rate_chart_switch]
          else
             task_memory = PjcTaskMemory.find(:first, :conditions => ["domain_id =? and display_id = ? and person_id = ?",domain_id, display_id, person_id ])        
               if task_memory
                  if task_memory.graph_type ==true
                     @rate_chart_switch ="rate"
                  else
                     @rate_chart_switch ="weight_rate"
                  end                  
               else  
                  @rate_chart_switch ="rate"
               end  
          end
          # 画面の切り替え
          if params[:chart_switch] 
             @chart_switch = params[:chart_switch]
             session[:chart_switch] = params[:chart_switch]
          elsif session[:chart_switch]
             @chart_switch = session[:chart_switch]
          else
             task_memory = PjcTaskMemory.find(:first, :conditions => ["domain_id =? and display_id = ? and person_id = ?",domain_id, display_id, person_id ])        
             if task_memory
                if task_memory.display_type ==true
                   @chart_switch ="task_chart" 
                else
                   @chart_switch ="task_chart_switch"
                end                  
             else  
                @chart_switch ="task_chart"
             end             
          end
          # 選択した日の情報
          if params[:appointed_day] && (display_id == session[:task_display_id])
             @appointed_day = (params[:appointed_day]).to_date
             session[:appointed_day] = params[:appointed_day]
          elsif session[:appointed_day]
             @appointed_day = (session[:appointed_day]).to_date
          end
          
          if params[:center_day] && (display_id == session[:task_display_id])
             @center_day = (params[:center_day]).to_date
             session[:center_day] = params[:center_day]
          elsif session[:center_day]
             @center_day = (session[:center_day]).to_date
          end
          @html_follow = ""          
          
          #期間選択の単位選択
          if params[:period_selection] && (display_id == session[:task_display_id])
             @selected_period = params[:period_selection]
             session[:period_selection] = params[:period_selection]
          elsif session[:period_selection]
             @selected_period = session[:period_selection] 
          else
             task_memory = PjcTaskMemory.find(:first, :conditions => ["domain_id =? and display_id = ? and person_id = ?",domain_id, display_id, person_id ])
             if task_memory
                @selected_period = task_memory.record_of_certain_term
             else
                @selected_period = "two_weeks"               
             end
          end
                    
          if params[:chart_move_type] && (display_id == session[:task_display_id])
              @chart_move_type = params[:chart_move_type]
              session[:chart_move_type] = params[:chart_move_type]
              @center_day =nil
          elsif session[:chart_move_type]
              @chart_move_type = session[:chart_move_type]
          else
              @chart_move_type == "start"  
          end
          
          if params[:move_type] && (display_id == session[:task_display_id])
            
             if params[:move_type] == "center"
                if @center_day
                   task_day = @center_day
                else
                   task_day = Date.today
                end
                case @selected_period
                  when "two_weeks"
                       @appointed_day =(task_day -7)                     
                  when "one_month"
                       @appointed_day =(task_day -15)                      
                  when "three_months"
                       @appointed_day =(task_day -46)                     
                  when "six_months"
                       @appointed_day =(task_day -92)                     
                  when "one_year"
                       @appointed_day =(task_day -183)                      
                  when "two_years"
                       @appointed_day =(task_day -365)                     
                  when "three_years"
                       @appointed_day =(task_day -548)                                         
                end
                session[:appointed_day] = @appointed_day               
             end
          end
          prepare_period_to_list
      end
      
      if @display.code == "PERSON_CHART_LIST"
          if params[:person_rate_chart_switch]
             @person_rate_chart_switch = params[:person_rate_chart_switch]
             session[:person_rate_chart_switch] = params[:person_rate_chart_switch]
          elsif session[:person_rate_chart_switch]
             @person_rate_chart_switch = session[:person_rate_chart_switch]
          else
             task_memory = PjcTaskMemory.find(:first, :conditions => ["domain_id =? and display_id = ? and person_id = ?",domain_id, display_id, person_id ])        
             if task_memory
                if task_memory.graph_type ==true
                   @person_rate_chart_switch ="person_rate"
                else
                   @person_rate_chart_switch ="person_weight_rate"
                end                  
             else  
                @person_rate_chart_switch ="person_rate"
             end
          end
          # 画面の切り替え
          if params[:person_chart_switch]
             @person_chart_switch = params[:person_chart_switch]
             session[:person_chart_switch] = params[:person_chart_switch]
          elsif session[:person_chart_switch]
             @person_chart_switch = session[:person_chart_switch]
          else
             task_memory = PjcTaskMemory.find(:first, :conditions => ["domain_id =? and display_id = ? and person_id = ?",domain_id, display_id, person_id ])        
             if task_memory
                if task_memory.display_type ==true
                   @person_chart_switch ="person_task_chart" 
                else
                   @person_chart_switch ="person_task_chart_switch"
                end                  
             else  
                @person_chart_switch ="person_task_chart"
             end
          end
          # 選択した日の情報
          if params[:appointed_day] && (display_id == session[:task_display_id])
             @appointed_day = (params[:appointed_day]).to_date
             session[:appointed_day] = params[:appointed_day]
          elsif session[:appointed_day]
             @appointed_day = (session[:appointed_day]).to_date
          end
          
          if params[:center_day] && (display_id == session[:task_display_id])
             @center_day = (params[:center_day]).to_date
             session[:center_day] = params[:center_day]
          elsif session[:center_day]
             @center_day = (session[:center_day]).to_date
          end
          @html_follow = ""          
          
          #期間選択の単位選択
          if params[:period_selection] && (display_id == session[:task_display_id]) 
             @selected_period = params[:period_selection]
             session[:period_selection] = params[:period_selection]
          elsif session[:period_selection]
             @selected_period = session[:period_selection] 
          else
             task_memory = PjcTaskMemory.find(:first, :conditions => ["domain_id =? and display_id = ? and person_id = ?",domain_id, display_id, person_id ])
             if task_memory
                @selected_period = task_memory.record_of_certain_term
             else
                @selected_period = "two_weeks"               
             end
          end

          if params[:chart_move_type] && (display_id == session[:task_display_id])
              @chart_move_type = params[:chart_move_type]
              session[:chart_move_type] = params[:chart_move_type]
              @center_day =nil
          elsif session[:chart_move_type]
              @chart_move_type = session[:chart_move_type]
          else
              @chart_move_type == "start"  
          end
      
          if params[:move_type] && (display_id == session[:task_display_id])
             if params[:move_type] == "center"
                if @center_day
                   task_day = @center_day
                else
                   task_day = Date.today
                end
                case @selected_period
                  when "two_weeks"
                       @appointed_day =(task_day -7)                     
                  when "one_month"
                       @appointed_day =(task_day -15)                      
                  when "three_months"
                       @appointed_day =(task_day -46)                     
                  when "six_months"
                       @appointed_day =(task_day -92)                     
                  when "one_year"
                       @appointed_day =(task_day -183)                      
                  when "two_years"
                       @appointed_day =(task_day -365)                     
                  when "three_years"
                       @appointed_day =(task_day -548)                                         
                end
                # 開始日と中心日のsession更新処理
                session[:appointed_day] = @appointed_day
                session[:center_day] = @center_day           
             end
          end
          prepare_period_to_list
      end
      save_memory(domain_id, person_id, display_id, params[:task_memories_botton])
      if @display.code != "PJ_LIST"
        options =@display.query_options(session)
      else
        options ={}
      end

      if params[:pj_segment_id]
        options[:conditions]
      end
      # プロジェクト共通部品を合わせるための条件を追加する
      if options[:conditions] && options[:conditions] !=""
        task =PjcTask.find(:first,:conditions =>options[:conditions])
        if task
          @framework_project_id =task.project_id
          if options[:conditions].index(/segment_id/)
             @framework_segment_id =task.segment_id
          else
             @framework_segment_id =nil
          end
          project_id =@framework_project_id
          segment_id =@framework_segment_id
        else
          project_id =nil
          segment_id =nil
        end
      else
        project_id =nil
        segment_id =nil
      end
      options.update(:select => "tasks.*,
                                task_evm_totals.delayed_days_before_start,
                                task_evm_totals.delayed_days_until_finish,
                                task_evm_totals.plan_progress_rate,
                                task_evm_totals.planed_value,
                                task_evm_totals.earned_value,
                                task_evm_totals.schedule_variance,
                                task_evm_totals.schedule_performance_index,
                                task_evm_totals.cost_variance,
                                task_evm_totals.cost_performance_index,
                                task_evm_totals.estimate_to_comlete,
                                task_evm_totals.estimate_at_completion,
                                task_evm_totals.variance_at_completion")
      options.update(:joins => "LEFT JOIN task_evm_totals ON tasks.id = task_evm_totals.task_id
                                LEFT JOIN projects ON tasks.project_id = projects.id")
      options.update(:order => "tasks.project_id, tasks.segment_id, tasks.lft,task_evm_totals.total_date")
      options[:conditions] ||="tasks.id !=0"
      # タスクレベルの情報
      if params[:level] && (display_id == session[:task_display_id])
       unless  params[:level] =="all"
         @select_level=params[:level]
       else
         @select_level="all"
       end
       session[:select_level]=params[:level]
      elsif session[:select_level]
       if session[:select_level] =="all"
          @select_level=session[:level_max]
       elsif session[:level_max] && session[:level_max]<session[:select_level].to_i
          @select_level=session[:level_max].to_s
       else
          @select_level=session[:select_level]
       end
      else
       @select_level =0
      end
      setup_list_id
      setup_per_page(@model_class, options) do |default_per_page|
        sync_fragment("m", :per, default_per_page)
      end
      sync_fragment("m", :page, 1)
      memory_conditions(@task_memory, options, project_id, segment_id)
      level_choice(person_id, display_id,project_id,segment_id, params[:level],options[:conditions])
      display_searching=@display.searching?
      if @display.code == "PJ_LIST" # PJ別進捗一覧
         options[:conditions] +=" and tasks.data_type='segment'"
         @pages, @things = task_paginate(@model_class,@login_user,options, @display.id,display_searching)
      elsif @display.code == "PERSON_LIST" # 担当者別進捗一覧
         options[:conditions] +=" and tasks.data_type != 'project'"
         options[:conditions] +=" and tasks.person_in_charge_of_work_id IS NOT NULL"
         options[:joins] +=" LEFT JOIN people ON tasks.person_in_charge_of_work_id = people.id"
         options.update(:order => "people.phonetic, tasks.lft")
         display_type ="PERSON_LIST"
         @pages, @things = task_paginate(@model_class,@login_user,options, @display.id,display_searching,*display_type)
      elsif @display.code == "LIST" # 日程別進捗一覧
         @pages, @things = task_paginate(@model_class, @login_user, options, @display.id,display_searching)
      elsif @display.code == "CHART_LIST" # 日程別チャート一覧
         @pages, @things = task_paginate(@model_class, @login_user, options, @display.id,display_searching)
         task_chart_list_table_data
      elsif @display.code == "PERSON_CHART_LIST"  # 担当者別チャート一覧
         options[:conditions] +=" and tasks.data_type!='project'"
         options[:conditions] +=" and tasks.person_in_charge_of_work_id IS NOT NULL"
         options[:joins] +=" LEFT JOIN people ON tasks.person_in_charge_of_work_id = people.id"
         options.update(:order => "people.phonetic, tasks.lft")
         display_type ="PERSON_LIST"
         @pages, @things = task_paginate(@model_class, @login_user, options, @display.id,display_searching,*display_type)
         task_person_chart_list_table_data    
      end
      @header_per_line = User.list_header_per_line
      # 画面display_idのsession情報の更新
      session[:task_display_id] = display_id
      # 再表示ボタンやperのonchangeのときにpageの変更と同じように
      # fragmentのpopup部分を削除する。
      if params["dummy_button"]
        delete_sub_view_fragment(@current_view.sub(/\Aview_/, ""))
      end
      session[:v] =nil
  end
  #################################
  
  # 詳細画面を表示する。
  def show
    @menu_select_product_id = params[:product_id]
    view_in :detail
    prepare_display_to :show
    if params[:precede_session]
      session[:v] =nil
    end
    begin
      @it = @model_class.find(params[:id], :readonly => true)
    rescue ActiveRecord::RecordNotFound
      flash[:notice] = s_("rfw|flash|notice|It does not exists.")
      x_close_or_redirect_to :action => "schedule_list"
      return
    end
    if @product.is_a?(ProductDetailed)
      prepare_details
    end

    if @display.mail?
      @disable_mailsend = true
      if params[:mail] && !params[:mail][:recipients].blank?
        @disable_mailsend = false
      end
      if !@disable_mailsend && params[:mailsend]
        mail_to_queue(@it, true)
      end
    end
    @id_suffix = "#{@it.id}of#{@product.id}"
    # コストの単位選択
    @cost_unit = [[s_("PjcTask|Task_select_tag|cost_yen"),"Yen"],[s_("PjcTask|Task_select_tag|cost_ten_thousands_yen"),"Ten_Thousands_Yen"],[s_("PjcTask|Task_select_tag|cost_million_yen"),"Million_Yen"]]
    @selected_cost_unit =params[:cost_unit_selection]
    # 日付の単位選択
    @date_unit = [[s_("PjcTask|Task_select_tag|day"),"day"],[s_("PjcTask|Task_select_tag|week"),"week"],[s_("PjcTask|Task_select_tag|month"),"month"]]
    if params[:date_unit_selection]
       @selected_date_unit =params[:date_unit_selection]
    else
       @selected_date_unit ="week"
    end
    @graph_evm = open_flash_chart_object(920,600, "/pjc_task/task_gruff/#{@it.id}?gruff_type=graph_evm")
    @graph_variance = open_flash_chart_object(920,600, "/pjc_task/task_gruff/#{@it.id}?gruff_type=graph_variance")
  end
  
  def change_gruff
      @graph_evm =open_flash_chart_object(920,600, "/pjc_task/task_gruff/#{params[:id]}?selected_cost_unit=#{params[:cost_unit_selection]}&selected_date_unit=#{params[:date_unit_selection]}&gruff_type=graph_evm")
      @graph_variance =open_flash_chart_object(920,600, "/pjc_task/task_gruff/#{params[:id]}?selected_cost_unit=#{params[:cost_unit_selection]}&selected_date_unit=#{params[:date_unit_selection]}&gruff_type=graph_variance")
      render :text =>@graph_evm.gsub(/d27cdb6e/, "graph_evm")+@graph_variance.gsub(/d27cdb6e/, "graph_variance")
  end
  
  def task_gruff
      data_pv_forecast =LineDot.new(1,3.5,'#0000E3')
      data_pv_forecast.key("PV",10)

      data_ev =LineDot.new(1,3.5,'#28FF28')
      data_ev_forecast =LineHollow.new(1,3.5,'#28FF28')
      data_ev.key("EV", 10)
      
      data_ac =LineDot.new(1,3.5,'#FF0000')
      data_ac_forecast =LineHollow.new(1,3.5,'#FF0000')
      data_ac.key('AC', 10)
      
      data_cpi =LineDot.new(1,3.5,'#0000E3')
      data_cpi.key("CPI",10)

      data_spi =LineDot.new(1,3.5,'#28FF28')
      data_spi.key("SPI", 10)    
      
      task_id=params[:id]
      today = Date.today
      selected_cost_unit =params[:selected_cost_unit]
      selected_date_unit =params[:selected_date_unit]

      # 日付の単位変更
      x_label =[]
      # 実績のデータ
      task_pv =[]
      task_ev =[]
      task_ac =[]
      # 予測のデータ
      task_pv_forecast =[]
      task_ev_forecast =[]
      task_ac_forecast =[]
      # SPIとCPIのデータ
      task_spi =[]
      task_cpi =[]
      
      if PjcTaskEvmTotal.find(:first, :conditions =>["task_id =?",task_id], :order =>:total_date)
         first_day =PjcTaskEvmTotal.find(:first, :conditions =>["task_id =?",task_id], :order =>:total_date).total_date
      end
      
      if PjcTaskEvmTotal.find(:first, :conditions =>["task_id =?",task_id], :order =>"total_date desc")
         last_day =PjcTaskEvmTotal.find(:first, :conditions =>["task_id =?",task_id], :order =>"total_date desc").total_date
      end
      
      if selected_date_unit && first_day && last_day 
         case selected_date_unit
            when "day"
                x_label =PjcTaskEvmTotal.find(:all, :conditions =>["task_id =?",task_id], :order =>:total_date).map(&:total_date)
                task_ev =PjcTaskEvmTotal.find(:all, :conditions =>["task_id =? and total_date <=?",task_id,today.strftime("%Y%m%d")], :order =>:total_date).map(&:earned_value)
                task_ac =PjcTaskEvmTotal.find(:all, :conditions =>["task_id =? and total_date <=?",task_id,today.strftime("%Y%m%d")], :order =>:total_date).map(&:actual_cost)
                task_pv_forecast =PjcTaskEvmTotal.find(:all, :conditions =>["task_id =?",task_id], :order =>:total_date).map(&:planed_value)
                task_ev_forecast =PjcTaskEvmTotal.find(:all, :conditions =>["task_id =?",task_id], :order =>:total_date).map(&:earned_value)
                task_ac_forecast =PjcTaskEvmTotal.find(:all, :conditions =>["task_id =?",task_id], :order =>:total_date).map(&:actual_cost)
                task_spi =PjcTaskEvmTotal.find(:all, :conditions =>["task_id =? and total_date <=?",task_id,today.strftime("%Y%m%d")], :order =>:total_date).map(&:schedule_performance_index)
                task_cpi =PjcTaskEvmTotal.find(:all, :conditions =>["task_id =? and total_date <=?",task_id,today.strftime("%Y%m%d")], :order =>:total_date).map(&:cost_performance_index)
            when "week"
                while first_day.to_date<=last_day.to_date
                   x_label << first_day
                   task_first_day =PjcTaskEvmTotal.find(:first, :conditions =>["task_id =? and total_date=?",task_id,first_day])
                   if task_first_day
                     if first_day.to_date<today+7
                        task_ev  << task_first_day.earned_value
                        task_ac  << task_first_day.actual_cost
                        task_spi << task_first_day.schedule_performance_index
                        task_cpi << task_first_day.cost_performance_index
                     end
                     task_pv_forecast << task_first_day.planed_value
                     task_ev_forecast << task_first_day.earned_value
                     task_ac_forecast << task_first_day.actual_cost
                   end
                   first_day =(first_day.to_date+7).to_s.gsub("-","")                 
                end
                x_label << first_day
                task_last_day = PjcTaskEvmTotal.find(:first, :conditions =>["task_id =? and total_date=?",task_id,last_day])
                if task_last_day
                  task_pv_forecast << task_last_day.planed_value
                  task_ev_forecast << task_last_day.earned_value
                  task_ac_forecast << task_last_day.actual_cost
                end
            when "month"
                while first_day.to_date<=last_day.to_date
                   x_label << first_day
                   task_first_day =PjcTaskEvmTotal.find(:first, :conditions =>["task_id =? and total_date=?",task_id,first_day])
                   if task_first_day
                     if first_day.to_date<=today
                        task_ev  << task_first_day.earned_value
                        task_ac  << task_first_day.actual_cost
                        task_spi << task_first_day.schedule_performance_index
                        task_cpi << task_first_day.cost_performance_index
                     end
                     task_pv_forecast << task_first_day.planed_value
                     task_ev_forecast << task_first_day.earned_value
                     task_ac_forecast << task_first_day.actual_cost
                     first_day =(first_day.to_date.next_month).to_s.gsub("-","")
                   end
                end
                x_label << first_day
                task_last_day =PjcTaskEvmTotal.find(:first, :conditions =>["task_id =? and total_date=?",task_id,last_day])
                if task_last_day
                  task_pv_forecast << task_last_day.planed_value
                  task_ev_forecast << task_last_day.earned_value
                  task_ac_forecast << task_last_day.actual_cost
                end
         end
      elsif first_day && last_day # 初期値として単位は週
                while first_day.to_date<=last_day.to_date
                   x_label << first_day
                   task_first_day = PjcTaskEvmTotal.find(:first, :conditions =>["task_id =? and total_date=?",task_id,first_day])
                   if task_first_day
                     if first_day.to_date<=today
                       task_ev  << task_first_day.earned_value
                       task_ac  << task_first_day.actual_cost
                       task_spi << task_first_day.schedule_performance_index
                       task_cpi << task_first_day.cost_performance_index
                     end
                     task_pv_forecast << task_first_day.planed_value
                     task_ev_forecast << task_first_day.earned_value
                     task_ac_forecast << task_first_day.actual_cost
                   end
                   first_day =(first_day.to_date+7).to_s.gsub("-","")
                end
                x_label << first_day
                task_last_day = PjcTaskEvmTotal.find(:first, :conditions =>["task_id =? and total_date=?",task_id,last_day])
                if task_last_day
                  task_pv_forecast << task_last_day.planed_value
                  task_ev_forecast << task_last_day.earned_value
                  task_ac_forecast << task_last_day.actual_cost
                  task_spi << task_last_day.schedule_performance_index
                  task_cpi << task_last_day.cost_performance_index
                end
      else  # データがnilの場合は縦軸が今日から一年間のデータに設定する
          today =Date.today
          while today < Date.today.next_year
              x_label << today
              today +=7 
          end
      end
      task_max_1 =PjcTaskEvmTotal.maximum(:actual_cost,:conditions =>["task_id =? and actual_cost !='nil'",task_id])
      task_max_2 =PjcTaskEvmTotal.maximum(:planed_value,:conditions =>["task_id =? and planed_value !='nil'",task_id])

      if task_max_1.to_i>task_max_2.to_i
        task_max=task_max_1
      else
        task_max=task_max_2
      end

      if task_max.to_i >0

         s =task_max.to_i.to_s.size # task_max の長さ
         y =task_max.to_s[0,1].to_i # 文字列の第一個数字
         if s<5                     # 一万円以下の場合、y_max =10000
           y_max =10000
         else
           y_max =(y+1)*10**(s-1)
         end
      else
         y_max =1000000  # データがnilの場合は横軸が100万円に設定する        
      end
      
      if selected_cost_unit
         case selected_cost_unit
           when "Yen"
              x =1
           when "Ten_Thousands_Yen"
              y_max =y_max/10000
              x=10000
           when "Million_Yen"
              y_max =y_max/1000000
              x=1000000
         end              
      else  
         x =1
      end
      
      t =0
      (0..x_label.size-1).each do |i|
        # 実績のデータ
        if task_ev[t] && task_ev[t] !=0
           data_ev.add_data_tip(task_ev[t].to_f/x, "(Date#{i})")
        else
           data_ev.add_data_tip(nil, "(Date#{i})")         
        end
        if task_ac[t] && task_ac[t] !=0
           data_ac.add_data_tip(task_ac[t].to_f/x, "(Date#{i})")
        else
           data_ac.add_data_tip(nil, "(Date#{i})")
        end
        # 予測のデータ
        if task_pv_forecast[t] && task_pv_forecast[t] >=0
           data_pv_forecast.add_data_tip(task_pv_forecast[t].to_f/x, "(Date#{i})")
        else
           data_pv_forecast.add_data_tip(nil, "(Date#{i})")
        end
        if task_ev_forecast[t] && task_ev_forecast[t] !=0
           data_ev_forecast.add_data_tip(task_ev_forecast[t].to_f/x, "(Date#{i})")
        else
           data_ev_forecast.add_data_tip(nil, "(Date#{i})")          
        end
        if task_ac_forecast[t] && task_ac_forecast[t] !=0
           data_ac_forecast.add_data_tip(task_ac_forecast[t].to_f/x, "(Date#{i})")
        else
           data_ac_forecast.add_data_tip(nil, "(Date#{i})")        
        end
        #SPIとCPIのデータ
        if task_spi[t] && task_spi[t] !=0
           data_spi.add_data_tip(task_spi[t].to_f/x, "(Date#{i})")
        else
           data_spi.add_data_tip(nil, "(Date#{i})")          
        end
        
        if task_cpi[t] && task_cpi[t] !=0
           data_cpi.add_data_tip(task_cpi[t].to_f/x, "(Date#{i})")
        else
           data_cpi.add_data_tip(nil, "(Date#{i})")          
        end
        t +=1
      end
      # 横軸単位の設定
      if x_label.size >50
         among =7
      elsif x_label.size >30
         among =3
      else   
         among =1
      end
      
      g = Graph.new
      if params[:gruff_type] =="graph_evm"
        title_task_evm_date =s_("PjcTask|evm_title|task_evm_date")
        g.title(title_task_evm_date, "{font-size: 12px; color: #736AFF}")
        g.data_sets << data_pv_forecast
        g.data_sets << data_ev_forecast
        g.data_sets << data_ev
        g.data_sets << data_ac_forecast
        g.data_sets << data_ac

        g.set_tool_tip('#x_label# [#val#]<br>#tip#')
        g.set_x_labels(x_label)
        g.set_x_label_style(10, '#CC3399', 2, among)
        g.set_bg_color('#E0FFFF')
        g.set_y_max(y_max)
        g.set_y_label_steps(10)
        g.set_x_legend(s_("PjcTask|evm_title|task_data"),10,"#736AFF")
      else
        g.title(s_("PjcTask|evm_title|schedule_index_and_cost_index"), "{font-size: 12px; color: #736AFF}")
        g.data_sets << data_spi
        g.data_sets << data_cpi

        g.set_tool_tip('#x_label# [#val#]<br>#tip#')
        g.set_x_labels(x_label)
        g.set_x_label_style(10, '#CC3399', 2, among)
        g.set_bg_color('#E0FFFF')
        g.set_y_max(2)
        g.set_y_label_steps(10)
        g.set_x_legend(s_("PjcTask|evm_title|task_data"),10,"#736AFF")
      end  
      
      render :text => g.render
  end

  # 詳細画面(関連文書用)を表示する。
  def show_only
    @menu_select_product_id = params[:product_id]
    @parent_view = "view_detail"
    # @current_view,@sub_view は後で設定
    prepare_display_to :show
    begin
      @it = @model_class.find(params[:id], :readonly => true)
    rescue ActiveRecord::RecordNotFound
      flash[:notice] = s_("rfw|flash|notice|It does not exists.")
      x_close_or_redirect_to :action => "schedule_list"
      return
    end
    if @product.is_a?(ProductDetailed)
      @details = @it.details
    end
    @id_suffix = "#{@it.id}of#{@product.id}"
    @current_view = "view_detail#{@it.id}of#{@product.id}"
    @sub_view = "view_subofdetail#{@it.id}of#{@product.id}"
    return if use_picker

    if @display.mail?
      @disable_mailsend = true
      if params[:mail] && !params[:mail][:recipients].blank?
        @disable_mailsend = false
      end
      if !@disable_mailsend && params[:mailsend]
        mail_to_queue(@it, true)
      end
    end
  end

  # 削除を行う。
  def destroy
    view_in :detail
    prepare_display_to :show
    raise PermissionDenied, "product is not modifiable" unless @product.modifiable?
    raise DisabledException, "disabled with respect to button" unless @display.button_delete?
    unless request.post? && params[:id] && (params[:confirm_destroy] || request.xhr?)
      begin
        @it = PjcTask.find(params[:id])
      rescue ActiveRecord::RecordNotFound
        flash[:notice] = s_("rfw|flash|notice|It has been already destroyed.")
        x_close_or_redirect_to :action => "schedule_list"
        return
      end
      # @title : same as show
      @display = Object.new
      def @display.method_missing(sym, *args)
        return false
      end
      def @display.button_back?
        return true
      end
      render :action => :confirm_destroy
      return
    end
    begin
      it = @model_class.find(params[:id])
      if @product.is_a?(ProductDetailed)
        @details = it.details
        @details.each {|d| instance_variable_set("@details_#{d.id}", d)}
      end
      # 子供の削除処理
      if it.children
        PjcTask.destroy_all(["parent_id =?",it.id])
      end
      if with_logic(it, :destroy)    
         # 上位タスクの更新処理
         if it.parent
            it.new_rank_update(it.parent)
         end
         flash[:notice] = s_("rfw|flash|notice|It was successfully destroyed.")
      else
         flash[:warning] = s_("rfw|flash|warning|It was failed to destroy.")
      end
    rescue ActiveRecord::RecordNotFound
      flash[:notice] = s_("rfw|flash|notice|It has been already destroyed.")
      x_close_or_redirect_to :action => "schedule_list"
      return
    end
    x_close_or_redirect_to :action => "schedule_list"
  end

  # 新規作成画面を表示し、新規作成を行う。
  def new
    view_in :detail
    create("form") do
      flash[:notice] = s_("rfw|flash|notice|It was successfully created.")
      x_close_or_redirect_to :action => "schedule_list"
    end
  end

  # 編集画面を表示し、編集を行う。
  def edit
    @menu_select_product_id = params[:product_id]
    if params[:precede_session]
      session[:v] =nil
    end
    view_in :detail
    prepare_display_to :edit
    begin
      @it = @model_class.find(params[:id])
    rescue ActiveRecord::RecordNotFound
      flash[:notice] = s_("rfw|flash|notice|It has been already destroyed.")
      x_close_or_redirect_to :action => "schedule_list"
      return
    end
    if params[:it]
      params[:it][:planned_start_date]=@it.planned_start_date unless params[:it][:planned_start_date]
      params[:it][:planned_finish_date]=@it.planned_finish_date unless params[:it][:planned_finish_date]
      params[:it][:operation_start_date]=@it.operation_start_date unless params[:it][:operation_start_date]
      params[:it][:operation_finish_date]=@it.operation_finish_date unless params[:it][:operation_finish_date]
      params[:it][:planned_scale]=@it.planned_scale unless params[:it][:planned_scale]
      params[:it][:actual_result_scale]=@it.actual_result_scale unless params[:it][:actual_result_scale]
      params[:it][:planned_man_hour]=@it.planned_man_hour unless params[:it][:planned_man_hour]||@it.planned_man_hour==nil
      params[:it][:actual_result_man_hour]=@it.actual_result_man_hour unless params[:it][:actual_result_man_hour]||@it.actual_result_man_hour==nil
      params[:it][:results_object]=@it.results_object unless params[:it][:results_object]
      params[:it][:task_weight]=@it.task_weight unless params[:it][:task_weight]
      params[:it][:task_weight_progress_rate]=@it.task_weight_progress_rate.to_f unless params[:it][:task_weight_progress_rate]||@it.task_weight_progress_rate==nil
      params[:it][:framework_task_id]=@it.framework_task_id.to_i unless params[:it][:framework_task_id]
      params[:it][:notes]=@it.notes unless params[:it][:notes]
      params[:it][:budget_at_completion]=@it.budget_at_completion.to_i unless params[:it][:budget_at_completion]
      if params[:it][:progress_rate]
        begin
          pre_progress_rate = Float(params[:it][:progress_rate])
          params[:it][:progress_rate] =params[:it][:progress_rate].to_f
        rescue
          params[:it][:progress_rate] =params[:it][:progress_rate]
        end
      else
        params[:it][:progress_rate] =@it.progress_rate
      end
      params[:it][:actual_cost]=@it.actual_cost.to_i unless params[:it][:actual_cost]
    end
    return if use_picker
    if @product.is_a?(ProductDetailed)
      prepare_details
      @details.each {|d| instance_variable_set("@details_#{d.id}", d)}
      begin
        @old_details = ActiveSupport::JSON.decode(params[:old_details] || "[]")
      rescue ActiveSupport::JSON::ParseError
        @old_details = []
      end
      set_new_details
      set_order_details
    end
    if params[:it]
      set_attributes
      if request.post? && params[:update]
        begin #事前チェック
              # AC入力した場合、BAC入力必須
              # error_countを追加する
              @task_error_count =0
              if (@it.actual_cost !=nil&&@it.actual_cost !=""&&@it.actual_cost!=0)&&(@it.budget_at_completion ==nil||@it.budget_at_completion =="")
                 @budget_at_completion_presence_error =s_("PjcTask|Budget at completion")
                 @task_error_count +=1
              end
              # 終了予定日入力した場合、開始予定日入力必須
              if (@it.planned_finish_date !=nil&&@it.planned_finish_date !="")&&(@it.planned_start_date ==nil||@it.planned_start_date =="")
                 @planned_start_date_presence_error =s_("PjcTask|Planned start date")
                 @task_error_count +=1
              end
              # 終了日入力した場合、開始日入力必須
              if (@it.operation_finish_date !=nil&&@it.operation_finish_date !="")&&(@it.operation_start_date ==nil||@it.operation_start_date =="")
                 @operation_start_date_presence_error_1 =s_("PjcTask|Operation start date")
                 @task_error_count +=1
              end

              # 作業開始日を入力する場合、進捗率が入力必須
              if (@it.operation_start_date!=""&&@it.operation_start_date!=nil)&&(@it.progress_rate==""||@it.progress_rate==nil)
                 @progress_rate_presence_error =s_("PjcTask|Progress rate")
                 @task_error_count +=1
              # 0<=進捗率<=100        
              elsif (@it.progress_rate!=""&&@it.progress_rate!=nil)&&(@it.progress_rate.to_f>100||@it.progress_rate.to_f<0)
                 @progress_rate_comparison_error =s_("PjcTask|Progress rate")
                 @task_error_count +=1
              # 終了日入力した場合、進捗率イコール100％は必須
              elsif (@it.operation_finish_date !=nil&&@it.operation_finish_date !="")&&(@it.progress_rate.to_f !=100)
                 @progress_rate_unequal100_error =s_("PjcTask|Progress rate")
                 @task_error_count +=1
              end
              # 進捗率が入力する場合、作業開始日が入力必須
              if (@it.progress_rate!=""&&@it.progress_rate!=nil&&@it.progress_rate.to_f!=0)&&(@it.operation_start_date==""||@it.operation_start_date==nil)
                 @operation_start_date_presence_error_2 =s_("PjcTask|Operation start date")
                 @task_error_count +=1
              end
              # 進捗率が100%の場合、開始日と終了日両方必須入力
              if (@it.progress_rate.to_f==100)&&(@it.operation_finish_date==""||@it.operation_finish_date==nil)
                 @operation_finish_date_presence_error =s_("PjcTask|Operation finish date")
                 @task_error_count +=1
              end
          if with_logic(@it, :update)
             # タスクの履歴を更新する
              task_record = PjcTaskRecord.create(task_record_update(@it))
             # 先行タスクの更新処理
             if params[:old_precede_task_id] && params[:it_precede_task_id]
                precede_task_update(params[:old_precede_task_id], params[:it_precede_task_id], @it)
             # 先行タスク履歴の更新処理
                params[:it_precede_task_id].split(/,/).each do |p|
                  precede_task_record_update(task_record,p)
                end                    
             end
             # マイルストーン履歴生成処理
             task_milestones =PjcTaskMilestone.find(:all,:conditions=>["domain_id =? and task_id =?",@it.domain_id,@it.id])
             if task_milestones && task_milestones !=[]
                task_milestones.each do |d|
                   task_detail_update(task_record,d)
                end 
             end   
             # 自分の更新処理
                @it.task_evm_total_create_children(@it)
                @it.task_evm_total_update_children(@it)                
             # 上位タスクの更新処理
             if @it.parent
                @it.new_rank_update(@it.parent)
             elsif @it.data_type =="segment"
                p =PjcTask.find(:first,:conditions =>{:project_id =>@it.project_id,:data_type =>"project"})
                @it.new_rank_update(p)
             end
             flash[:notice] = s_("rfw|flash|notice|It was successfully updated.")
             x_close_or_redirect_to :action => "schedule_list"
             return
          end
        rescue ActiveRecord::StaleObjectError
          @stale_object_error = true
        end
      end
    end
    render :action => "edit"
  end
  # タスクのコピーアンドペースト
  def task_copy_and_paste_validate
    if session[:selected_task_id]
       @selected_task_name =session[:selected_task_name] if session[:selected_task_name]
       @selected_task_code =session[:selected_task_code] if session[:selected_task_code]
       @task_date_type =session[:task_date_type] if session[:task_date_type]
       task = PjcTask.find(:first,:conditions=>["id=?",session[:selected_task_id]])
    end
    @it = PjcTask.find(params[:id])
    if task&&(@task_date_type =="cut" && (task.all_children.index(@it) !=nil || session[:selected_task_id] ==params[:id]))
      render :update do |page|
        page.hide "view_detail" 
        page.call("alert",s_("PjcTask|error_message|can not paste on low_rank"))
      end
    elsif session[:selected_task_id] == nil
      render :update do |page|
        page.hide "view_detail" 
        page.call("alert",s_("PjcTask|error_message|a task must be selected"))
      end
    elsif task&&task.segment_id!=@it.segment_id
      render :update do |page|
        page.hide "view_detail" 
        page.call("alert",s_("PjcTask|error_message|can not process for other segment")) 
      end   
    else 
      render :update do |page|
        page.call("onAjaxLink","link_detail_record_#{@it.id}") 
      end
    end    
  end
  # コピーアンドペーストのpickerを表示する
  def task_copy_and_paste_picker
      view_in :detail
      @menu_select_product_id =session[:menu_select_product_id]
      if session[:selected_task_id]
         @selected_task_id =session[:selected_task_id]
         @selected_task_name =session[:selected_task_name] if session[:selected_task_name]
         @selected_task_code =session[:selected_task_code] if session[:selected_task_code]
         @task_date_type =session[:task_date_type] if session[:task_date_type]
      end
      @it = PjcTask.find(params[:id])
      @task_copy_children = @it.children
      render :partial =>"task_copy_and_paste_picker"      
  end
  #コピーアンドペースト処理
  def task_copy_and_paste
      view_in :detail
      if params[:it]  
        if request.post? && params[:paste]
           begin
              if params[:task_row][0] && params[:selected_task_id]
                 selected_task = PjcTask.find(params[:selected_task_id])          # 選択したタスク
                 if params[:task_date_type] && params[:task_date_type]=="cut" # タスクのカット処理(カット元の再計算が要らない) 
                    old_selected_task =selected_task.parent
                    if params[:task_row][0] !=""
                       pasted_task = PjcTask.find(params[:task_row][0])
                       unless pasted_task.id ==selected_task.id                     
                          selected_task.move_to_left_of(pasted_task)            # カット元の移動処理
                       end   
                    elsif params[:pasted_task_id]
                       pasted_task = PjcTask.find(params[:pasted_task_id])
                       selected_task.move_to_child_of(pasted_task)              # 末尾に追加する
                    end
                    old_selected_task.new_rank_update(old_selected_task)        # 元のタスクの更新処理                            
                    selected_task.task_level =selected_task.level               #タスクのレベルを更新する
                    selected_task.save!
                    if selected_task.children!=[]
                      selected_task.all_children.each do |s|
                        s.task_level=s.level
                        s.save!
                      end
                    end
                    if selected_task.parent
                       selected_task.new_rank_update(selected_task.parent)      # 今の上位タスクの更新処理
                    end
                 else                                                           # タスクのコピー処理
                    if params[:pasted_task_id]
                       all_children =selected_task.all_children                       
                       pasted_task =PjcTask.find(params[:pasted_task_id])
                       copy_parent =PjcTask.new
                       copy_parent =selected_task.clone
                       copy_parent.save!
                       if params[:task_row][0] !=""
                          copy_parent.move_to_left_of(PjcTask.find(params[:task_row][0]))
                       else
                          copy_parent.move_to_child_of(pasted_task)
                       end
                       copy_parent.task_level =copy_parent.level
                       copy_parent.save!
                       # タスク履歴情報を生成する
                       task_record =PjcTaskRecord.create(task_record_update(copy_parent))
                       # 先行タスクのコピー
                       if precede_task = PjcPrecedeTask.find(:all,:conditions =>["task_id=?", params[:selected_task_id]])
                          precede_task.each do |p|
                             copy_precede =PjcPrecedeTask.new
                             copy_precede =p.clone
                             copy_precede.task_id =copy_parent.id
                             copy_precede.save!
                             precede_task_record_update(task_record,p.task_id)
                          end
                       end
                       # milestoneのコピー
                       if task_milestone =PjcTaskMilestone.find(:all,:conditions =>["task_id=?", params[:selected_task_id]])
                          task_milestone.each do |m|
                             copy_milestone =PjcTaskMilestone.new
                             copy_milestone =m.clone
                             copy_milestone.task_id =copy_parent.id
                             copy_milestone.save!
                             task_detail_update(task_record,m)
                          end
                       end
                       task_copy_to(selected_task,copy_parent,all_children) #タスクのコピー処理                     
                    end 
                 end
                 session[:selected_task_id]=nil
                 flash[:notice] = s_("rfw|flash|notice|It was successfully updated.")
                 x_close_or_redirect_to :action => "schedule_list"
                 return
              end  
           rescue ActiveRecord::StaleObjectError
              @stale_object_error = true
           end
        end
      end
  end
  
     # タスクのコピー処理
  def task_copy_to(parent,copy_parent,all_children)
      if parent.children !=[]
         parent.children.each do |task|
           if all_children.index(task) !=nil
             copy_task =PjcTask.new
             copy_task =task.clone
             copy_task.save!
             copy_parent.add_child(copy_task)
             copy_task.task_level =copy_task.level
             copy_task.save!
             # タスク履歴情報を生成する
             PjcTaskRecord.create(task_record_update(copy_task))             
             task_copy_to(task,copy_task,all_children)
           end
         end
      else
         copy_parent.task_evm_total_create_children(copy_parent)  # 自分の更新
         copy_parent.task_evm_total_update_children(copy_parent)  # 自分の更新(追加)
         # 上位タスクの更新処理
         if copy_parent.parent
           copy_parent.new_rank_update(copy_parent.parent)
         elsif copy_parent.data_type =="segment"
           p =PjcTask.find(:first,:conditions =>{:project_id =>copy_parent.project_id,:data_type =>"project"})
           copy_parent.new_rank_update(p)
         end
      end
  end
  
  # 関連文書を選択するための一覧を表示する。
  def select_document
    view_in :document
    prepare_display_to_list
    options = @display.query_options(session)
    setup_per_page(@model_class, options) do |default_per_page|
      params[:per] ||= default_per_page
    end
    @pages, @things = paginate(@model_class, options)
    @header_per_line = User.list_header_per_line
    begin
      @relatable = params[:type].constantize.find(params[:id])
    rescue
      @relatable = nil
    end
  end

  # 関連文書向けに新規作成する
  def create_document
    @copying = false
    view_in :document
    create("create_document") do
      p = {
        :type => params[:type],
        :product_id => params[:relatable_product_id],
        :target_id => @it.id,
        :target_type => @it.class.to_s,
        :target_product_id => @product.id,
      }
      p[:id] = params[:id] unless params[:id].blank?
      render :update do |page|
        page << "new Ajax.Updater('document_table_base', '#{url_for(:controller => "document", :action => "select")}', {onComplete: function(){$('view_dp').innerHTML = '';}, parameters: #{p.to_json}})"
      end
    end
  end

  # 詳細を並び替える。
  def order_details
    render :update do |page|
      seed = params[:seed]
      unless seed.blank?
        page["order_details_#{seed}"].value = params["details_table_body_#{seed}"].to_json
        page.sortable("details_table_body_#{seed}",
                      :format => "/^(details_[0-9]+|new_details_[0-9]+)$/",
                      :complete => visual_effect(:highlight, "details_table_#{seed}"),
                      :url => {:action => "order_details", :seed => seed},
                      :constraint => "vertical",
                      :handle => "handle",
                      :tag => "tr")
      end
    end
  end
  
  def add_detail
    
  end
  # copy and paste
  def task_date_edit
      if params[:selected_task_id]
         @selected_task_id = params[:selected_task_id]
         session[:selected_task_id] = params[:selected_task_id]
      else
         @selected_task_id =""
      end
      if params[:selected_task_name]
         @selected_task_name = params[:selected_task_name]
         session[:selected_task_name] = params[:selected_task_name]
      else
         @selected_task_name =""
      end
      if params[:selected_task_code]
         @selected_task_code = params[:selected_task_code]
         session[:selected_task_code] = params[:selected_task_code]
      else
         @selected_task_code =""
      end
      if params[:task_date_type]
         @task_date_type = params[:task_date_type]
         session[:task_date_type] = params[:task_date_type]
      else
         @task_date_type =""
      end
      render :partial =>"task_selected_column"      
  end
    
  #################################
  
  private

  def view_in(key)
    case key
    when :m
      @parent_view = "view_main"
      @current_view = "view_m"
      @sub_view = "view_detail"
    when :detail
      @parent_view = "view_m"
      @current_view = "view_detail"
      @sub_view = "view_picker"
    when :document
      @parent_view = "view_de"
      @current_view = "view_dp"
      @sub_view = "view_dpp"
    end
    params[:id] ||= fetch_fragment(@current_view.sub(/\Aview_/, ""), "id", nil)
  end
  
  def setup_list_id
    params[:list] ||= fetch_fragment("m", :list, nil)
    update_fragment("m", :list, @default_list && @default_list.display_id)
  end
  
  def setup_per_page(model_class, options, &block)
    @allowed_per_page_options = ALLOWED_PER_PAGE.map do |n|
      if n == 0
        [s_("rfw|select|option|ALL"), n]
      else
        [(ns_("rfw|select|option|per %{n} page", "per %{n} pages", n) % {:n => n}), n]
      end
    end

    default_per_page = User.list_default_per_page
    yield(default_per_page) if block_given?
    per_page = params[:per].to_i
    if per_page == 0
      options[:per_page] = count_collection_for_pagination(model_class, options)
    elsif ALLOWED_PER_PAGE.include?(per_page)
      options[:per_page] = per_page
    else
      options[:per_page] = per_page = default_per_page
    end
    options[:per_page] = 1 if options[:per_page] <= 0
  end
  
  def set_new_details
    begin
      @new_details = ActiveSupport::JSON.decode(params[:new_details] || "[]")
    rescue ActiveSupport::JSON::ParseError
      @new_details = []
    end
    @new_details.each do |n|
      d = @product.detail_class.new
      d.header = @it
      instance_variable_set("@new_details_#{n}", d)
    end
  end

  def set_order_details
    begin
      @order_details = ActiveSupport::JSON.decode(params[:order_details] || "[]")
    rescue ActiveSupport::JSON::ParseError
      @order_details = []
    end
  end
  
  def create(template, &block)
    prepare_display_to :new
    params[:mail] ||= {}
    if session[:task_type]
      session[:v] =nil
      session[:task_type]
    end
    @it = @model_class.new
    # 初めて登録画面を開いた時にセッション情報を削除処理 
    if params[:task_addition] && session[:picker]=={}
       session[:new_tasks] =nil
    end
    if params[:id]
      begin
        @task_title = PjcTask.find(params[:id])
      rescue ActiveRecord::RecordNotFound
        raise NotFoundException, "task not found"
      end
    end
    @details = []
    @old_details = []
    return if use_picker
    begin
      unless params[:task_id]
        @task_title=PjcTask.find(@task_title.id)
      else
        @task_title=PjcTask.find(params[:task_id])      
      end
    rescue ActiveRecord::RecordNotFound
      raise NotFoundException, "task not found" 
    end    
    @task_children_all =[]
    if @task_title
       @task_children_all = @task_title.children
    end
    delete_date=nil
    if params[:count]
      session[:new_tasks].each{|y|
         if y[0]==params[:count].to_i
            delete_date =y
         end
      }
      session[:new_tasks]=session[:new_tasks]-[delete_date]
    end 
    if session[:new_tasks] && session[:new_tasks] !=[]
       session[:new_tasks].sort_by{|s|s[0]}.each do |new_task|
         if new_task
           if params[:count_all]
             if new_task[0] >=params[:count_all].to_i
                new_task.fill(new_task[0]-1,0,1)
             end 
           end       
           @task_children_all[new_task[0],0] =PjcTask.new(new_task[1])
         end
       end
    end
    @task_children_all=@task_children_all-[nil]
    if @product.is_a?(ProductDetailed)
      set_new_details
      set_order_details
    end
    if params[:it]
      set_attributes
      session[:new_tasks] ||=[]
      session[:uploaded_attachments] ||= []
      if request.post? && params[:create_new_task]
        # create
        # 終了予定日入力した場合、開始予定日入力必須
        @task_error_count =0
        if (@it.planned_finish_date !=nil&&@it.planned_finish_date !="")&&(@it.planned_start_date ==nil||@it.planned_start_date =="")
           @planned_start_date_presence_error ="Planned start date"
           @task_error_count +=1
        end
        if valid?(@it)&&@planned_start_date_presence_error==nil
           @task_children_all[params[:task_row][0].to_i,0] =@it
           session[:new_tasks].each{|x|
             if x&&x[0]>=params[:task_row][0].to_i
                x[0]=x[0]+1
             end
           }
           session[:new_tasks][params[:task_row][0].to_i,0]=[[params[:task_row][0].to_i,params[:it],params[:it_precede_task_id]]]
           session[:new_tasks]=session[:new_tasks]-[nil] 
           @it =@model_class.new
           session[:v] =nil
        end
      elsif request.post? && params[:create]
        if (@task_children_all && @task_children_all !=[]) && (session[:new_tasks] && session[:new_tasks] !=[])
           i =nil
           n =0
           parent_task = PjcTask.find(params[:task_id])
           @task_children_all.reverse.each do |t| # 全行降順並び
             if t.id ==nil
                added_task = PjcTask.new
                added_task =t.clone
                added_task.project_id =parent_task.project_id
                added_task.segment_id =parent_task.segment_id
                added_task.data_type ="task"
                added_task.lock_version =0
                if added_task.planned_start_date
                  added_task.planned_start_date =added_task.planned_start_date.gsub("/","").gsub("-","")
                end
                if added_task.planned_finish_date
                  added_task.planned_finish_date =added_task.planned_finish_date.gsub("/","").gsub("-","")
                end
                added_task.save!
                # タスク履歴情報生成
                task_record = PjcTaskRecord.create(task_record_update(added_task))
                # 先行タスクデータ生成
                if session[:new_tasks][n]
                  unless session[:new_tasks][n][2] ==""
                      session[:new_tasks][n][2].split(/,/).each do |p|                        
                          PjcPrecedeTask.create(:domain_id =>"#{added_task.domain_id}",
                                             :task_id =>"#{added_task.id}",
                                             :precede_task_id =>"#{p}") 
                  # 先行タスク履歴生成                    
                          precede_task_record_update(task_record,p)
                      end                 
                  end
                end
                n +=1                                   
             end
             if added_task  #新たな行を追加する場合
                added_task.task_evm_total_create_children(added_task) # 自分のEVMデータ計算
                parent_task.add_child(added_task) # 親の中に入れる、一行目が一番したに登録
                if i
                   had_task = PjcTask.find(i)
                   added_task.move_to_left_of(had_task)
                end
                i = added_task.id #　自分のidを保存する
                parent_task.person_in_charge_of_work_id = ""
                parent_task.task_weight = ""
                added_task.task_level =added_task.level #レベルの更新
                added_task.save!
             else  # 存在した行のIDを保存する
                i = t.id   
             end   
             parent_task.save!             
           end
           parent_task.new_rank_update(parent_task)
           yield
           return
        else # 何も登録されない状態で「作成」するとエラーになる
          @no_task_error =true
        end
      end
      return render(:action =>"form")
    end

    # start creating a brand new it
    if @display.attachment?
      # clean up uploaded_attachments
      session[:uploaded_attachments] ||= []
      session[:uploaded_attachments].delete_if do |attachment|
        @it.is_a?(attachment.attachable_type.constantize) && !attachment.attachable_id && attachment.destroy
      end
    end
    if @display.document?
      # clean up added documents
      session[:added_documents] ||= []
      session[:added_documents].delete_if do |document|
        @it.is_a?(document.relatable_type.constantize) && !document.relatable_id
      end
    end
    render :action =>"form"
  end
  
  def default_url_options(options)
    h = super || {}
    h.merge({
        :product_id => params[:product_id],
      })
    return h
  end

  def set_attributes
    @items.each {|i| i.set_attributes(@it, params[:it])}
    @it.lock_version = params[:it][:lock_version]
    add_singleton_validations(@it, @items)
    if @product.is_a?(ProductDetailed)
      @details.each do |d|
        unless @old_details.include?(d.id)
          detail = instance_variable_get("@details_#{d.id}")
          @detail_items.each {|i| i.set_attributes(detail, params["details_#{d.id}".to_sym])}
          add_singleton_validations(detail, @detail_items)
        end
      end
      @new_details.each do |n|
        if detail = instance_variable_get("@new_details_#{n}")
          @detail_items.each {|i| i.set_attributes(detail, params["new_details_#{n}".to_sym])}
          add_singleton_validations(detail, @detail_items)
          if @product.respond_to?(:pivot)
            unless @product.pivot.blank?
              detail["#{@product.pivot}_id".to_sym] = @product.id
              detail["#{@product.pivot}_type".to_sym] = @product.class.name
            end
          end
        end
      end
    end
  end
  
  def add_singleton_validations(x, items, action = :save)
    x.extend ::CustomValidations::SingletonValidateable
    items.each {|i| i.apply_validations(x, action) } unless items.blank?
  end

  def valid?(it)
    v = it.valid?
    if @product.is_a?(ProductDetailed)
      @details.each do |d|
        unless @old_details.include?(d.id)
          detail = instance_variable_get("@details_#{d.id}")
          v &= detail.valid?
        end
      end
      @new_details.each do |n|
        detail = instance_variable_get("@new_details_#{n}")
        v &= detail.valid?
      end
    end
    return v
  end
  
   def valid_on_destroy?(it)
    v = it.valid_on_destroy?
    if @product.is_a?(ProductDetailed)
      @details.each do |d|
        detail = instance_variable_get("@details_#{d.id}")
        v &= detail.valid_on_destroy?
      end
    end
    return v
  end

  def with_before_and_after(detail, *options)
    action = options.first
    message = (action == :destroy) ? :destroy : :save
    case message
    when :destroy
      add_singleton_validations(detail, @detail_items, :destroy)
      unless detail.valid_on_destroy?
        raise BusinessLogic::Failure, "validation on destroy was failed"
      end
    end
    unless detail = @display.inject_logic(:before, detail, action)
      raise BusinessLogic::Failure, "beforeprocess returns #{detail}, so reverted"
    end
    unless detail.__send__(message)
      raise "#{detail} could not process, so reverted"
    end
    unless after = @display.inject_logic(:after, detail, action)
      raise BusinessLogic::Failure, "afterprocess returns #{after}, so reverted"
    end
  end

  def with_logic(it, *options)
    action = options.first
    message = (action == :destroy) ? :destroy : :save
    newbie = it.new_record?
    if message == :save
      return false unless valid?(it)
      return false if @budget_at_completion_presence_error||@planned_start_date_presence_error||
                      @planned_start_date_comparison_error||@operation_start_date_presence_error_1||
                      @operation_start_date_comparison_error||@progress_rate_presence_error||
                      @progress_rate_comparison_error||@operation_start_date_presence_error_2||
                      @operation_finish_date_presence_error||@progress_rate_unequal100_error
    end
    if message == :destroy
      add_singleton_validations(it, @items, :destroy)
      return false unless valid_on_destroy?(it)
    end
    # validate before executing
    # execute
    it.class.transaction do
      unless it = @display.inject_logic(:pre, it, action)
        raise "preprocess returns #{it}, so reverted"
      end
      unless it.__send__(message)
        raise "#{it} could not process, so reverted"
      end
      if @product.is_a?(ProductDetailed)
        unless mid = @display.inject_logic(:mid, it, action)
          raise "midprocess returns #{mid}, so reverted"
        end
        if message == :save
          details = []
          @details.each do |d|
            detail = instance_variable_get("@details_#{d.id}")
            if @old_details.include?(d.id)
              with_before_and_after(detail, :destroy)
            else
              with_before_and_after(detail, *options)
              if k = params[:order_details].index("details_#{d.id}")
                details[k] = detail
              end
            end
          end
          @new_details.each do |n|
            detail = instance_variable_get("@new_details_#{n}")
            detail.header = it
            with_before_and_after(detail, *options)
            if k = params[:order_details].index("new_details_#{n}")
              details[k] = detail
            end
          end
          # order details
#          details.each_with_index {|detail,k| detail.insert_at(k + 1) if detail}
        else
          @details.each do |d|
            detail = instance_variable_get("@details_#{d.id}")
            with_before_and_after(detail, *options)
          end
        end
      end
      if message == :save
        commit_attachments(it, newbie) if @display.attachment?
        commit_documents(it, newbie) if @display.document?
        mail_to_queue(it) if @display.mail?
      end
      unless post = @display.inject_logic(:post, it, action)
        raise "postprocess returns #{post}, so reverted"
      end
    end
    return true
  end
  # マイルストーン履歴情報の更新処理 
  def task_detail_update(task_record,m)
      t = Time.new.strftime("%Y/%m/%d")
         PjcTaskMilestoneRecord.create(:date_of_change =>"#{t}", :change_person_id => :created_by,
                                    :task_milestone_id =>"#{m.id}", :task_record_id =>"#{task_record.id}",
                                    :code =>"#{m.code}", :name =>"#{m.name}",
                                    :milestone_progress_rate =>"#{m.milestone_progress_rate}",
                                    :operation_finish_date =>"#{m.finish_date}")
  end
  
  # 先行タスクの更新処理　
  def precede_task_update(old_id, new_id, it)
      old_precede_task = old_id.split(/,/)
      new_precede_task = new_id.split(/,/)
      d = []
      new_precede_task.each do |n|
          if old_precede_task.include?(n)
             d << n
          else
             PjcPrecedeTask.create(:domain_id =>"#{it.domain_id}", :task_id => "#{it.id}", :precede_task_id => "#{n.to_i}")                     
          end  
      end
      (old_precede_task - d).each do |x|
           precede_destroy = PjcPrecedeTask.find(:first, :conditions =>["domain_id = ? and task_id = ? and precede_task_id = ?", it.domain_id, it.id, x.to_i])
           precede_destroy.destroy                    
      end
  end
  # タスク履歴の更新処理 
  def task_record_update(it)
      t = Time.new.strftime("%Y/%m/%d")
      new_record ={:date_of_change => "#{t}", :change_person_id => User.current.person_id, 
                              :project_id => "#{it.project_id}", :segment_id => "#{it.segment_id}",
                              :task_id => "#{it.id}", :code => "#{it.code}",:name => "#{it.name}",
                              :planned_start_date => "#{it.planned_start_date}",:planned_finish_date => "#{it.planned_finish_date}",
                              :operation_start_date => "#{it.operation_start_date}", :operation_finish_date => "#{it.operation_finish_date}",
                              :planned_scale => "#{it.planned_scale}", :actual_result_scale => "#{it.actual_result_scale}",
                              :planned_man_hour => "#{it.planned_man_hour}", :actual_result_man_hour => "#{it.actual_result_man_hour}", 
                              :results_object => "#{it.results_object}", :task_weight => "#{it.task_weight}", 
                              :person_in_charge_of_work_id => "#{it.person_in_charge_of_work_id}", :progress_rate => "#{it.progress_rate}", 
                              :budget_at_completion => "#{it.budget_at_completion}", :actual_cost => "#{it.actual_cost}",
                              :number_of_operating_days => "#{it.number_of_operating_days}",
                              :note => "#{it.notes}"}
      return new_record
  end
  
  def precede_task_record_update(task_record,p)
      t = Time.new.strftime("%Y/%m/%d")
      PjcPrecedeTaskRecord.create(:domain_id =>"#{task_record.domain_id}",        
                               :date_of_change =>"#{t}",
                               :change_person_id =>"#{task_record.change_person_id}",
                               :task_record_id =>"#{task_record.id}",
                               :precede_task_id =>"#{p}",
                               :confirmation_of_delete => 0)
  end

  # return true when rendered
  def use_picker
    session[:task_pick_return_product_id] = @menu_select_product_id
    session[:picker] ||= {}
    picker_session = session[:picker]
    if picker_session[:it_before_picker] &&
        picker_session[:return_to] &&
        picker_session[:return_to][:controller] == params[:controller] &&
#        picker_session[:return_to][:product_id] == params[:product_id] &&
        picker_session[:return_to][:action] == params[:action]
#        picker_session[:return_to][:id] == params[:id]
      unless @it.readonly?
        params[:it] = picker_session[:it_before_picker]
        @items.each {|i| i.set_attributes(@it, params[:it])}
        @it.lock_version = params[:it][:lock_version]
        @task_title.id = picker_session[:it_parent_task_id] if @task_title&&picker_session[:return_to][:action]=="new"
      end
      params[:mail] = picker_session[:mail_before_picker]
      if @product.is_a?(ProductDetailed)
        %w|new_details old_details order_details|.each do |k|
          params[k.to_sym] = picker_session["#{k}_before_picker".to_sym]
        end
        picker_session.each do |k,v|
          if /\A((?:new_)?details_\d+)_before_picker\z/ =~ k.to_s
            params[$1.to_sym] = v
          end
        end
      end
      session[:picker] = nil
      if flash[:pick]
        if flash[:pick][:mail]
          params[:mail] = flash[:pick][:mail]
        end
      end
    elsif params[:picker]
      picker, = params[:picker].keys
      # 勤務報告用のためtask_selectを追加
      if /\A(?:mail|(company|organization|person|post|group|calendar|lump|precede_task)(\d+)(?:_(?:new_)?details_\d+)?)\z/ =~ picker  
        field = $1 || "mail"
        item_id = $2
        if "calendar" == field
          item = Item.find(item_id)
          if /\A(\d{4})\D?(\d{1,2})/ =~ params[:it][item.column_name]
            flash[:year], flash[:month] = $1, $2
          end
        end
        picker_session[:return_to] = {
          :controller => params[:controller],
          :product_id => params[:product_id],
          :action     => params[:action],
          :id         => params[:id]
        }
        picker_session[:it_before_picker] = params[:it] || {}
        picker_session[:it_parent_task_id] = params[:task_id] 
        picker_session[:mail_before_picker] = params[:mail]
        if @product.is_a?(ProductDetailed)
          %w|new_details old_details order_details|.each do |k|
            picker_session["#{k}_before_picker".to_sym] = params[k.to_sym]
          end
          params.each do |k,v|
            if /\A(?:new_)?details_\d+\z/ =~ k.to_s
              picker_session["#{k}_before_picker".to_sym] = v
            end
          end
        end
        x_redirect_to @sub_view, picker, {
          :controller   => "picker",
          :action       => field,
          :return_field => field,
        }
        return true
      end
    end
    return false
  end

  def commit_attachments(x, newbie)
    if session[:deleted_attachments].is_a?(Array)
      session[:deleted_attachments].delete_if do |attachment|
        attachment.attachable == x && attachment.destroy
      end
    end
    if session[:uploaded_attachments].is_a?(Array)
      if newbie
        session[:uploaded_attachments].delete_if do |a|
          if x.is_a?(a.attachable_type.constantize) && !a.attachable_id
            a.attachable_id = x.id
            a.save
          else
            false
          end
        end
      else
        session[:uploaded_attachments].delete_if {|a| x == a.attachable && a.save}
      end
    end
  end

  def commit_documents(x, newbie)
    if !newbie && session[:deleted_documents].is_a?(Array)
      session[:deleted_documents].delete_if(&:destroy)
    end
    if session[:added_documents].is_a?(Array)
      if newbie
        session[:added_documents].delete_if do |d|
          if x.is_a?(d.relatable_type.constantize) && !d.relatable_id
            d.relatable_id = x.id
            d.save
          else
            false
          end
        end
      else
        session[:added_documents].delete_if {|d| x == d.relatable && d.save}
      end
    end
  end
  
   def mail_to_queue(it, flash_now=false)
    mail = params[:mail]
    if mail && !mail[:recipients].blank?
      fragment = FragmentHash.new(params[:fragment])
      menu_id = fragment.motion("m").to_i
      mail_queue = MailQueue.create!({
          :menu_id => menu_id,
          :product_id => @product.id,
          :document => it,
          :from => User.current.person,
          :recipient_ids => mail[:recipients],
          :comment_message => mail[:comment],
          :field_type => mail[:field_type],
          :has_attachment => mail[:attachment],
          :mail_mode => "auto login",
          :copy_to_sender => false,
          :processed => false,
          :auto_login_url => url_for({
              :controller => "user",
              :action => "auto",
              # :t => "/", # "/" is default
              :f => fragment_for(:menu => Menu.find(menu_id), :document => it),
            }),
        })
      url = url_for(:only_path => true, :controller => "mail_sender", :action => "post", :id => mail_queue.id)
#       MiddleMan.new_worker(:class => :mail_sender_worker, :args => {:post => [mail_queue.id, url]})
      ap4r.async_to({
          :controller => "mail_sender",
          :action => "post",
        }, {
          :id => mail_queue.id,
        })
      if flash_now
        flash.now[:message] = s_("rfw|flash|message|Mail queued for delivery.")
      else
        flash[:message] = s_("rfw|flash|message|Mail queued for delivery.")
      end
    end
  end
  
  DEFAULT_PER_PAGE = 10
  ALLOWED_PER_PAGE = [
    10,
    20,
    50,
    100,
    0,
  ]
  
  def prepare_display_to_list
    begin
      @product = Product.find(@menu_select_product_id)
    rescue ActiveRecord::RecordNotFound
      raise NotFoundException, "product not found"
    end
    @display_list = @product.displays.select do |display|
      (display.is_a?(DisplayToListPrivate) && display.person_id == User.current.person_id) ||
        (display.class == DisplayToList && display.enabled?)
    end.sort_by do |display|
      display.position || 0
    end
    raise NotFoundException, "display not found" if @display_list.empty?
    list_id = params[:list] || fetch_fragment("m", :list, nil)
    if user_id = User.current_id
      if @default_list = DefaultList.find_by_product_id_and_user_id(@product.id, user_id)
        # use the default list unless specified
        list_id ||= @default_list.display_id
      end
    end
    if list_id
      params[:list] = list_id
      list_id = list_id.to_i
      @display = @display_list.find {|d| d.id == list_id }
    end
    @title = @product.name
    prepare_display_to(:list)
  end

  def prepare_details
    if @product.is_a?(ProductDetailedForGrantData)
      @details = GrantOnWithoutPeriodic.find(
        :all,
        :conditions => {
          :grant_targettable_id => @it.id,
          :grant_targettable_type => @it.class.name,
        }
      )
    else
      @details = @it.details
    end
  end
  
  def prepare_period_to_list
        @period_list = [[s_("PjcTask|Task_select_tag|two_weeks"),"two_weeks"],
                        [s_("PjcTask|Task_select_tag|one_month"),"one_month"],
                        [s_("PjcTask|Task_select_tag|three_months"),"three_months"],
                        [s_("PjcTask|Task_select_tag|six_months"),"six_months"],
                        [s_("PjcTask|Task_select_tag|one_year"),"one_year"],
                        [s_("PjcTask|Task_select_tag|two_years"),"two_years"],
                        [s_("PjcTask|Task_select_tag|three_years"),"three_years"]]
  end
  
  def prepare_display_to(display_type, display_class="display_to_#{display_type}".classify)
     if session[:task_pick_return_product_id]
        @product = Product.find(session[:task_pick_return_product_id])
        @menu_select_product_id = session[:task_pick_return_product_id]
     elsif params[:product_id]
        @product = Product.find(params[:product_id])
        @menu_select_product_id = params[:product_id]
     else
        @product = Product.find(session[:menu_select_product_id])
        @menu_select_product_id =session[:menu_select_product_id]
     end
    @display_type = display_type
    case @display_type
    when :show, :list
      raise PermissionDenied, "product is invisible" unless @product.visible?
    when :edit, :new
      raise PermissionDenied, "product is not modifiable" unless @product.modifiable?
    else
      raise ArgumentError, "unknown display type: #{@display_type}"
    end
    @display ||= @product.displays.find_by_type(display_class)
    raise NotFoundException, "display not found" unless @display
    raise DisabledException, "display disabled" unless @display.enabled?
    Display.current = @display
    @title ||= @display.name
    @title = "no title" if @title.blank?
    @model_class = @product.model_class
    @items = @display.items.find(:all, :conditions => ["layout > 0"], :order => "layout,id")
    @items = @items.select(&:selected?) if @display.is_a?(DisplayToListPrivate)
    if @product.is_a?(ProductDetailed)
      @detail_items, @items = @items.partition(&:detail?)
    end
  end
  
  # 開閉情報の記憶  
  def open_and_shut_list(display_id, person_id, task_id, open_and_shut)
    if open_and_shut
       task_condition = PjcTaskCondition.find(:first, :conditions =>['task_id=? and person_id=? and display_id=?',task_id, person_id, display_id])
       unless task_condition
          task_condition =PjcTaskCondition.create(:task_id =>task_id, :person_id =>person_id, :display_id =>display_id)
       end
       task_condition.task_open_and_shut = open_and_shut
       task_condition.save!
    end
  end
  
  #最下層を表示する
  def level_choice(person_id,display_id,project_id,segment_id,params_level,conditions)
     level_max =PjcTask.maximum(:task_level, :conditions =>conditions).to_i
     session[:level_max]=level_max
     @level_option = []
     n = 1
     loop do
     @level_option << [n, "#{n}"]
     n += 1
     break if n > level_max
     end
     @level_option << [s_("PjcTask|Task_level|task_all"), "all"]
     level_list(display_id ,person_id, level_max,params_level)
  end
  
  # 金額単位選択の表示
  def unit_choice
      @unit_choice = []
      @unit_choice << [s_("PjcTask|Task_select_tag|unit_yen"),0] 
      @unit_choice << [s_("PjcTask|Task_select_tag|unit_ten_thousand_yen"),1] 
      @unit_choice << [s_("PjcTask|Task_select_tag|unit_million_yen"),2]

  end
  
  # レベルまで表示の操作
  def level_list(display_id, person_id, level_max, params_level)
      if params_level && params_level !="all"
        show_level_list = @select_level  #表示レベル
        tasks = PjcTask.find(:all, :conditions =>['task_level <= ? and data_type = ?', show_level_list, "task"]) # and segment_id is null
        if tasks
          tasks.map{|task|
             unless task_condition =PjcTaskCondition.find(:first, :conditions => ['task_id =? and person_id =? and display_id =?', task.id, person_id,display_id])
                task_condition =PjcTaskCondition.create(:task_id =>task.id, :person_id =>person_id, :display_id =>display_id)
             end
             if task.task_level == show_level_list.to_i
                if @select_level != level_max.to_s
                   task_condition.task_open_and_shut = 1
                end
             else
                task_condition.task_open_and_shut = 0
             end
             task_condition.save!
          }
        end
      elsif params_level =="all"
        tasks = PjcTask.find(:all, :conditions =>['data_type = ?',"task"])
        if tasks
          tasks.map{|task|
             unless task_condition =PjcTaskCondition.find(:first, :conditions => ['task_id =? and person_id =? and display_id =?', task.id, person_id,display_id])
                task_condition =PjcTaskCondition.create(:task_id =>task.id, :person_id =>person_id, :display_id =>display_id)
             end
             task_condition.task_open_and_shut = 0
             task_condition.save!
          }
        end
      end
  end
  
  # 記憶ボタンの動作
  def save_memory(domain_id, person_id, display_id, task_memories_botton)
      if task_memories_botton
        task_memories = PjcTaskMemory.find(:first, :conditions =>['domain_id = ? and person_id = ? and display_id = ?', domain_id, person_id, display_id])
        task_memories ||= PjcTaskMemory.new(:domain_id => domain_id, :display_id => display_id, :person_id => person_id)
        # checkboxの条件記憶
        if params[:task_memory]
          task_memories.do_not_show_finished_task = params[:task_memory][:do_not_show_finished_task]
          task_memories.show_task_of_delayed_start = params[:task_memory][:show_task_of_delayed_start]
          task_memories.show_task_of_delayed_finish = params[:task_memory][:show_task_of_delayed_finish]
          task_memories.show_task_in_progress = params[:task_memory][:show_task_in_progress]
          task_memories.record_of_certain_term = params[:task_memory][:record_of_certain_term]
          task_memories.basic_point_of_appointed_day = params[:task_memory][:basic_point_of_appointed_day]
          task_memories.graph_type = params[:task_memory][:graph_type]
          task_memories.display_type = params[:task_memory][:display_type]
        end
        # チャートの期間記憶 
        if @selected_period
           task_memories.record_of_certain_term = @selected_period
        end
        # EVM情報の記憶
        if @select_evm_list  
            if @evm_list == "evm_list"
               task_memories.display_type = 1
            else 
               task_memories.display_type = 0
            end
        end
        # 当日基点の記憶 
        if @center_day
           task_memories.basic_point_of_appointed_day =1
        else
           task_memories.basic_point_of_appointed_day =0
        end
        # グラフタイプの記憶
        if @person_rate_chart_switch
           if @person_rate_chart_switch =="person_rate"
              task_memories.graph_type = 1
           else
              task_memories.graph_type = 0
           end             
        end
        if @rate_chart_switch
           if @rate_chart_switch =="rate"
              task_memories.graph_type = 1
           else
              task_memories.graph_type = 0
           end             
        end
        # チャート情報の記憶
        if @person_chart_switch
           if @person_chart_switch=="person_task_chart"
              task_memories.display_type = 1
           else
              task_memories.display_type = 0
           end             
        end
        if @chart_switch
           if @chart_switch=="task_chart"
              task_memories.display_type = 1
           else
              task_memories.display_type = 0
           end             
        end
        task_memories.save
      end  
  end

   # check_boxの選択条件
   def memory_conditions(task_memories_data, options, project_id, segment_id)
      if task_memories_data
        if @display.code == "LIST"|| @display.code == "CHART_LIST" # 日程別の一覧
          if segment_id
            options[:conditions] ||= "tasks.project_id =#{project_id} and (tasks.segment_id =#{segment_id} or tasks.segment_id IS NULL) "
          elsif project_id
            options[:conditions] ||= "tasks.project_id =#{project_id}"
          end
#          options[:conditions] +=" or tasks.data_type ='project'"
        elsif @display.code == "PJ_LIST"
           options[:conditions] ||="tasks.project_id IS NOT NULL" # pj別一覧
        elsif @display.code == "PERSON_LIST"
            options[:conditions] ||="tasks.project_id = #{project_id}" unless project_id ==nil# 担当者別一覧
        elsif @display.code == "PERSON_CHART_LIST"
           options[:conditions] ||="tasks.project_id = #{project_id}" unless project_id ==nil # 担当者別チャット一覧
        end 
        if task_memories_data.do_not_show_finished_task.to_s=="true"   # 終了タスク非表示
           options[:conditions] += " and (tasks.progress_rate !=100.0 or tasks.progress_rate IS NULL)"
        end
        if task_memories_data.show_task_of_delayed_start.to_s=="true"  # 開始遅れタスク表示
           options[:conditions] += " and tasks.planned_start_date IS NOT NULL and tasks.planned_start_date !='' and ((tasks.operation_start_date IS NOT NULL and tasks.operation_start_date !='' and tasks.operation_start_date > tasks.planned_start_date)
                                     or ((tasks.operation_start_date IS NULL or tasks.operation_start_date ='') and tasks.planned_start_date < '#{Time.now.strftime("%Y%m%d")}'))" 
        end
        if task_memories_data.show_task_of_delayed_finish.to_s=="true" # 終了遅れタスク表示
           options[:conditions] += " and tasks.planned_finish_date IS NOT NULL and tasks.planned_finish_date !='' and ((tasks.operation_finish_date IS NOT NULL and tasks.operation_finish_date !='' and tasks.operation_finish_date > tasks.planned_finish_date)
                                     or ((tasks.operation_finish_date IS NULL or tasks.operation_finish_date ='') and tasks.planned_finish_date < '#{Time.now.strftime("%Y%m%d")}'))" 
        end
        if task_memories_data.show_task_in_progress.to_s=="true"       # 作業中タスク表示
           options[:conditions] += " and (tasks.operation_start_date IS NOT NULL and tasks.operation_start_date !='') and (tasks.operation_finish_date IS NULL or tasks.operation_finish_date ='')"
        end
      end
      task_memories_data
   end
   # EVM切り替え
   def evm_list(domain_id, display_id, person_id)
      if @select_evm_list  
        if @select_evm_list.to_s == "evm_list"
           task_evm_list_table_data
        # 初期値として日程別一覧を表示する          
        else 
           task_list_table_data
        end
      else
        task_memories = PjcTaskMemory.find(:first, :conditions =>['domain_id = ? and person_id = ? and display_id = ?', domain_id, person_id, display_id])
        if task_memories && task_memories.display_type == true
           task_list_table_data
        else
           task_evm_list_table_data
        end 
      end          
   end   
   
   def task_chart_list_table_data
       @chart_signle_columns = %w(planned_start_date planned_finish_date operation_start_date operation_finish_date
                                  delayed_days_before_start delayed_days_until_finish task_weight_progress_rate task_weight
                                  plan_progress_rate progress_rate)
       @chart_change_line = "plan_progress_rate"
       #チャート重みと実績の切り替え
       if @rate_chart_switch && @rate_chart_switch.to_s == "weight_rate"
          @plan_rate = "rate"
       else          
          @plan_rate = "weight_rate"
       end
       # チャートの切り替え  
       if @chart_switch && @chart_switch.to_s == "task_chart_switch"
          @task_chart = "task_chart"
       else          
          @task_chart = "task_chart_switch"
       end
   end
   
   def task_person_chart_list_table_data
       @person_chart_signle_columns = %w(planned_start_date planned_finish_date operation_start_date operation_finish_date
                                  delayed_days_before_start delayed_days_until_finish task_weight_progress_rate task_weight
                                  plan_progress_rate progress_rate project_name_and_segment_name rank_task_name)
       @person_chart_change_line = "plan_progress_rate"
       #チャート重みと実績の切り替え
       if @person_rate_chart_switch && @person_rate_chart_switch.to_s =="person_weight_rate"
          @person_plan_rate ="person_rate"
       else          
          @person_plan_rate ="person_weight_rate"
       end
       # チャートの切り替え  
       if @person_chart_switch && @person_chart_switch.to_s == "person_task_chart_switch"
          @person_task_chart = "person_task_chart"
       else          
          @person_task_chart = "person_task_chart_switch"
       end
   end

   def task_list_table_data #日程別の進捗データ
       @signle_columns = %w(planned_start_date planned_finish_date operation_start_date operation_finish_date progress_rate  
                         task_weight_progress_rate delayed_days_before_start delayed_days_until_finish)   # 二行表示
       @evm_unit_of_money = %w(budget_at_completion planed_value earned_value actual_cost schedule_variance cost_variance)
       @columns = %w(plan_progress_rate budget_at_completion planed_value earned_value actual_cost schedule_variance
                         schedule_performance_index cost_variance cost_performance_index)   # カラム変更                   
       @change_line = "attachment" # 改行カラム
       @evm_list = "evm_list"
       @pj_columns = %w(budget_at_completion planed_value earned_value actual_cost schedule_variance schedule_performance_index
                        cost_variance cost_performance_index)
       @person_signle_columns = %w(progress_rate delayed_days_before_start planned_start_date operation_start_date task_weight_progress_rate
                                    delayed_days_until_finish planned_finish_date operation_finish_date project_name_and_segment_name rank_task_name)
       @person_change_line = "attachment" # 改行カラム
   end
   
   def task_evm_list_table_data #EVM別の進捗データ
       @signle_columns = %w(plan_progress_rate progress_rate) # 二行表示
       @evm_unit_of_money = %w(budget_at_completion planed_value earned_value actual_cost schedule_variance cost_variance)
       @columns = %w(planned_start_date planned_finish_date operation_start_date operation_finish_date task_weight_progress_rate
                  delayed_days_before_start delayed_days_until_finish attachment)     # カラム変更                                
       @change_line = "cost_performance_index"  # 改行カラム
       @evm_list = "list"
       @pj_columns = %w(plan_progress_rate task_weight_progress_rate progress_rate delayed_days_before_start delayed_days_until_finish
                        planned_start_date operation_start_date planned_finish_date operation_finish_date)
       @person_signle_columns = %w(progress_rate delayed_days_before_start planned_start_date operation_start_date task_weight_progress_rate
                                    delayed_days_until_finish planned_finish_date operation_finish_date project_name_and_segment_name rank_task_name)
       @person_change_line = "attachment" # 改行カラム       
   end
end
