# -*- coding: utf-8 -*-
class Pick::RecordController < ApplicationController

  before_filter :check_rfw_params, :except => [:test]

  def search
    @name = params[:name]
    item = Item.find_by_id(params[:rfw][:record_setting_id].to_i)
    conditions = item.input_initializer
    records = record_model.find(:all, :conditions => conditions, :order => "id")
    records = records.select {|r| r.name.include?(@name)} unless @name.blank?
    @records = records
  end

  # (試験用)
  def test
  end

  private

  def record_model
    @record_model ||= params[:rfw][:record_model_name].constantize
  end

  def check_rfw_params
    if params[:rfw].nil? || params[:rfw][:record_model_name].blank?
      raise ClientError, "rfw paramsters are missing"
    end
  end

end
