class Pick::OrganizationController < ApplicationController
  include Picker::Controller

  before_filter :check_rfw_params, :except => [:test]
  before_filter :filter_rfw_params, :only => [:search]

  def search
    if params[:company_name] || params[:organization_name]
      prepare
    end
  end

  def tree
    if params[:root] == 'source'
      prepare_company
      prepare_organization
    else
      prepare_organization
    end
    respond_to {|format|
      format.json
    }
  end

  # for test
  def test
  end

  private

  def check_rfw_params
    if params[:rfw].nil? ||
        params[:rfw][:organization_id].blank? || params[:rfw][:organization_name].blank?
      raise ClientError, 'rfw parameters are missing'
    end
  end

  def filter_rfw_params
    params[:rfw] = {
      :company_id        => params[:rfw][:company_id],
      :company_name      => params[:rfw][:company_name],
      :organization_id   => params[:rfw][:organization_id],
      :organization_name => params[:rfw][:organization_name],
    }
  end

  def prepare
    prepare_company
    prepare_organization
  end

  def prepare_company
    @company_name = params[:company_name]
    if !@company_name.blank?
      @companies = picker_model_class("Company").find_like_name(@company_name,
                                                                :select => 'id, name',
                                                                :order => 'name')
    else
      @companies = picker_model_class("Company").all(:select => 'id, name', :order => 'name')
    end
    
    prepare_organization
    if !@organization_name.blank?
      if @organizations && @organizations != []
        c = @organizations.map(&:company_id).join(",")
        if c && c != ""
          coms = picker_model_class("Company").find(:all, :select => 'id, name', :conditions=>"id in (#{c})", :order => 'name')
        else
          coms = []
        end
        @companies = @companies & coms
      else
        @companies = []
      end
    end
  end

  def prepare_organization
    @organization_name = params[:organization_name]
    if !@organization_name.blank?
      @organizations = picker_model_class("Organization").find_like_name(@organization_name,
                                                                         :select => 'id, name, company_id',
                                                                         :order => 'name')
    elsif /\Acompany_id_(\d+)_\d+\z/ =~ params[:root]
      @organizations = picker_model_class("Organization").find_all_by_company_id($1,
                                                                                 :select => 'id, name, company_id',
                                                                                 :order => 'name')
    else
      @organizations = picker_model_class("Organization").all(:select => 'id, name', :order => 'name')
    end
    org = picker_model_class("Organization").find(:all, :select => 'id, name', :order => 'name')
    @organizations = @organizations & org
  end

end
