# -*- coding: utf-8 -*-
# 案件情報を制御する。
class Pick::MatterController < ApplicationController
  include Picker::Controller

  before_filter :check_rfw_parameters, :except => [:test]

  # 絞りこんだ案件情報の一覧を表示する。
  def search
    prepare
  end

  # 絞り込んだ案件情報の一覧を表示すると同時に、現在の案件情報を更新する。
  def narrow
    prepare
  end

  # 現在の案件情報を保存する。
  def save_current
    matter_id = params[:current_id].blank? ? nil : params[:current_id].to_i
    if matter_id
      session[:matter_id] = matter_id
      @current = picker_model_class("Matter").find(matter_id)
      narrowing = Narrowing.find(:first, :conditions => {:controller_path => "pick/matter", :action_name => "narrow"})
      if narrowing
        c = {:user_id => User.current_id, :narrowing_id => narrowing.id}
        default_narrowing = DefaultNarrowing.find(:first, :conditions => c)
        default_narrowing ||= DefaultNarrowing.new(c)
        default_narrowing.narrowing_value = {params[:rfw][:matter_id] => matter_id}.to_json
        default_narrowing.narrowing_text  = @current.name
        default_narrowing.save!
      end
    end
    prepare
    data = {params[:rfw][:narrowing_text] => @current_name, params[:rfw][:matter_id] => @current_id}
    render :text => data.to_json
  end

  # 現在の案件情報をリセットする
  def reset_current
    destroy_default_narrowings
    session[:matter_id] = nil
    prepare
    data = {params[:rfw][:narrowing_text] => "", params[:rfw][:matter_id] => ""}
    render :text => data.to_json
  end

  # (試験用)
  def test
  end

  private

  def check_rfw_parameters
    if params[:rfw].nil? || params[:rfw][:matter_id].blank?
      raise ClientError, "rfw parameters are missing"
    end
  end

  def prepare
    @code = params[:code]
    @name = params[:name]
    if !session[:matter_id].blank? && @current ||= picker_model_class("Matter").find_by_id(session[:matter_id])
      @current_id   = @current.id
      @current_code = @current.code
      @current_name = @current.name
    else
      @current_id = @current_code = @current_name = ''
    end
    matters = picker_model_class("Matter").find(:all, :select => "id, code, name", :order => "code")
    matters = matters.select {|m| m.code && m.code.index(@code)} unless @code.blank?
    matters = matters.select {|m| m.name && m.name.index(@name)} unless @name.blank?
    @matters = matters
  end

end
