class Pick::GroupController < ApplicationController
  include Picker::Controller

  before_filter :check_rfw_params, :except => [:test]
  before_filter :filter_rfw_params, :only => [:search]

  def search
    prepare
  end

  def test
  end

  private

  def check_rfw_params
    if params[:rfw].nil? ||
        params[:rfw][:group_id].blank? || params[:rfw][:group_name].blank?
      raise ClientError, 'rfw parameters are missing'
    end
  end

  def filter_rfw_params
    params[:rfw] = {
      :group_id => params[:rfw][:group_id],
      :group_name => params[:rfw][:group_name],
    }
  end

  def prepare
    @name = params[:name]
    if @name
      @groups = picker_model_class("Group").find_like_name(@name, :select => 'id, name', :order => 'name')
    else
      @groups = picker_model_class("Group").find(:all, :select => 'id, name', :order => 'name')
    end
  end

end
