# メニューを制御する。
class MenuController < ApplicationController
  before_filter :set_views

  # メニューレイアウトで表示する。
  def index
    set_menus
    update_menu_history
    @menu_tree_close_all = true
  end

  # (試験用)
  def mock
    @menu = Menu.find(params[:id])
    @parent_view = "main"
    @current_view = "m"
    @sub_view = nil
  end

  # メニュー履歴を表示する。
  def menu_history
    act = Menu.find(params[:id])
    update_menu_history(act)
    render :partial => "menu_history"
  end

  # メニューツリーを表示する。
  def menu_tree
    set_menus
    @menu_tree_close_all = false
  end

  # (試験用)
  def about
    flash.now[:notice] = "flash notice of about"
    @parent_view = "main"
    @current_view = "m"
    @sub_view = nil
  end

  private

  def set_views
    @current_view = "main"
    @sub_view = "m"
  end

  def set_menus
    root = Menu.root
    @full_set = root.full_set.reject(&:hidden?)
    @menus = root.children.reject(&:hidden?)
  end

  def update_menu_history(menu=nil)
    session[:menu_history] ||= []
    history = session[:menu_history]
    if menu
      menu_history_max = User.menu_history_max
      history = ([menu.id] | history)[0, User.menu_history_max]
    end
    if true # use when bug
      history.reject! do |m|
        not m.is_a?(Integer)
      end
    end
    # check before store
    h = {}
    @full_set ||= Menu.root.full_set.reject(&:hidden?)
    @full_set.each do |menu|
      h[menu.id] = menu
    end
    @menu_history = history.map{|id| h[id]}.compact
    session[:menu_history] = history
  end
end
