# -*- coding: utf-8 -*-
# メール送信を実装する。
class MailSenderController < ApplicationController
  skip_before_filter :authenticate_user
  skip_before_filter :verify_authenticity_token
  session :off

  # メールキューから取り出し配送に回す。
  def post
    queue = MailQueue.find(params[:id], :include => [ :product, {:from => :user} ])
    if queue.processed?
      logger.warn { "WARN: MailQueue #{queue.id} was already processed." }
      render :text => "true"
      return
    end
    from = queue.from
    User.current = from.user
    product = queue.product
    document = queue.document
    comment = queue.comment_message
    mail_format = MailFormat.find(:first, :conditions => {:mail_mode => queue.mail_mode})
    recipients = queue.recipients
    MailHistory.transaction do
      recipients.each do |recipient|
        if user = recipient.user
          url = url_for(:controller => "user", :action => "auto", :id => queue.id, :u => user.id)
          set_locale(recipient.last_language)
          formatted = mail_format.format_all(product, document, from, recipient, url, comment)
          mail_history = MailHistory.create!({
            :mail_queue => queue,
            :from_value => "#{formatted[:from]} <#{from.mail_address}>",
            :recipient_value => "#{formatted[:recipient]} <#{recipient.mail_address}>",
            :subject => formatted[:subject],
            :body => formatted[:body],
            :status => "queue",
          })
          mail_history.deliver
        end
      end
      queue.processed = true
      queue.save!
    end
    render :text => "true"
  ensure
    set_locale(nil)
  end

  # メール履歴から取り出し配送に回す。
  def deliver
    if mail_history = MailHistory.find(params[:id])
      render :text => mail_history.deliver
      return
    end
  end
end
