# -*- coding: utf-8 -*-
# 選択部品を制御する:
# - 行き先選択

class DestinationController < ApplicationController
  before_filter :set_view

  PICKER_ERROR_RETURN_TO ="/"
  
  def destination
   @personal_destination =PjcPersonalDestination.find(:all,:conditions =>["person_id =?",User.current.person_id])
   pass_params
  end
  
  # 選択を行う。
  def pick
    flash[:pick] = {
      :field => "destination",
      :return_value => params[:return_value],
      :departure =>params[:departure],
      :arrival =>params[:arrival],
      :fare =>params[:fare],
      :one_way_or_round_trip =>params[:one_way_or_round_trip],
      :total_amount =>params[:total_amount]
    }
    if [:picker, :return_to].trav(session).is_a?(Symbol)
      x_close_or_redirect_to return_to_url
      return
    end
    return_to_action = [:picker, :return_to, :action].trav(session) do |key|
      logger.warn("CalendarController#pick: #{key} does not set")
    end
    #if %w[ new edit ].include? return_to_action
    if /\A(?:list|new|edit)/ =~ return_to_action
      x_close_or_redirect_to return_to_url
    else
      redirect_to return_to_url
    end
  end
  
  private
  def set_view
    if /\Aview_[a-z0-9]+\z/ =~ params[:view]
      @current_view = params[:view]
    else
      @current_view = "view_picker"
    end
    @return_to_url = return_to_url
  end
  
  def return_to_url
    picker_session = session[:picker] || {}
    if picker_session[:return_to]
      return picker_session[:return_to]
    else
      return PICKER_ERROR_RETURN_TO
    end
  end
  
  def pass_params(*singulars)
    @pass_params_link = {}
    [
      :return_to,
      :return_field,
      :view,
    ].each do |key|
      @pass_params_link[key] = params[key] if params[key]
    end

    @pass_params_form = @pass_params_link.dup
    [
      :mode,
    ].each do |key|
      @pass_params_form[key] = params[key] if params[key]
    end
  end
end  