# Design Web サービスを制御する。
# 実装は各 Service クラスが受け持つ。
class DesignController < ApplicationController
  session :disabled => true

  wsdl_service_name 'Design'
  web_service_dispatching_mode :delegated

  web_service_scaffold :invocation

  #WEB_SERVICE_PREFIX = [:design, :language, :common_label, :message, :menu, :product, :display, :grant, :mail, :table]
  WEB_SERVICE_PREFIX = [:design, :language, :common_label, :message, :menu, :product, :display, :mail, :application_table]

  WEB_SERVICE_PREFIX.each do |name|
    web_service name, "#{name.to_s.classify}Service".constantize.new
  end

  ACTION_METHODS = WEB_SERVICE_PREFIX.map(&:to_s) + ['wsdl']
  write_inheritable_attribute(:hidden_actions, public_instance_methods - ACTION_METHODS)

  # Design Web サービスでは管理者のみを対象にした認証を行う。
  # 認証時に発行する文字列を送受信する XML に埋め込む。
  # ActionWebService では cookie が利用できないためセッションを利用しない。
  skip_filter :authenticate_user, :convert_fragment
end
