# -*- coding: utf-8 -*-
# 選択部品を制御する:
# - 企業選択
# - 企業支店選択
class BusinessCardController < ApplicationController
  before_filter :set_view

  BUSINESS_CARD_RETURN_TO = {
    :business_card_test => {:controller => "business_card", :action => "test"},
  }.with_indifferent_access
  BUSINESS_CARD_ERROR_RETURN_TO = "/"

  # <tt>test</tt> へリダイレクトする。
  def index
    redirect_to :action => :test
  end

  # 名刺企業選択
  def company
    with_picker_scope(PjcBusinessCardCompany) do
      search PjcBusinessCardCompany
      pass_params
    end
  end

  # 名刺企業支店選択
  def branch
    with_picker_scope(PjcBusinessCardCompany, PjcBusinessCardBranch) do
      search PjcBusinessCardCompany, PjcBusinessCardBranch
      pass_params
    end
  end

  # 組織選択
  def organization
    with_picker_scope(PjcBusinessCardCompany, PjcBusinessCardOrg) do
      search PjcBusinessCardCompany, PjcBusinessCardOrg
      pass_params
    end
  end

  # 名刺個人選択
  def person
    with_picker_scope(PjcBusinessCardCompany, PjcBusinessCard) do
      company = search_by_id(PjcBusinessCardCompany)
      search_under PjcBusinessCard, company
      pass_params :pjc_business_card_company
    end
  end
    
  # 選択処理
  def pick
    flash[:pick] = {
      :field            => params[:return_field],
      :col_name         => params[:col_name],
      :company_id       => params[:pjc_business_card_company_id],
      :organization_id  => params[:pjc_business_card_org_id],
      :branch_id        => params[:pjc_business_card_branch_id],
      :person_id        => params[:pjc_business_card_id]
    }
    return_to_action = [:picker, :return_to, :action].trav(session) do |key|
      logger.warn("BusinessCardController#pick: #{key} does not set")
    end

    logger.warn("BusinessCardController#return_to_action: #{return_to_action}")
    
    if %w[ new edit ].include? return_to_action
      x_close_or_redirect_to return_to_url
    else
      redirect_to return_to_url
    end
  end


private
  def set_view
    if /\Aview_[a-z0-9]+\z/ =~ params[:view]
      @current_view = params[:view]
    else
      @current_view = 'view_businesscard'
    end
    @return_to_url = return_to_url
  end

  def return_to_url
    if return_to = BUSINESS_CARD_RETURN_TO[params[:return_to]]
      return return_to
    elsif session[:business_card_return_to]
      return session[:business_card_return_to]
    elsif [:picker, :return_to].trav(session)
      session[:picker][:return_to]
    else
      return BUSINESS_CARD_ERROR_RETURN_TO
    end
  end

  def search(model_class, seach_model_class = nil)
    model_name = model_class.model_name.underscore
    search_key = params["#{model_name}_key"]
    
    unless search_key.blank?
      search_type = params["#{model_name}_type"] == "code" ? "code" : "name"
      if seach_model_class.blank?
        items = find_like(model_class, "#{model_class.table_name}.#{search_type}", search_key)
      else
        items = find_like(model_class, "#{seach_model_class.table_name}.#{search_type}", search_key)
      end
    else
      items = model_class.find(:all)
    end
#    case table_name.to_sym
#    when :companies
#      items = lift_by_membership(User.current.person.companies, items)
#    end
    instance_variable_set "@#{model_name.pluralize}", items

    return items
  end

  def search_by_id(model_class, scope=nil)
    model_name = model_class.model_name.underscore

    key_hidden = "#{model_name}_key_hidden"
    key = "#{model_name}_key"
    singular_id = "#{model_name}_id"

    if params[key_hidden] && params[key_hidden] != params[key]
      params[singular_id] = nil
      params[key_hidden] = params[key]
    end

    if scope
      items = search_under model_class, scope
    else
      items = search model_class
    end

    unless params[singular_id].blank?
      target_id = params[singular_id].to_i
      it = items.find {|i| i.id == target_id}
    else
      it = nil
      #it ||= items[0]  # 初期表示時に一番上の企業を選択状態にする
    end

    return it
  end

  def search_under(model_class, scope=nil)
    #return [] unless scope

    model_name = model_class.model_name.underscore
    search_key = params["#{model_name}_key"]
    
    unless scope.blank?
      params["#{scope.class.table_name.to_s.singularize}_id"] = scope.id
      items = scope.__send__(model_class.name.pluralize.underscore)
    end
    
    unless search_key.blank?
      search_type = params["#{model_name}_type"] == "code" ? "code" : "name"
      items = find_like(model_class, "#{model_class.table_name}.#{search_type}", search_key)
    end
    instance_variable_set "@#{model_class.model_name.pluralize.underscore}", items

    return items
  end

  def find_like(scope, column, value)
    escape = '^'
    name = scope.connection.quote_like(value, escape)
    return scope.find(:all, :conditions => ["#{column} LIKE ? ESCAPE ?", "%#{name}%", escape])
  end

  def pass_params(*singulars)
    @pass_params_form = {}
    [
      :return_to,
      :return_field,
      :col_name,
      :view,
    ].each do |key|
      @pass_params_form[key] = params[key] if params[key]
    end
    singulars.each do |singular|
      ["#{singular}_id", "#{singular}_key_hidden"].each do |key|
        key = key.to_sym
        @pass_params_form[key] = params[key] if params[key]
      end
    end

    @pass_params_link = @pass_params_form.dup
    [
      :mode,
    ].each do |key|
      @pass_params_link[key] = params[key] if params[key]
    end
    singulars.each do |singular|
      key = "#{singular}_key".to_sym
      @pass_params_link[key] = params[key] if params[key]
    end
  end

  def method_scoping(model_class)
    table_name = model_class.table_name
    if model_class == PjcBusinessCardCompany
      case params[:action]
      when "organization"
        value = {
          :find => {
            :include => [:pjc_business_card_orgs],
            :order => "#{table_name}.code,#{table_name}.name",
            :readonly => true,
          }
        }
        value[:find][:conditions] = "business_card_orgs.#{params[:list_condition]}" unless params[:list_condition].blank?
        return value
      when "branch"
        value = {
          :find => {
            :include => [:details],
            :order => "#{table_name}.code,#{table_name}.name",
            :readonly => true,
          }
        }
        value[:find][:conditions] = "business_card_branches.#{params[:list_condition]}" unless params[:list_condition].blank?
        return value
      when "person"
        value = {
          :find => {
            :include => [:pjc_business_cards],
            :order => "#{table_name}.code,#{table_name}.name",
            :readonly => true,
          }
        }
        value[:find][:conditions] = "business_cards.#{params[:list_condition]}" unless params[:list_condition].blank?
        return value
      end
    end

    return {
      :find => {
        :order => "#{table_name}.code,#{table_name}.name",
        :readonly => true,
      }
    }
  end

  def with_picker_scope(model_class, *rest, &block)
    if model_class
      model_class.__send__(:with_scope, method_scoping(model_class)) do
        if rest.empty?
          block.call
          render unless performed?
        else
          with_picker_scope(*rest, &block)
        end
      end
    end
  end

end
