# -*- coding: utf-8 -*-

#
# Copyright (C) 2009 ソフトウエア興業株式会社 All rights reserved.
# author 青山陽一
# mail : aoyama-y@users.sourceforge.jp
#
# 本プログラムはフリーソフトウェアです。GPLv2のもとに配布されています。
#

import re, calendar, time
from calendar import monthcalendar
from datetime import datetime, date, timedelta, tzinfo

from trac.core import *
from trac.web.chrome import ITemplateProvider, \
        add_stylesheet
from trac.web.main import IRequestHandler
from trac.web import auth
from trac.util import escape, Markup
from trac.web.href import Href

from trac.env import IEnvironmentSetupParticipant

class NicoCommentModule(Component):
    implements(IRequestHandler, ITemplateProvider)

    # IRequestHandler methods
    def match_request(self, req):
        return req.path_info == '/nico_comment'

    def process_request(self, req):
        authname = None
        if req.remote_user:
            authname = req.remote_user
        else:
            authname = req.authname

        add_stylesheet(req, 'hw/css/nico.css')
        req.hdf['nico_top_href'] = req.href.nico()
        req.hdf['nico_comment_href'] = req.href.nico_comment()

        if req.args.get('type') == 'personal':
            dispdays = req.args.get('dispdays')
            if dispdays==None or dispdays.isdigit() == False:
                dispdays = self.env.config.getint('nico', 'dispdays')
            req.hdf['allcommentdata'] = self.getPersonalCommentData(req.args.get('id'),dispdays)
            req.hdf['colTitle1'] = 'date'
            req.hdf['pageTitle'] = 'id: ' + req.args.get('id')
            req.hdf['type'] = 'personal'
            req.hdf['id'] = req.args.get('id')
            req.hdf['dispdays'] = dispdays
        else:
            # コメント一覧
            req.hdf['allcommentdata'] = self.getAllCommentData(req.args.get('date'))
            req.hdf['colTitle1'] = 'id'
            req.hdf['pageTitle'] = 'date: ' + req.args.get('date')

        return 'comment.cs', None

    # ITemplateProvider methods
    def get_templates_dirs(self):
        """Return a list of directories containing the provided ClearSilver
        templates.
        """
        from pkg_resources import resource_filename
        return [resource_filename(__name__, 'templates')]

    def get_htdocs_dirs(self):
        from pkg_resources import resource_filename
        return [('hw', resource_filename(__name__, 'htdocs'))]

    # 特定期間のデータを取得
    def getAllCommentData(self,date):
        db = self.env.get_db_cnx()
        cursor = db.cursor()
        # コメント一覧取得
        cursor.execute('SELECT id,state,comment FROM nicostate where date=%s ORDER BY id ',(date,))
        resultData = []
        while 1:
            row = cursor.fetchone()
            if row == None:
                break
            resultData.append(row)
        return resultData

    def getPersonalCommentData(self,id,dispdays):
        start = datetime.now()-timedelta(int(dispdays))
        db = self.env.get_db_cnx()
        cursor = db.cursor()
        # コメント一覧取得
        cursor.execute('SELECT date,state,comment FROM nicostate where id=%s and date>=%s ORDER BY date ',(id,start.strftime("%Y-%m-%d"),))
        resultData = []
        while 1:
            row = cursor.fetchone()
            if row == None:
                break
            resultData.append(row)
        return resultData
