/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: library.h 398 2010-10-30 11:07:43Z sirakaba $
*******************************************************************************/

//******************************************************************************
//    Includes
//******************************************************************************

#include "../header/plugin.h"
#include <wx/xml/xml.h>
#include <wx/stdpaths.h>
#ifndef WXWIN_COMPATIBILITY_2_8
#define GetAttribute GetPropVal
#define HasAttribute HasProp
#endif

//******************************************************************************
//    XML֐
//******************************************************************************

bool myIsLib(wxXmlNode * n);
wxXmlNode * myGetFirstLib(wxXmlDocument * xmlDoc, int nLibIndex = 0);
wxXmlNode * myGetNextLib(wxXmlNode * n, int nLibIndex = 0);

wxULongLong_t myGetAttributeInt( wxXmlNode * n, const wxString & szValue, wxULongLong_t nDefaultValue = 0, int nBase = 10);
bool myGetAttributeBool(wxXmlNode * n, const wxString & szValue, bool bDefaultValue = false);
void MakeFormatInfo(wxXmlNode * n, const wxString & szTPIName, TPI_FORMATINFO * _fiInfo, wxULongLong_t nId);

wxString inline myMakeXMLName(const wxString & szFile)
{
	return wxPathOnly(wxStandardPaths::Get().GetExecutablePath()) + wxT("/lib/") + szFile + wxT(".xml");
}
