/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: functions.h 394 2010-10-29 14:39:52Z sirakaba $
*******************************************************************************/

#ifndef H_LOADED_FUNCTIONS
#define H_LOADED_FUNCTIONS
#include <wx/process.h>

//******************************************************************************
//    コントロール処理系関数
//******************************************************************************

bool TreeView_CheckNewerItem(wxTreeCtrl *, const wxTreeItemId &, const wxString &, bool);
wxString TreeView_GetItemPath(wxTreeCtrl *, wxTreeItemId);

//******************************************************************************
//    諸処理関数
//******************************************************************************

wxFileName MakeDirPath(const wxFileName &, const wxString &, bool);
wxArrayString MakeTargetFileList(MainFrame *, bool);
bool WillMakeDirByArcName(MainFrame *, MakeDialog *);
wxString GetFileTypeName(const wxFileName &);
wxIcon GetFileTypeIcon(const wxFileName &);
wxString QuoteString(const wxString &);

//******************************************************************************
//    「開く」用プロセス
//******************************************************************************

class myProcess : public wxProcess
{
public:
	myProcess(const wxString & szFile, const wxString & szDir) : szFile(szFile), szDir(szDir) {}
    virtual void OnTerminate(int, int);
private:
	wxString szFile, szDir;
};

#endif
