/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: dlg_make.h 422 2010-11-07 04:35:30Z sirakaba $
*******************************************************************************/

#ifndef H_LOADED_DLG_MAKE
#define H_LOADED_DLG_MAKE

#include <wx/spinctrl.h>
#include <wx/notebook.h>

WX_DECLARE_OBJARRAY(TPI_FORMATINFO, ArrayTPI_FORMATINFO);

//******************************************************************************
//    Class (myListCtrl2)
//******************************************************************************

class myListCtrl2: public wxListView
{
public:
	virtual wxString OnGetItemText(long, long) const;
	virtual wxListItemAttr * OnGetItemAttr(long) const;

	wxArrayString * asInput, asOutput;
	wxArrayPtrVoid apItem;
	wxListItemAttr atDangerItem, atExistItem;

	myListCtrl2(): wxListView(){}
	myListCtrl2(wxWindow * parent, wxWindowID id, const wxPoint & pos = wxDefaultPosition, const wxSize & size = wxDefaultSize, long style = wxLC_ICON, const wxValidator & validator = wxDefaultValidator, const wxString & name = wxListCtrlNameStr): wxListView(parent, id, pos, size, style, validator, name){}

	DECLARE_DYNAMIC_CLASS(myListCtrl2)
};

//******************************************************************************
//    Class (MakeDialog)
//******************************************************************************

class MakeDialog: public wxDialog
{
public:
	// "General"タブ
	wxComboBox* cbDir;
	wxComboBox* cbFileName;
	wxCheckBox* cbOpenAfter;
	wxCheckBox* cbIgnorePath;
	wxCheckBox* cbExitAfter;
	wxChoice* chType;
	wxChoice* chDirMake;
	// "Config"タブ
	wxSpinCtrl* scLevel;
	wxSpinCtrl* scRR;
	wxComboBox* cbSplitSize;
	wxCheckBox* cbSolid;
	wxCheckBox* cbMMOptimize;
	wxCheckBox* cbCompressHeader;
	wxCheckBox* cbMakeSFX;
	// "Comment"タブ
	wxTextCtrl* tcComment;
	// "Encryption"タブ
	wxTextCtrl* tcPassword;
	wxTextCtrl* tcKeyfile;
	wxCheckBox* cbUnmask;
	wxChoice*   chEncryptMethod;
	wxCheckBox* cbEncryptHeader;
	// "Files"タブ
	myListCtrl2* lcFiles;

	ArrayTPI_FORMATINFO afInfo;
	wxArrayString files;
	unsigned int uCommand;

	MakeDialog();

	// Event handler.
    void OnInit(     wxInitDialogEvent&);
    void OnBtnDefault(  wxCommandEvent&);
    void OnBtnDesktop(  wxCommandEvent&);
    void OnBtnCurrent(  wxCommandEvent&);
    void OnBtnBrowse(   wxCommandEvent&);
    void OnBtnBrowseKF( wxCommandEvent&);
    void OnBtnOK(       wxCommandEvent&);
    void OnBtnCancel(   wxCommandEvent&);
    void OnChoice(      wxCommandEvent&);
    void OnCbUnmask(    wxCommandEvent&);
    void OnCbMakeSFX(   wxCommandEvent&);
    void OnTabChanged( wxNotebookEvent&);

    DECLARE_EVENT_TABLE()

private:
	wxNotebook * nbTabs;
	void myLoadHistory(myConfigId confId, wxComboBox * cb);
};

#endif
