/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: eggArc.h 96 2009-11-11 14:38:24Z sirakaba $
*******************************************************************************/

//******************************************************************************
//    Defines
//******************************************************************************

// Type Code
typedef int egg_type;
const egg_type EGG_TYPE_INVALID = 0;
const egg_type EGG_TYPE_ALZ     = 1;
const egg_type EGG_TYPE_EGG     = 2;

// Error Code
const UINT EGG_ERROR_FAIL       = 0;
const UINT EGG_ERROR_SUCCESS    = 1;
const UINT EGG_ERROR_SKIP       = 2;
const UINT EGG_ERROR_CANCEL     = 3;
const UINT EGG_ERROR_IO         = 4;
const UINT EGG_ERROR_TYPEMISMATCH=5;
const UINT EGG_ERROR_FILE       = 6;
const UINT EGG_ERROR_FORMAT     = 7;
const UINT EGG_ERROR_ALGORITHM  = 8;

// Work Code
const UINT EGG_WORKCODE_NONE    = 0;
const UINT EGG_WORKCODE_SCAN    = 1;
const UINT EGG_WORKCODE_EXTRACT = 2;

//******************************************************************************
//    Structures
//******************************************************************************

typedef size_t egg_handle;

struct EGGFileHeader
{
    size_t size;
    LPCTSTR fileName;
    LPCTSTR comment;
    unsigned __int64 packedSize;
    unsigned __int64 unpackedSize;
    unsigned int attribute;
    unsigned int crc;
    unsigned int method;
    time_t lastModified;
    BOOL encrypted;
};

namespace eggevent
{
    struct Extract
    {
        static const UINT CODE = 1;

        size_t index;
        LPCTSTR nameInArchive;
        TCHAR fileName[MAX_PATH];
    };

    struct Progress
    {
        static const UINT CODE = 2;
        short total;
        short current;
    };

    struct Start
    {
        static const UINT CODE = 3;
        UINT code;
    };
    
    struct Finish
    {
        static const UINT CODE = 4;
        UINT code;
        UINT result;
    };

    struct ActivityStart
    {
        static const UINT CODE = 5;
        size_t index;
        UINT code;
    };

    struct ActivityFinish
    {
        static const UINT CODE = 6;
        size_t index;
        UINT code;
        UINT result;
    };

    struct QueryPassword
    {
        static const UINT CODE = 7;
        size_t index;
        size_t queryCount;
        TCHAR password[1024];
    };

    struct Error
    {
        static const UINT CODE = 8;
        UINT code;
    };

    typedef UINT (__cdecl *Proc)(void* user, UINT code, void* param);
};
