/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: cls_filedroptarget.cpp 159 2009-12-02 13:01:42Z sirakaba $
*******************************************************************************/

#include "lychee.h"

#include "frm_main.h"
#include "cls_filedroptarget.h"

//******************************************************************************
// myFileDropTarget
//******************************************************************************

myFileDropTarget::myFileDropTarget(MainFrame * mainFrame)
{
	this->mainFrame = mainFrame;
}

//******************************************************************************
// Event handler.
//******************************************************************************

bool myFileDropTarget::OnDropFiles(wxCoord, wxCoord, const wxArrayString & asFiles)
{
	wxCommandEvent e;

	// 書庫に対応しているかどうか確認。
	if (asFiles.GetCount() == 1 && this->mainFrame->LoadTPI(asFiles[0]) != 0)
	{
		// 書庫を開く。
		this->mainFrame->fnArchive = wxFileName(asFiles[0]);
		this->mainFrame->OnArcOpen(e);
		return true;
	}

	// 対応していない場合は格納(or追加圧縮)を試みる。
	wxArrayString as = asFiles;
	e.SetClientData(& as);
	this->mainFrame->OnArcCreate(e);

	return true;
}
