/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: functions.cpp 125 2009-11-19 14:17:38Z sirakaba $
*******************************************************************************/

//******************************************************************************
//    t@Cǂݍ
//******************************************************************************

#include "lychee.h"
#include "frm_main.h"
#include "dlg_make.h"
#include "functions.h"

//******************************************************************************
//    Rg[n֐
//******************************************************************************

bool TreeView_CheckNewerItem(wxTreeCtrl * tree_ctrl, wxTreeItemId idParent, const wxString & szDirPath, bool bReallyMake)
{
	// ŏ̎qACe擾B
	wxTreeItemIdValue idv;
	wxTreeItemId idChild = tree_ctrl->GetFirstChild(idParent, idv);
	wxChar cSep = wxFileName::GetPathSeparator();
	while (idChild.IsOk())
	{
		// ACeƖOȂOKB
		if (tree_ctrl->GetItemText(idChild) == szDirPath.BeforeFirst(cSep))
		{
			// ȉ̊KwꍇB
			if (szDirPath.Find(cSep) == wxNOT_FOUND)
			{
				return bReallyMake;
			}

			// ܂KwLꍇAċAB
			return TreeView_CheckNewerItem(tree_ctrl, idChild, szDirPath.AfterFirst(cSep), bReallyMake);
		}

		idChild = tree_ctrl->GetNextSibling(idChild);
	}

	// Ώۂꍇɂ͍쐬B
	if (! szDirPath.IsEmpty())
	{
		if (! bReallyMake)
		{
			// mF邾Ȃ炱ŏIB
			return true;
		}

		// 2Kwȏ[ꍇɂΉB
		wxString szTemp = szDirPath;
		wxTreeItemId idTemp = idParent;
		do
		{
			// WJĂ쐬B
			idTemp = tree_ctrl->AppendItem(idTemp, szTemp.BeforeFirst(cSep), 0, 1);
			szTemp = szTemp.AfterFirst(cSep);
		}
		while (szTemp.Find(cSep) != wxNOT_FOUND);

		// ŌɋłȂꍇɂ͂1Kw쐬B
		if (! szTemp.IsEmpty())
		{
			tree_ctrl->AppendItem(idTemp, szTemp, 0, 1);
		}
	}

	return false;
}

wxString TreeView_GetItemPath(wxTreeCtrl * tree_ctrl, wxTreeItemId idItem)
{
	wxString szItemName, szNodePath = wxEmptyString;
	wxChar cSep = wxFileName::GetPathSeparator();

	// ACe̖O擾B
	while ((szItemName = tree_ctrl->GetItemText(idItem)))
	{
		if (szItemName == wxT("-----"))
		{
			break;
		}

		// pXɒǉB
		szNodePath = szItemName + cSep + szNodePath;

		// eACeɑkB
		idItem = tree_ctrl->GetItemParent(idItem);
		if (idItem == tree_ctrl->GetRootItem())
		{
			// ɂ̂͏ɓS\B
			szNodePath = wxT("*");
			break;
		}
	}

	return (szNodePath.Find(cSep) == wxNOT_FOUND) ? szNodePath : szNodePath.BeforeLast(cSep);
}

//******************************************************************************
//    ֐
//******************************************************************************

// fBNgVKɍ쐬B
wxFileName MakeDirPath(wxFileName fnPath, wxString szBase, bool bAct)
{
	// Ƃ肠Ă݂B
	wxFileName fnDir = fnPath;
	fnDir.AppendDir(szBase);
	if (! fnDir.DirExists() && ! ::wxFileExists(fnDir.GetPath()))
	{
		if (! bAct || fnDir.Mkdir())
		{
			return fnDir;
		}
	}

	// _Ȃ"_%d"tĎsB
	for (int i = 0; i < 255; i++)
	{
		fnDir = fnPath;
		fnDir.AppendDir(szBase + wxString::Format(wxT("_%d"), i));
		if (! fnDir.DirExists() && ! ::wxFileExists(fnDir.GetPath()))
		{
			if (! bAct || fnDir.Mkdir())
			{
				return fnDir;
			}
		}
	}

	// G[IB
	fnDir.Clear();
	return fnDir;
}

wxArrayString MakeTargetFileList(MainFrame * frm, bool fOnlyOneFile)
{
	wxArrayString as;
	const int nState = frm->list_ctrl->GetSelectedItemCount() == 0 ? wxLIST_STATE_DONTCARE : wxLIST_STATE_SELECTED;
	long nId = frm->list_ctrl->GetNextItem(-1, wxLIST_NEXT_ALL, nState);
	while (nId != -1)
	{
		as.Add(frm->list_ctrl->showFileInfo[nId].szStoredName);
		if (fOnlyOneFile)
		{
			break;
		}
		nId = frm->list_ctrl->GetNextItem(nId, wxLIST_NEXT_ALL, nState);
	}

	return as;
}

bool WillMakeDirByArcName(MainFrame * frm, MakeDialog * mk)
{
	if (mk->chDirMake->GetSelection() != 2)
	{
		return mk->chDirMake->GetSelection() == 1;
	}

	// [gɃfBNgƃt@C킹2ȏ゠ƂAfBNg쐬B
	wxTreeItemId tiArcRoot = frm->tree_ctrl->GetLastChild(frm->tree_ctrl->GetRootItem());
	switch (frm->tree_ctrl->GetChildrenCount(tiArcRoot, false))
	{
	case 0:
	{
		// fBNgȂ̂ŁA[gɃt@C2ȏ゠邩ǂ𔻒B
		bool fFlag = false;
		for (size_t i = 0; i < frm->fileinfo.GetCount(); i++)
		{
			if (frm->fileinfo[i].fnFileName.GetPath().IsEmpty())
			{
				// t@C̓[gɂB
				if (fFlag)
				{
					return true;
				}

				fFlag = true;
			}
		}
		break;
	}
	case 1:
		// fBNg1Ȃ̂ŁA[gɃt@CȂǂ𔻒B
		for (size_t i = 0; i < frm->fileinfo.GetCount(); i++)
		{
			// fBNgoi[Ăꍇɂ́A̖Oc[r[̃ACeɈvꍇ̓JEgȂB
			if (frm->fileinfo[i].fnFileName.GetPath().IsEmpty() && frm->fileinfo[i].fnFileName.GetFullName() != frm->tree_ctrl->GetItemText(frm->tree_ctrl->GetLastChild(tiArcRoot)))
			{
				return true;
			}
		}
		break;
	default:
		// fBNg2ȏ゠̂ŁAIɓWJfBNg쐬B
		return true;
	}

	return false;
}

wxString GetFileTypeName(wxFileName fn)
{
	wxString szExt = fn.GetExt().MakeUpper();
	wxString sz = szExt + (szExt.IsEmpty() ? wxT("file") : wxT(" file"));
	wxFileType * ftFile = wxTheMimeTypesManager->GetFileTypeFromExtension(szExt);
	if (ftFile)
	{
		ftFile->GetDescription(& sz);
	}
	return sz;
}

wxIcon GetFileTypeIcon(wxFileName fn)
{
	wxIcon icon;
	wxIconLocation ilFile;
	wxFileType * ftFile = wxTheMimeTypesManager->GetFileTypeFromExtension(fn.GetExt());
	if (ftFile && ftFile->GetIcon(& ilFile))
	{
		if (! ::wxFileExists(ilFile.GetFileName()))
		{
			icon.CopyFromBitmap(wxBitmap((ilFile.GetFileName() == wxT("%1") || ilFile.GetFileName() == wxT("\"%1\"")) ? FE_DIR_S_ICO wxT("exe.png") : FE_DIR_S_ICO wxT("file.png"), wxBITMAP_TYPE_ANY));
		}
		else
		{
			icon = wxIcon(ilFile);
		}
	}
	else
	{
		icon.CopyFromBitmap(wxBitmap(FE_DIR_S_ICO wxT("file.png"), wxBITMAP_TYPE_ANY));
	}
	return icon;
}
