/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: library.h,v 1.5 2009/09/27 10:11:13 sirakaba Exp $
*******************************************************************************/

//******************************************************************************
//    Includes
//******************************************************************************

#include "../header/plugin.h"
#include <wx/file.h>

//******************************************************************************
//    Functions
//******************************************************************************

wxString MakeCommandLineSend(wxString szCommandLine, wxString szArcName, TPI_SWITCHES * swInfo, wxArrayString asFiles, wxString szResponceFileName);
wxString MakeResponceFile(wxArrayString asFiles, bool bQuote);
wxString MB2String(const char * sz);
wxString UTF82String(const char * sz);
wxString WC2String(const wchar_t * sz);

#ifdef wxUSE_XML
#include <wx/xml/xml.h>
#define CheckSupportedCommand(attr, value) if (xmlLibrary->HasProp(wxT(attr)) || xmlLibrary->HasProp(wxT(attr) wxT("-alt"))) _fiInfo->llSupportedCommand |= value
#define CheckSupportedSwitch(var,   value) value = szCmdLine.Find(wxT(var)) != wxNOT_FOUND

inline short GetNumValue(wxXmlNode * node, wxString szValue)
{
	long l;
	node->GetPropVal(szValue, wxT("0")).ToLong(& l);
	return (short) l;
}

inline void MakeFormatInfo(wxString szTPIName, TPI_FORMATINFO * _fiInfo, wxXmlNode * xmlLibrary, wxULongLong llId)
{
	_fiInfo->szTypeName   = xmlLibrary->GetPropVal(wxT("typename"),wxEmptyString);
	_fiInfo->szSuffix     = xmlLibrary->GetPropVal(wxT("suffix"),  wxEmptyString);
	_fiInfo->szEngineName = xmlLibrary->GetPropVal(wxT("name"),    wxEmptyString);
	_fiInfo->szTPIName    = szTPIName;
	_fiInfo->llTypeId     = llId;

	// ΉR}h𒲍B
	CheckSupportedCommand("add",    TPI_COMMAND_ADD);
	CheckSupportedCommand("extract",TPI_COMMAND_EXTRACT);
	CheckSupportedCommand("delete", TPI_COMMAND_DELETE);
	CheckSupportedCommand("update", TPI_COMMAND_UPDATE);
	CheckSupportedCommand("test",   TPI_COMMAND_TEST);
	CheckSupportedCommand("repair", TPI_COMMAND_REPAIR);
	CheckSupportedCommand("move",   TPI_COMMAND_MOVE);
	CheckSupportedCommand("sfx",    TPI_COMMAND_SFX);
	CheckSupportedCommand("unsfx",  TPI_COMMAND_UNSFX);

	// ΉXCb`𒲍B
	wxString szCmdLine =
		xmlLibrary->HasProp(wxT("add"))         ? xmlLibrary->GetPropVal(wxT("add"),         wxEmptyString) :
		xmlLibrary->HasProp(wxT("add-alt"))     ? xmlLibrary->GetPropVal(wxT("add-alt"),     wxEmptyString) :
		xmlLibrary->HasProp(wxT("extract"))     ? xmlLibrary->GetPropVal(wxT("extract"),     wxEmptyString) :
		xmlLibrary->HasProp(wxT("extract-alt")) ? xmlLibrary->GetPropVal(wxT("extract-alt"), wxEmptyString) :
		(wxString) wxEmptyString;
	CheckSupportedSwitch("96", _fiInfo->fComment);
	CheckSupportedSwitch("a1", _fiInfo->fSFX);
	CheckSupportedSwitch("a2", _fiInfo->fSolid);
	CheckSupportedSwitch("a3", _fiInfo->fMMOptimize);
	CheckSupportedSwitch("a4", _fiInfo->fEncryptHeader);
	CheckSupportedSwitch("a5", _fiInfo->fEncryptPassword);
	CheckSupportedSwitch("a6", _fiInfo->fEncryptKeyFile);
	CheckSupportedSwitch("a7", _fiInfo->fMultiVolume);

	_fiInfo->sCompressLevelMin  = GetNumValue(xmlLibrary, wxT("level-min"));
	_fiInfo->sCompressLevelMax  = GetNumValue(xmlLibrary, wxT("level-max"));
	_fiInfo->sRecoveryRecordMin = GetNumValue(xmlLibrary, wxT("rr-min"));
	_fiInfo->sRecoveryRecordMax = GetNumValue(xmlLibrary, wxT("rr-max"));
}

#endif
