/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: frm_main.cpp,v 1.42 2009/09/05 03:24:58 sirakaba Exp $
*******************************************************************************/

#include "frontend.h"

#include "frm_main.h"
#include "cls_filedroptarget.h"
#include "dlg_make.h"
#include "dlg_process.h"
#include "functions.h"

#include <wx/fileconf.h>
#include <wx/arrimpl.cpp>

WX_DEFINE_OBJARRAY(ArrayTPI_FILEINFO);

#define SetMenuToolState(id, state) this->toolbar->EnableTool(XRCID(id), state); this->menubar->Enable(XRCID(id), state)

//******************************************************************************
//    O[oϐ
//******************************************************************************

wxImageList g_hIconT(16, 16), g_hIconLL(32, 32), g_hIconLS(16, 16);
int g_nSortColumn;
bool g_fSortAscend;

//******************************************************************************
// MainFrame
//******************************************************************************

MainFrame::MainFrame(): wxFrame()
{
}

MainFrame::~MainFrame()
{
	wxCommandEvent e;
	this->OnArcClose(e);

	// ݒL^B
	wxFileConfig fc(wxEmptyString, wxEmptyString, ::wxGetCwd() + wxT("/frontend.conf"), wxEmptyString, wxCONFIG_USE_LOCAL_FILE);
	if (! this->IsIconized() && ! this->IsMaximized())
	{
		int a, b;
		this->GetSize(& a, & b);
		fc.Write(wxT("Window-Width"), a);
		fc.Write(wxT("Window-Height"), b);
		this->GetPosition(& a, & b);
		fc.Write(wxT("Window-X"), a);
		fc.Write(wxT("Window-Y"), b);
	}
	fc.Write(wxT("Splitter-Pos"), this->window_splitter->GetSashPosition());
	fc.Write(wxT("LastOpenPath"), this->fnLastOpenPath.GetFullPath());

	// ListView֘AB
	fc.Write(wxT("ListView-IconMode"), this->menubar->IsChecked(XRCID("Exe_View_Icons")));
	fc.Write(wxT("ListView-C-Filename"), this->list_ctrl->GetColumnWidth(0));
	fc.Write(wxT("ListView-C-Unpacked"), this->list_ctrl->GetColumnWidth(1));
	fc.Write(wxT("ListView-C-Packed"), this->list_ctrl->GetColumnWidth(2));
	fc.Write(wxT("ListView-C-Ratio"), this->list_ctrl->GetColumnWidth(3));
	fc.Write(wxT("ListView-C-Method"), this->list_ctrl->GetColumnWidth(4));
	fc.Write(wxT("ListView-C-Attr"), this->list_ctrl->GetColumnWidth(5));
	fc.Write(wxT("ListView-C-Lastmodified"), this->list_ctrl->GetColumnWidth(6));
	fc.Write(wxT("ListView-C-Path"), this->list_ctrl->GetColumnWidth(7));
	fc.Write(wxT("ListView-C-Type"), this->list_ctrl->GetColumnWidth(8));
	fc.Write(wxT("ListView-C-No"), this->list_ctrl->GetColumnWidth(9));
	fc.Write(wxT("ListView-SortColumn"), g_nSortColumn);
	fc.Write(wxT("ListView-SortAscend"), g_fSortAscend);

	this->Close(true);
}

//******************************************************************************
// Event Table.
//******************************************************************************

BEGIN_EVENT_TABLE(MainFrame, wxFrame)
	EVT_INIT_DIALOG(      MainFrame::OnInit)
	// Menu
	EVT_MENU(XRCID("Arc_Create"),  MainFrame::OnArcCreate)
	EVT_MENU(XRCID("Arc_Open"),    MainFrame::OnArcOpen)
	EVT_MENU(XRCID("Arc_Close"),   MainFrame::OnArcClose)
	EVT_MENU(XRCID("Arc_Add"),     MainFrame::OnArcAdd)
	EVT_MENU(XRCID("Arc_SFX"),     MainFrame::OnArcSFX)
	EVT_MENU(XRCID("Arc_UnSFX"),   MainFrame::OnArcUnSFX)
	EVT_MENU(XRCID("Exe_Exit"),    MainFrame::OnExit)
	EVT_MENU(XRCID("Arc_Extract"), MainFrame::OnArcExtract)
	EVT_MENU(XRCID("Arc_Delete"),  MainFrame::OnArcDelete)
	EVT_MENU(XRCID("Arc_Test"),    MainFrame::OnArcTest)
	EVT_MENU(XRCID("Arc_Repair"),  MainFrame::OnArcRepair)
	EVT_MENU(XRCID("Exe_View_Icons"),  MainFrame::OnViewMode)
	EVT_MENU(XRCID("Exe_View_Details"),MainFrame::OnViewMode)
	EVT_MENU(XRCID("Exe_View_SelectAll"),MainFrame::OnSelectAll)
	// TreeView
	EVT_TREE_SEL_CHANGED(XRCID("TreeView"), MainFrame::OnTreeChanged)
	// ListView
	EVT_LIST_ITEM_ACTIVATED(XRCID("ListView"), MainFrame::OnListItemDClick)
	EVT_LIST_BEGIN_DRAG(XRCID("ListView"), MainFrame::OnListBeginDrag)
END_EVENT_TABLE()

//******************************************************************************
// Event handler.
//******************************************************************************

void MainFrame::OnInit(wxInitDialogEvent&)
{
	// XRCƌтB
	this->menubar    = this->GetMenuBar();
	this->toolbar    = this->GetToolBar();
	this->statusbar = XRCCTRL(* this, "statusbar", wxStatusBar);
	this->tree_ctrl = XRCCTRL(* this, "TreeView", wxTreeCtrl);
	this->list_ctrl = XRCCTRL(* this, "ListView", myListCtrl);
	this->window_splitter = XRCCTRL(* this, "window_splitter", wxSplitterWindow);

	// ݒǂݍ݁B
	wxFileConfig fc(wxEmptyString, wxEmptyString, ::wxGetCwd() + wxT("/frontend.conf"), wxEmptyString, wxCONFIG_USE_LOCAL_FILE);
	this->SetSize(fc.Read(wxT("Window-X"), 0l), fc.Read(wxT("Window-Y"), 0l), fc.Read(wxT("Window-Width"), 800), fc.Read(wxT("Window-Height"), 400));
	this->fnLastOpenPath = wxFileName::DirName(fc.Read(wxT("LastOpenPath"), ::wxGetCwd()));
	wxTheMimeTypesManager->Initialize(wxMAILCAP_ALL);

	// lݒB
	{
		wxIcon icon;
		icon.CopyFromBitmap(wxBitmap(FE_DIR_S_ICO wxT("app.png"), wxBITMAP_TYPE_ANY));
		this->SetIcon(icon);
	}

	wxCommandEvent e;
	e.SetId(fc.Read(wxT("ListView-IconMode"), 0l) ? XRCID("Exe_View_Icons") : XRCID("Exe_View_Details"));
	this->OnArcClose(e);
	this->OnViewMode(e);
	this->window_splitter->SetSashPosition(fc.Read(wxT("Splitter-Pos"), 200));
	// wxGTKł͒wxLC_VIRTUALw肵ȂƔfȂB
	this->list_ctrl->SetSingleStyle(wxLC_VIRTUAL);
	this->list_ctrl->InsertColumn(0, wxT("Filename"),      wxLIST_FORMAT_LEFT,  fc.Read(wxT("ListView-C-Filename"), 140));
	this->list_ctrl->InsertColumn(1, wxT("Unpacked"),      wxLIST_FORMAT_RIGHT,  fc.Read(wxT("ListView-C-Unpacked"), 80));
	this->list_ctrl->InsertColumn(2, wxT("Packed"),        wxLIST_FORMAT_RIGHT,  fc.Read(wxT("ListView-C-Packed"), 80));
	this->list_ctrl->InsertColumn(3, wxT("Ratio"),         wxLIST_FORMAT_RIGHT,  fc.Read(wxT("ListView-C-Ratio"), 50));
	this->list_ctrl->InsertColumn(4, wxT("Method"),        wxLIST_FORMAT_LEFT,   fc.Read(wxT("ListView-C-Method"), 60));
	this->list_ctrl->InsertColumn(5, wxT("Attr"),          wxLIST_FORMAT_LEFT,   fc.Read(wxT("ListView-C-Attr"), 50));
	this->list_ctrl->InsertColumn(6, wxT("Last modified"), wxLIST_FORMAT_RIGHT, fc.Read(wxT("ListView-C-Lastmodified"), 150));
	this->list_ctrl->InsertColumn(7, wxT("Path"),          wxLIST_FORMAT_LEFT,  fc.Read(wxT("ListView-C-Path"), 100));
	this->list_ctrl->InsertColumn(8, wxT("Type"),          wxLIST_FORMAT_LEFT,  fc.Read(wxT("ListView-C-Type"), 100));
	this->list_ctrl->InsertColumn(9, wxT("No."),           wxLIST_FORMAT_LEFT,   fc.Read(wxT("ListView-C-No"), 35));
	g_nSortColumn = fc.Read(wxT("ListView-SortColumn"), 9);
	g_fSortAscend = fc.Read(wxT("ListView-SortAscend"), 1) == 1;

	this->list_ctrl->SetDropTarget(new myFileDropTarget(this));

	int nStatusBarParts[] = {40, 60, 120, 120, 90, 1000};
	this->statusbar->SetFieldsCount(6, nStatusBarParts);

	// R}hCǂݍ݁B
	this->cmdLine.SetSwitchChars(wxT("-"));
	this->cmdLine.AddSwitch(wxT("x"), wxEmptyString, wxT("(command) Extract filenames in archive."));
	this->cmdLine.AddSwitch(wxT("l"), wxEmptyString, wxT("(command) List archive(default)."));
	this->cmdLine.AddParam(wxT("archive"),   wxCMD_LINE_VAL_STRING, wxCMD_LINE_PARAM_OPTIONAL);
	this->cmdLine.AddParam(wxT("filenames"), wxCMD_LINE_VAL_STRING, wxCMD_LINE_PARAM_OPTIONAL | wxCMD_LINE_PARAM_MULTIPLE);
	if (this->cmdLine.Parse() == 0)
	{
		if (this->cmdLine.GetParamCount() == 0)
		{
			return;
		}

		// ɂJB
		wxFileName fnArchive(this->cmdLine.GetParam(0));
		fnArchive.Normalize(wxPATH_NORM_ALL, this->szCurrentPath);
		e.SetString(fnArchive.GetFullPath());
		this->OnArcOpen(e);
		if (this->cmdLine.Found(wxT("x")))
		{
			// ɂWJB
			this->OnArcExtract(e);
			this->Close(true);
		}
	}
}

// MenuBar

void MainFrame::OnExit(wxCommandEvent&)
{
	this->Close(true);
}

void MainFrame::OnArcCreate(wxCommandEvent& e)
{
	TPI_SWITCHES swInfo;
	swInfo.pCustomSwitches = NULL;

	// 쐬_CAOݒB
	MakeDialog mkDlg;
	::wxXmlResource::Get()->Load(FE_DIR_S_XRC wxT("dlg_make.xrc"));
	::wxXmlResource::Get()->LoadDialog(& mkDlg, this, wxT("dlg_make"));	

	if (e.GetClientData() == NULL)
	{
		// Ώۂ̃t@CIB
		wxFileDialog fd(this, wxT("Choose files to compress"), this->fnLastOpenPath.GetFullPath());
		fd.SetWindowStyleFlag(wxFD_OPEN | wxFD_FILE_MUST_EXIST | wxFD_MULTIPLE);
		if (fd.ShowModal() == wxID_CANCEL)
		{
			return;
		}
		// wxFileName::FileNamepĂ̂́AŃfBNgKvƂꍇ邽߁B
		// ܂悢dlł͂Ȃ̂łƂ肠uB
		this->fnLastOpenPath = wxFileName::FileName(fd.GetDirectory());
		swInfo.fnDestinationDirectory = wxFileName::DirName(this->fnLastOpenPath.GetFullPath());
		this->statusbar->SetStatusText(swInfo.fnDestinationDirectory.GetFullPath(), 5);

		fd.GetFilenames(mkDlg.files);
	}
	else
	{
		mkDlg.files = * (wxArrayString *) e.GetClientData();
		swInfo.fnDestinationDirectory = wxFileName::DirName(wxFileName::FileName(mkDlg.files[0]).GetPath());
		// ΃pXɕϊB
		for (size_t n = 0; n < mkDlg.files.Count(); n++)
		{
			wxFileName fn(mkDlg.files[n]);
			bool fIsDir = fn.DirExists() && ! fn.FileExists();
			fn.MakeRelativeTo(swInfo.fnDestinationDirectory.GetPath());
			mkDlg.files[n] = fn.GetFullPath();
			if (fIsDir)
			{
				mkDlg.files[n] += fn.GetPathSeparator();
			}
		}
	}

	mkDlg.InitDialog();
	mkDlg.cbDir->SetValue(swInfo.fnDestinationDirectory.GetPath());
	// ɖ̓t@C̊gqOA̓fBNgB
	wxFileName fnFirstFile(mkDlg.files[0]);
	mkDlg.cbFileName->SetValue(mkDlg.files.GetCount() == 1 ? (fnFirstFile.GetName().IsEmpty() ? fnFirstFile.GetDirs().Last() : fnFirstFile.GetName()) : swInfo.fnDestinationDirectory.GetDirs().Last());

	// _CAO\B
	if (mkDlg.ShowModal() == wxID_CANCEL)
	{
		this->statusbar->SetStatusText(wxEmptyString, 5);
		return;
	}
	this->statusbar->SetStatusText(wxEmptyString, 5);

	// eݒB
	swInfo.fStoreDirectoryPathes= ! mkDlg.cbIgnorePath->IsChecked();
	swInfo.fMakeSFX			    = mkDlg.cbMakeSFX->IsChecked();
	swInfo.fSolid               = mkDlg.cbSolid->IsChecked();
	swInfo.fMMOptimize          = mkDlg.cbMMOptimize->IsChecked();
	swInfo.fEncryptHeader       = mkDlg.cbEncryptHeader->IsChecked();
	swInfo.sCompressLevel       = mkDlg.scLevel->GetValue();
	swInfo.sRecoveryRecord      = mkDlg.scRR->GetValue();
	swInfo.szPassword           = mkDlg.tcPassword->GetValue();
	swInfo.szKeyFile            = mkDlg.tcKeyfile->GetValue();
	swInfo.szComment            = mkDlg.tcComment->GetValue();
	{
		wxULongLong_t ll;
		mkDlg.cbSplitSize->GetValue().ToULongLong(& ll);
		swInfo.llSplitSize      = ll;
	}

	// TPIǂݍ݁B
	int nSelected = mkDlg.chType->GetSelection();
	wxFileName fnArchive = wxFileName::DirName(mkDlg.cbDir->GetValue());
	fnArchive.SetName(mkDlg.cbFileName->GetValue());
	fnArchive.SetExt(swInfo.fMakeSFX ? EXE_EXT : mkDlg.afInfo[nSelected].szSuffix.BeforeFirst(wxT(';')));
	if (! tpi.InitLibrary(mkDlg.afInfo[nSelected].szTPIName, fnArchive.GetFullPath(), mkDlg.afInfo[nSelected].llTypeId))
	{
		::ErrDlg(wxT("InitLibrary()!"), this);
		return;
	}

	// R[obN֐ݒB
	if (tpi.SetCallbackProc(TPICallbackProc) != TPI_ERROR_SUCCESS)
	{
		::ErrDlg(wxT("SetCallbackProc()!"), this);
	}

	// sB
	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(FE_DIR_S_XRC wxT("dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));
	procDlg.InitDialog();
	procDlg.Show(true);
	int nErrorCode = this->ErrorCheck(tpi.Command(TPI_COMMAND_ADD, & swInfo, fnArchive.GetFullPath(), mkDlg.files));
	procDlg.Show(false);
	tpi.FreeLibrary();
	if (nErrorCode != TPI_ERROR_SUCCESS)
	{
		return;
	}

	if (mkDlg.cbOpenAfter->IsChecked())
	{
		// 쐬JB
#ifdef __WINDOWS__
		::wxExecute(wxT("explorer ") + swInfo.fnDestinationDirectory.GetFullPath());
#endif
	}

	if (mkDlg.cbExitAfter->IsChecked())
	{
		// IB
		this->Close(true);
	}

	// IȂꍇ͏ɂJB
	e.SetString(fnArchive.GetFullPath());
	this->OnArcOpen(e);
}

void MainFrame::OnArcOpen(wxCommandEvent& e)
{
	// ɂIB
	wxString szFileName = e.GetString();
	if (szFileName.IsEmpty())
	{
		wxFileDialog fd(this);
		fd.SetDirectory(this->fnLastOpenPath.GetFullPath());
		fd.SetWindowStyleFlag(wxFD_OPEN | wxFD_FILE_MUST_EXIST);
		if (fd.ShowModal() == wxID_CANCEL)
		{
			return;
		}
		this->fnLastOpenPath = wxFileName::DirName(fd.GetDirectory());
		szFileName = fd.GetPath();
	}
	this->OnArcClose(e);

	// i_CAO\B
	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(FE_DIR_S_XRC wxT("dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));	
	procDlg.InitDialog();
	procDlg.Show(true);

	// TPIǂݍ݁Aŏ̃R[obN𑗐MB
	TPI_PROCESSINFO piInfo;
	piInfo.uMessage = TPI_MESSAGE_STATUS;
	piInfo.uStatus = 0x1000;
	piInfo.llProcessedSize = 0;
	piInfo.fiInfo.fnFileName = wxFileName::FileName(szFileName);
	piInfo.fiInfo.llUnpackedSize = this->LoadTPI(szFileName);
	if ((signed) piInfo.fiInfo.llUnpackedSize.ToULong() == -1)
	{
		procDlg.Show(false);
		tpi.FreeLibrary();
		::ErrDlg(wxT("No plug-in supporting this archive was found!"), this);
		return;
	}
	TPICallbackProc(TPI_NOTIFY_COMMON, & piInfo);

	// z̃TCYmہB
	this->fileinfo.Alloc(piInfo.fiInfo.llUnpackedSize.ToULong());

	// ɂJB
	if (tpi.OpenArchive(szFileName) != TPI_ERROR_SUCCESS)
	{
		procDlg.Show(false);
		tpi.FreeLibrary();
		::ErrDlg(wxT("OpenArchive()!"), this);
		return;
	}

	// ɂ̃ACR擾AɃ[g쐬B
	g_hIconT.Add(wxBitmap(FE_DIR_S_ICO wxT("folder_closed.png"), wxBITMAP_TYPE_ANY));
	g_hIconT.Add(wxBitmap(FE_DIR_S_ICO wxT("folder_open.png"), wxBITMAP_TYPE_ANY));
	this->tree_ctrl->SetImageList(& g_hIconT);
	wxTreeItemId
		idRoot = this->tree_ctrl->AddRoot(wxEmptyString),
#ifdef __WINDOWS__
		idArchive = this->tree_ctrl->InsertItem(idRoot, idRoot, piInfo.fiInfo.fnFileName.GetFullName(), g_hIconT.Add(GetFileTypeIcon(piInfo.fiInfo.fnFileName))),
#else
		idArchive = this->tree_ctrl->InsertItem(idRoot, idRoot, piInfo.fiInfo.fnFileName.GetFullName(), g_hIconT.Add(GetFileTypeIcon(piInfo.fiInfo.fnFileName).ConvertToImage().Rescale(16, 16))),
#endif
		idArcRoot = this->tree_ctrl->InsertItem(idRoot, idArchive, wxT("-----"), 0, 1);

	// t@C[hB
	if (tpi.GetFileInformation(& piInfo.fiInfo, true) == TPI_ERROR_SUCCESS)
	{
		piInfo.uStatus = 0x1001;
		do
		{
			piInfo.llProcessedSize++;
			if (this->ErrorCheck(TPICallbackProc(TPI_NOTIFY_COMMON, & piInfo)) == TPI_CALLBACK_CANCEL)
			{
				procDlg.Show(false);
				tpi.CloseArchive();
				wxCommandEvent e;
				this->OnArcClose(e);
				return;
			}

			// c[r[ɔfB
			TreeView_CheckNewerItem(this->tree_ctrl, idArcRoot, piInfo.fiInfo.fnFileName.GetPath(wxPATH_GET_VOLUME), true);

			// fBNg܂ނ̂ɂĂ͏B
			if (piInfo.fiInfo.dwAttribute & TPI_ATTRIBUTE_DIRECTORY)
			{
				continue;
			}

			// ZLeB`FbNB
			// DTVB
			if (piInfo.fiInfo.fnFileName.GetPathWithSep().Find(wxT("..")) != wxNOT_FOUND)
			{
				piInfo.fiInfo.uDanger = TRUE;
				::WrnDlg(wxT("This archive may have Directory Traversal Vulnerability(DTV) problem, and some danger files may be extracted to the unexpected system directory! You should use the \"Ignore file pathes\" option when extracting this archive.\nDanger file is:\n") + piInfo.fiInfo.szStoredName, this);
			}
			// 󔒂̘AɂgqUB
			if (piInfo.fiInfo.fnFileName.GetFullName().Find(wxT("        ")) != wxNOT_FOUND)
			{
				piInfo.fiInfo.uDanger = TRUE;
				::WrnDlg(wxT("This archive may contain extension-disguised files whose real extension is hidden by using many blank charactor and you may mistake that it is a \"safe\" file. Don\'t execute these files carelessly.\nDanger file is:\n") + piInfo.fiInfo.szStoredName, this);
			}
			// Unicode䕶B
			for (wxChar c = 0x200c; c <= 0x206f; c++)
			{
				if (piInfo.fiInfo.fnFileName.GetFullName().Find(c) != wxNOT_FOUND)
				{
					piInfo.fiInfo.uDanger = TRUE;
					::WrnDlg(wxT("This archive may contain extension-disguised files whose real extension is hidden by using Unicode control character and you may mistake that it is a \"safe\" file. Don\'t execute these files carelessly.\nDanger file is:\n") + piInfo.fiInfo.szStoredName, this);
				}
				switch (c)
				{
				case 0x200f: c = 0x2027; break;
				case 0x202e: c = 0x2060; break;
				}
			}

			// ۑăJEgAbvB
			this->fileinfo.Add(piInfo.fiInfo);
		}
		while (tpi.GetFileInformation(& piInfo.fiInfo, false) == TPI_ERROR_SUCCESS);
	}

	// ɂ̏擾B
	TPI_ARCHIVEINFO aiInfo;
	if (tpi.GetArchiveInformation(& aiInfo) != TPI_ERROR_SUCCESS)
	{
		procDlg.Show(false);
		tpi.FreeLibrary();
		::ErrDlg(wxT("GetArchiveInformation()!"), this);
		return;
	}

	// ɂB
	if (tpi.CloseArchive() != TPI_ERROR_SUCCESS)
	{
		::ErrDlg(wxT("CloseArchive()!"), this);
	}

	// R[obN֐ݒB
	if (tpi.SetCallbackProc(TPICallbackProc) != TPI_ERROR_SUCCESS)
	{
		::ErrDlg(wxT("SetCallbackProc()!"), this);
	}

	// ȉAUIB
	this->fileinfo.Shrink();
	this->tree_ctrl->ExpandAllChildren(idArcRoot);
	this->tree_ctrl->ScrollTo(idArchive);
	this->tree_ctrl->SelectItem(idArchive);
	this->list_ctrl->atDangerItem.SetTextColour(* wxRED);

	// Xe[^Xo[ݒB
	this->statusbar->SetStatusText(wxEmptyString, 0);
	this->statusbar->SetStatusText(wxString::Format(wxT("%d file(s)"), this->fileinfo.Count()), 1);
	this->statusbar->SetStatusText(wxT("Unpacked: ") + aiInfo.llUnpackedSize.ToString() + wxT(" B"), 2);
	this->statusbar->SetStatusText(wxT("Packed: ")   + aiInfo.llPackedSize.ToString()   + wxT(" B"), 3);
	this->statusbar->SetStatusText(wxString::Format(wxT("Ratio: %3.1f%%"), aiInfo.wCompressRatio / 10.0), 4);
	this->statusbar->SetStatusText(szFileName, 5);

	// c[o[Ej[o[ݒB
	SetMenuToolState("Arc_Close",   true);
	SetMenuToolState("Arc_Add",     (aiInfo.fiInfo.llSupportedCommand & TPI_COMMAND_ADD)    == TPI_COMMAND_ADD);
	SetMenuToolState("Arc_SFX",     (aiInfo.fiInfo.llSupportedCommand & TPI_COMMAND_SFX)    == TPI_COMMAND_SFX   && aiInfo.nSFXType == 0);
	SetMenuToolState("Arc_UnSFX",   (aiInfo.fiInfo.llSupportedCommand & TPI_COMMAND_UNSFX)  == TPI_COMMAND_UNSFX && aiInfo.nSFXType != 0);
	SetMenuToolState("Arc_Extract", (aiInfo.fiInfo.llSupportedCommand & TPI_COMMAND_EXTRACT)== TPI_COMMAND_EXTRACT);
	SetMenuToolState("Arc_Delete",  (aiInfo.fiInfo.llSupportedCommand & TPI_COMMAND_DELETE) == TPI_COMMAND_DELETE);
	SetMenuToolState("Arc_Test",    (aiInfo.fiInfo.llSupportedCommand & TPI_COMMAND_TEST)   == TPI_COMMAND_TEST);
	SetMenuToolState("Arc_Repair",  (aiInfo.fiInfo.llSupportedCommand & TPI_COMMAND_REPAIR) == TPI_COMMAND_REPAIR);

	procDlg.Show(false);
}

void MainFrame::OnArcClose(wxCommandEvent&)
{
	// c[r[EXgr[ݒB
	this->tree_ctrl->DeleteAllItems();
	this->list_ctrl->DeleteAllItems();
	this->list_ctrl->showFileInfo.Clear();

	// c[o[Ej[o[ݒB
	SetMenuToolState("Arc_Close",   false);
	SetMenuToolState("Arc_Add",     false);
	SetMenuToolState("Arc_SFX",     false);
	SetMenuToolState("Arc_UnSFX",   false);
	SetMenuToolState("Arc_Extract", false);
	SetMenuToolState("Arc_Delete",  false);
	SetMenuToolState("Arc_Test",    false);
	SetMenuToolState("Arc_Repair",  false);

	for (int i = 0; i < this->statusbar->GetFieldsCount(); i++)
	{
		this->statusbar->SetStatusText(wxEmptyString, i);
	}
	this->fileinfo.Clear();

	g_hIconT.RemoveAll();
	g_hIconLL.RemoveAll();
	g_hIconLS.RemoveAll();
	this->tpi.FreeLibrary();
}

void MainFrame::OnArcAdd(wxCommandEvent& e)
{
	// Ώۂ̃t@CIB
	wxArrayString files;
	wxFileDialog fd(this, wxT("Choose files to add"), this->fnLastOpenPath.GetFullPath());
	fd.SetWindowStyleFlag(wxFD_OPEN | wxFD_FILE_MUST_EXIST | wxFD_MULTIPLE);
	if (fd.ShowModal() == wxID_CANCEL)
	{
		return;
	}
	fd.GetFilenames(files);

	// eݒB
	TPI_SWITCHES swInfo;
	swInfo.fnDestinationDirectory = wxFileName::DirName(fd.GetDirectory());
	swInfo.fMakeSFX = false;
	swInfo.pCustomSwitches = NULL;
	wxString szArcName = this->statusbar->GetStatusText(5);

	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(FE_DIR_S_XRC wxT("dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));	
	procDlg.InitDialog();
	procDlg.Show(true);
	this->ErrorCheck(this->tpi.Command(TPI_COMMAND_ADD, & swInfo, szArcName, files));
	procDlg.Show(false);

	// ɂēǂݍ݁B
	e.SetString(szArcName);
	this->OnArcOpen(e);
}

void MainFrame::OnArcSFX(wxCommandEvent&)
{
	this->ConvertArc(true);
}

void MainFrame::OnArcUnSFX(wxCommandEvent&)
{
	this->ConvertArc(false);
}

void MainFrame::OnArcExtract(wxCommandEvent& e)
{
	TPI_SWITCHES swInfo;
	swInfo.pCustomSwitches = NULL;

	// [h擾Bʏ0, sȂ1, DnDȂ2B
	int nMode = e.GetInt();
	// ŝݎgpB
	wxFileType * ftFile = NULL;

	// WJ_CAO쐬BDnD܂͎s͕\ȂB
	MakeDialog mkDlg;
	mkDlg.bIsMake = false;
	mkDlg.files   = MakeTargetFileList(this, nMode == 1);

	if (nMode != 0)
	{
		if (nMode == 1)
		{
			// R}h擾B
			ftFile = wxTheMimeTypesManager->GetFileTypeFromExtension(wxFileName::FileName(mkDlg.files[0]).GetExt());
			if (! ftFile)
			{
				::ErrDlg(wxT("Unable to get the file type!"), this);
				return;
			}
		}

		// ƃfBNg쐬B
		swInfo.fStoreDirectoryPathes = false;
		swInfo.fnDestinationDirectory = MakeDirPath(wxFileName::DirName(::wxGetCwd()), wxT("tpi_tmp"), true);
		if (! swInfo.fnDestinationDirectory.IsOk())
		{
			::ErrDlg(wxT("Unable to make the temporary directory!"), this);
			return;
		}
	}
	else
	{
		::wxXmlResource::Get()->Load(FE_DIR_S_XRC wxT("dlg_make.xrc"));
		::wxXmlResource::Get()->LoadDialog(& mkDlg, this, wxT("dlg_make"));
		mkDlg.InitDialog();
		if (mkDlg.ShowModal() == wxID_CANCEL)
		{
			return;
		}

		// eݒB
		swInfo.fStoreDirectoryPathes = ! mkDlg.cbIgnorePath->IsChecked();
		swInfo.fnDestinationDirectory = wxFileName::DirName(mkDlg.cbDir->GetValue());
		swInfo.szPassword = mkDlg.tcPassword->GetValue();
		swInfo.szKeyFile  = mkDlg.tcKeyfile->GetValue();

		// KvȂ珑ɖŃfBNg쐬B
		if (WillMakeDirByArcName(this, & mkDlg))
		{
			swInfo.fnDestinationDirectory = MakeDirPath(swInfo.fnDestinationDirectory, wxFileName::FileName(this->statusbar->GetStatusText(5)).GetName(), true);
			if (! swInfo.fnDestinationDirectory.IsOk())
			{
				::ErrDlg(wxT("Unable to make the destination directory!"), this);
				return;
			}
		}
	}

	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(FE_DIR_S_XRC wxT("dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));	
	procDlg.InitDialog();
	procDlg.Show(true);
	int nErrorCode = this->ErrorCheck(this->tpi.Command(TPI_COMMAND_EXTRACT, & swInfo, this->statusbar->GetStatusText(5), mkDlg.files));
	procDlg.Show(false);

	if (nMode == 0)
	{
		if (mkDlg.cbOpenAfter->IsChecked())
		{
			// WJJB
#ifdef __WINDOWS__
			::wxExecute(wxT("explorer ") + swInfo.fnDestinationDirectory.GetFullPath());
#endif
		}

		if (mkDlg.cbExitAfter->IsChecked())
		{
			// IB
			this->Close(true);
		}
	}
	else
	{
		wxArrayString asFiles;
		if (nMode == 1)
		{
			// R}hsB
			asFiles.Add(swInfo.fnDestinationDirectory.GetPathWithSep() + wxFileName::FileName(mkDlg.files[0]).GetFullName());
			if (nErrorCode == TPI_ERROR_SUCCESS)
			{
				::wxExecute(ftFile->GetOpenCommand(asFiles[0]), wxEXEC_SYNC);
			}
		}
		else
		{
			// WJΏۂB
			wxFileDataObject objFile;
			for (size_t i = 0; i < mkDlg.files.Count(); i++)
			{
				// XgɒǉB
				objFile.AddFile(swInfo.fnDestinationDirectory.GetPathWithSep() + wxFileName::FileName(mkDlg.files[i]).GetFullName());
			}

			// DnDJnB
			wxDropSource dropSource(objFile, this);
			if (dropSource.DoDragDrop() != wxDragMove)
			{
#ifdef __LINUX__
				// Linuxł͂܂IĂȂ(ReLXgj[\Ă)̂ŁAƂ肠3b҂B
				sleep(3);
#endif
			}
			asFiles = objFile.GetFilenames();
		}

		// t@CƈꎞfBNg폜B
		for (size_t i = 0; i < asFiles.GetCount(); i++)
		{
			::wxRemoveFile(asFiles[i]);
		}
		::wxRmdir(swInfo.fnDestinationDirectory.GetFullPath());
	}
}

void MainFrame::OnArcDelete(wxCommandEvent& e)
{
	// St@C폜͊댯ł͂ȂƁB
	if (this->list_ctrl->GetSelectedItemCount() == 0)
	{
		return;
	}

	if (::AskDlg(wxT("Are you sure to delete selected files?"), this) == wxNO)
	{
		return;
	}

	// eݒB
	TPI_SWITCHES swInfo;
	wxString szArcName = this->statusbar->GetStatusText(5);
	wxArrayString files = MakeTargetFileList(this, false);

	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(FE_DIR_S_XRC wxT("dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));	
	procDlg.InitDialog();
	procDlg.Show(true);
	this->ErrorCheck(this->tpi.Command(TPI_COMMAND_DELETE, & swInfo, szArcName, files));
	procDlg.Show(false);	

	// ɂēǂݍ݂B
	e.SetString(szArcName);
	this->OnArcOpen(e);
}

void MainFrame::OnArcTest(wxCommandEvent&)
{
	// eݒB
	wxArrayString files = MakeTargetFileList(this, false);
	TPI_SWITCHES swInfo;

	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(FE_DIR_S_XRC wxT("dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));	
	procDlg.InitDialog();
	procDlg.Show(true);
	if (this->ErrorCheck(this->tpi.Command(TPI_COMMAND_TEST, & swInfo, this->statusbar->GetStatusText(5), files)) == TPI_ERROR_SUCCESS)
	{
		::MsgDlg(wxT("This is a correct archive."), & procDlg, wxICON_INFORMATION);
	}
	procDlg.Show(false);
}

void MainFrame::OnArcRepair(wxCommandEvent&)
{
	// eݒB
	wxArrayString files = MakeTargetFileList(this, false);
	TPI_SWITCHES swInfo;

	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(FE_DIR_S_XRC wxT("dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));	
	procDlg.InitDialog();
	procDlg.Show(true);
	this->ErrorCheck(this->tpi.Command(TPI_COMMAND_REPAIR, & swInfo, this->statusbar->GetStatusText(5), files));
	procDlg.Show(false);	
}

void MainFrame::OnViewMode(wxCommandEvent & e)
{
	int n = e.GetId();
	this->menubar->Check(n, true);
	this->list_ctrl->SetSingleStyle(wxLC_REPORT, n == XRCID("Exe_View_Details"));
	this->list_ctrl->SetSingleStyle(wxLC_ICON,   n == XRCID("Exe_View_Icons"));
}

void MainFrame::OnSelectAll(wxCommandEvent &)
{
	for (int i = 0; i < this->list_ctrl->GetItemCount(); i++)
	{
		this->list_ctrl->SetItemState(i, wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED);
	}
}

// TreeView

void MainFrame::OnTreeChanged(wxTreeEvent& e)
{
	// c[r[pX擾B
	wxString szNodePath = TreeView_GetItemPath(this->tree_ctrl, e.GetItem());
	// Xgr[B
	this->list_ctrl->showFileInfo.Clear();
	g_hIconLL.RemoveAll();
	g_hIconLS.RemoveAll();

	// ACRݒB
	this->list_ctrl->SetImageList(& g_hIconLL, wxIMAGE_LIST_NORMAL);
	this->list_ctrl->SetImageList(& g_hIconLS, wxIMAGE_LIST_SMALL);

	// zƔrApXvȂΏB
	for (size_t i = 0; i < this->fileinfo.GetCount(); i++)
	{
		// pXrB
		if (szNodePath == wxT("*") || szNodePath == this->fileinfo[i].fnFileName.GetPath())
		{
			// ڂtH_łȂ疳B
			if (this->fileinfo[i].fnFileName.IsDir() || ! TreeView_CheckNewerItem(this->tree_ctrl, this->tree_ctrl->GetLastChild(this->tree_ctrl->GetRootItem()), this->fileinfo[i].fnFileName.GetFullPath(), false))
			{
				continue;
			}

			this->list_ctrl->showFileInfo.Add(this->fileinfo[i]);
		}
	}
	// \[gĕ\B
	this->list_ctrl->showFileInfo.Sort(& ListCtrlCompareProc);
	this->list_ctrl->SetItemCount(this->list_ctrl->showFileInfo.Count());
}

// ListView

void MainFrame::OnListItemDClick(wxListEvent&)
{
	wxCommandEvent e;
	e.SetInt(1);
	this->OnArcExtract(e);
}

void MainFrame::OnListBeginDrag(wxListEvent&)
{
	if (this->list_ctrl->GetSelectedItemCount() == 0)
	{
		// ACeIhbO悤ƂꍇB
		return;
	}

	wxCommandEvent e;
	e.SetInt(2);
	this->OnArcExtract(e);
}

// CxgnhȊOB

int MainFrame::LoadTPI(wxString & szFileName)
{
	// TPIǂݍ݁B
	wxFileSystem fs;
	fs.ChangePathTo(FE_DIR_B_LIB, true);
	wxString szTPIName = fs.FindFirst(wxT("*" TPI_EXT), wxFILE);
	int nFileCount = -1;
	while (! szTPIName.IsEmpty())
	{
		// ΉmFB
		if (! tpi.InitLibrary(szTPIName, szFileName, 0) || ! tpi.CheckArchive(szFileName, & nFileCount) || nFileCount < 0)
		{
			tpi.FreeLibrary();
			szTPIName = fs.FindNext();
			continue;
		}
		break;
	}
	return nFileCount;
}

void MainFrame::ConvertArc(bool fToSFX)
{
	// ۑq˂B
	wxFileName fnArchive(this->statusbar->GetStatusText(5));
	wxFileDialog fd(this, fToSFX ? wxT("Save as SFX") : wxT("Save as normal archive"), fnArchive.GetPath(wxPATH_GET_VOLUME), fnArchive.GetName() + (fToSFX ? EXE_EXT : (wxString) wxEmptyString));
	fd.SetWindowStyleFlag(wxFD_SAVE | wxFD_OVERWRITE_PROMPT);
	if (fd.ShowModal() == wxID_CANCEL)
	{
		return;
	}
	this->fnLastOpenPath = wxFileName::DirName(fd.GetDirectory());

	wxArrayString files;
	files.Add(fd.GetPath());

	TPI_SWITCHES swInfo;
	swInfo.fMakeSFX = fToSFX;
	swInfo.fnDestinationDirectory = wxFileName::DirName(fd.GetDirectory());

	ProcessDialog procDlg;
	::wxXmlResource::Get()->Load(FE_DIR_S_XRC wxT("dlg_process.xrc"));
	::wxXmlResource::Get()->LoadDialog(& procDlg, this, wxT("dlg_process"));
	procDlg.InitDialog();
	procDlg.Show(true);
	this->ErrorCheck(this->tpi.Command(fToSFX ? TPI_COMMAND_SFX : TPI_COMMAND_UNSFX, & swInfo, fnArchive.GetFullPath(), files));
	procDlg.Show(false);
}

int MainFrame::ErrorCheck(int nErrorCode)
{
	switch (nErrorCode)
	{
	// ǂlTRUEȂ̂ŎbIɃRgAEgB
	case TPI_ERROR_SUCCESS:
//	case TPI_CALLBACK_CONTINUE:
		break;
	case TPI_ERROR_D_UNSUPPORTED:
		::ErrDlg(wxT("Sorry, this function is not supported yet."), this);
		break;
	case TPI_ERROR_D_SKIPPED:
	case TPI_CALLBACK_CANCEL:
		::ErrDlg(wxT("This operation is canceled by the user."), this);
		break;
	default:
		::ErrDlg(wxT("Error code is ") + wxString::Format(wxT("%d."), nErrorCode), this);
	}
	return nErrorCode;
}
