/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: dlg_process.cpp,v 1.3 2009/08/09 07:15:21 sirakaba Exp $
*******************************************************************************/

#include "frontend-wx.h"

#include "dlg_process.h"

extern bool g_fCancel;
extern ProcessDialog * g_procDlg;

//******************************************************************************
// ProcessDialog
//******************************************************************************

ProcessDialog::ProcessDialog(): wxDialog()
{
}

ProcessDialog::~ProcessDialog()
{
	g_procDlg = NULL;
	g_fCancel = false;
}

//******************************************************************************
// Event table.
//******************************************************************************

BEGIN_EVENT_TABLE(ProcessDialog, wxDialog)
	EVT_INIT_DIALOG(                 ProcessDialog::OnInit)
	EVT_BUTTON(XRCID("btnCancel"),   ProcessDialog::OnBtnCancel)
END_EVENT_TABLE()

//******************************************************************************
// Event handler.
//******************************************************************************

void ProcessDialog::OnInit(wxInitDialogEvent& WXUNUSED(event))
{
	// XRCƌтB
	this->ebSource          = XRCCTRL(* this, "ebSource",     wxTextCtrl);
	this->ebTarget          = XRCCTRL(* this, "ebTarget",     wxTextCtrl);
	this->gauge             = XRCCTRL(* this, "gauge",        wxGauge);
	g_procDlg = this;

	::wxXmlResource::Get()->Unload(FE_DIR_S_XRC wxT("dlg_process.xrc"));
}

void ProcessDialog::OnBtnCancel(wxCommandEvent& WXUNUSED(event))
{
	g_fCancel = true;
	this->Close(true);
}
