/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: functions.h,v 1.4 2006/07/16 06:18:57 sirakaba Exp $
*******************************************************************************/

#include "frontend-wx.h"

#include "dlg_make.h"
#include "frm_main.h"

#include <wx/dirdlg.h>

//******************************************************************************
// MakeDialog
//******************************************************************************

MakeDialog::MakeDialog(): wxDialog()
{
}

//******************************************************************************
// Event Table.
//******************************************************************************

BEGIN_EVENT_TABLE(MakeDialog, wxDialog)
	EVT_INIT_DIALOG(                 MakeDialog::OnInit)
	EVT_BUTTON(XRCID("btnDefault"),  MakeDialog::OnBtnDefault)
	EVT_BUTTON(XRCID("btnDesktop"),  MakeDialog::OnBtnDesktop)
	EVT_BUTTON(XRCID("btnCurrent"),  MakeDialog::OnBtnCurrent)
	EVT_BUTTON(XRCID("btnBrowse"),   MakeDialog::OnBtnBrowse)
	EVT_BUTTON(XRCID("btnOK"),       MakeDialog::OnBtnOK)
	EVT_BUTTON(XRCID("btnCancel"),   MakeDialog::OnBtnCancel)
END_EVENT_TABLE()

//******************************************************************************
// Event handler.
//******************************************************************************

void MakeDialog::OnInit(wxInitDialogEvent&)
{
	// XRCƌтB
	this->cbDir             = XRCCTRL(* this, "cbDir",        wxComboBox);
	this->cbFileName        = XRCCTRL(* this, "cbFileName",   wxComboBox);
	this->cbOpenAfter       = XRCCTRL(* this, "cbOpenAfter",  wxCheckBox);
	this->cbIgnorePath      = XRCCTRL(* this, "cbIgnorePath", wxCheckBox);
	this->cbExitAfter       = XRCCTRL(* this, "cbExitAfter",  wxCheckBox);
	this->cbMakeSFX         = XRCCTRL(* this, "cbMakeSFX",    wxCheckBox);
	this->choice            = XRCCTRL(* this, "choice",       wxChoice);

	if (! this->cbDir->GetValue().IsEmpty())
	{
		return;
	}

	// CuB
	TPIHandle tpi;
	wxFileSystem fs;
	fs.ChangePathTo(wxT("lib/"), true);
	wxString szTPIName = fs.FindFirst(wxT("*" TPI_EXT), wxFILE);
	while (! szTPIName.IsEmpty())
	{
		// [hB
		if (tpi.InitLibrary(szTPIName, wxEmptyString, 0))
		{
			// Ή`擾B
			wxString type;
			for (int i = 0; tpi.GetPluginInformation(TPI_INFO_SUPPORTED_TYPE, i, & type) == TPI_ERROR_SUCCESS; i++)
			{
				if (! type.IsEmpty())
				{
					this->libname.Add(szTPIName);
					this->choice->Append(type);
					tpi.GetPluginInformation(TPI_INFO_SUPPORTED_SUFFIX, i, & type);
					this->defext.Add(type.BeforeFirst(';'));
				}
			}

			tpi.FreeLibrary();
		}
		szTPIName = fs.FindNext();
	}
	this->choice->SetSelection(0);

	::wxXmlResource::Get()->Unload(wxT("../share/frontend/xrc/dlg_make.xrc"));
}

void MakeDialog::OnBtnDefault(wxCommandEvent&)
{
}

void MakeDialog::OnBtnDesktop(wxCommandEvent&)
{
	wxStandardPaths p;
	this->cbDir->SetValue(p.GetDocumentsDir().BeforeLast('\\').Append(wxT("\\Desktop")));
}

void MakeDialog::OnBtnCurrent(wxCommandEvent&)
{
	this->cbDir->SetValue(((MainFrame *) this->GetParent())->statusbar->GetStatusText(5).BeforeLast('/'));
}

void MakeDialog::OnBtnBrowse(wxCommandEvent&)
{
	wxDirDialog dd(this, wxDirSelectorPromptStr, this->cbDir->GetValue());
	if (dd.ShowModal() == wxID_OK)
	{
		wxString s = dd.GetPath();
		s.Replace(wxT("\\"), wxT("/"));
		this->cbDir->SetValue(s);
	}
}

void MakeDialog::OnBtnOK(wxCommandEvent&)
{
	this->EndModal(wxID_OK);
}

void MakeDialog::OnBtnCancel(wxCommandEvent&)
{
	this->EndModal(wxID_CANCEL);
}
