/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: TPIHandle.h,v 1.3 2006/06/18 13:28:57 sirakaba Exp $
*******************************************************************************/

//******************************************************************************
//    定数定義
//******************************************************************************

#ifndef H_LOADED_TPI_HANDLE
#define H_LOADED_TPI_HANDLE

//******************************************************************************
//    Class (TPIHandle)
//******************************************************************************

class TPIHandle
{
	public:
		~TPIHandle(void);
		int GetPluginInformation(unsigned int, wxULongLong, void *);
		bool InitLibrary(const wxString &, const wxString &, wxULongLong);
		bool FreeLibrary(void);

		int CheckArchive(const wxString &, int *);
		int OpenArchive(const wxString &, void * *);
		int CloseArchive(void *);
		int GetFileInformation(void *, TPI_FILEINFO *, bool);
		int GetArchiveInformation(void *, TPI_ARCHIVEINFO *);

		int Command(unsigned int, TPI_SWITCHES *, const wxString &, const wxArrayString &);

		int SetCallbackProc(TPI_PROC);
	private:
		wxDynamicLibrary lib;
};

#endif
