// Paqar32.dll
// $Id: registry.cpp,v 1.2 2005/02/27 06:01:42 sirakaba Exp $

BOOL CreateRegistryKey(HKEY hTopKey, LPCSTR lpSubKey){
	HKEY hKey;
	DWORD dwDisposition;
	if(RegCreateKeyEx(hTopKey, lpSubKey, 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition) != ERROR_SUCCESS) return false;
	RegCloseKey(hKey);
	return true;
}

BOOL SetRegistryKeyValue(HKEY hTopKey, LPCSTR lpSubKey, LPCSTR lpValueName, DWORD dwType, BYTE *lpData){
	HKEY hKey;
	DWORD dwDisposition;
	if(RegOpenKeyEx(hTopKey, lpSubKey, 0, KEY_WRITE, &hKey) != ERROR_SUCCESS) return false;
	RegSetValueEx(hKey, lpValueName, 0, dwType, lpData, sizeof(lpData));
	RegCloseKey(hKey);
	return true;
}

BOOL GetRegistryKeyValue(HKEY hTopKey, LPCSTR lpSubKey, LPCSTR lpValueName, LPDWORD lpType, LPBYTE lpData){
	HKEY hKey;
	DWORD cbData;
	if(RegOpenKeyEx(hTopKey, lpSubKey, 0, KEY_READ, &hKey) != ERROR_SUCCESS) return false;
	RegQueryValueEx(hKey, lpValueName, NULL, lpType, NULL,   &cbData);
	RegQueryValueEx(hKey, lpValueName, NULL, lpType, lpData, &cbData);
	RegCloseKey(hKey);
	return true;
}
