/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  TOPPERS/JSP for Blackfin
 *
 *  Copyright (C) 2004 by Suikan
 *  Copyright (C) 2004 by Ujinosuke
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  
 */


/*
 *	vZbTˑW[ AZuꕔiBLACKfinpj
 *    by Suikan ( 2004 )
 */
 		// 32bit WX^ւ̑lZbgE}N
#define LOAD( reg, value32 ) reg##.h = hi(value32); reg##.l = lo(value32);

#define	_MACRO_ONLY
#include "jsp_kernel.h"
#include "offset.h"

/*
 *  ^XNfBXpb`
 *
 *  dispatch ́C݋֎~ԂŌĂяoȂ΂Ȃ
 *  Dexit_and_dispatch C݋֎~ԂŌĂяoB
 *  p0 : &runtsk
 *  p1 : &schedtsk
 *  p2 : runtsk
 *  p3 : schedtsk
 *  p4 : &reqflg
 */
.section program;
.global _dispatch;
.global _exit_and_dispatch;
.extern ldf_stack_end;
.extern _reqflg;
.extern _call_texrtn;
.extern _runtsk, _schedtsk;
	
_dispatch:
	[--sp] = (r7:4, p5:3);
	[--sp] = rets;
	[--sp] = fp;
	LOAD( p0,  _runtsk )
	LOAD( p1,  _schedtsk)
	p2 = [p0];					// p2  runtsk  
	[p2+TCB_sp] = sp;			// ^XNX^bNۑ
	LOAD( r1, dispatch_r )	// sĊJԒnۑ
	[p2+TCB_pc] = r1;
			// XPW[ꂽ^XNo
dispatcher:
	r0 = [p1];
	[p0] = r0;					// runtsk = schedtsk
	cc = r0;
	if !cc jump dispatcher_1;	// runtskΊ荞ݑ҂ɁB
	p3 = r0;					// p3schedtsk
	sp = [p3+TCB_sp];			// ^XNX^bNA
	p5 = [p3+TCB_pc];			// sĊJԒnA
	jump (p5);					// sĊJԒn֔
	
			// ready ^XNȂꍇ̊ݑ҂
dispatcher_1:
	LOAD( r0, ldf_stack_end)	// CxgX^bN|C^ݒ
	sp = r0;
	LOAD( p4, _reqflg )
wait_for_intr:
	csync;
	raise 14;					// 荞ݑ҂ԂɈڍs
	csync;
	/*
	 *  荞ݑ҂IVG14̊荞ݏԂōsBIVG14ɑJڂ̂
	 *  ǂ̃X^bNgƂ̉ƁC݃nh
	 *  ̃^XNfBXpb`̖h~Ƃ2̈ӖD
	 *
	 *  ݂҂Ԃ́Cruntsk  NULLi=0jɐݒ肵Ȃ΂Ȃ
	 *  ȂD̂悤ɐݒ肵ȂƁC݃nh iget_tid 
	 *  Ăяoۂ̓삪dlɍvȂȂD
	 *
	 *  荞ݑ҂ԂidleɂȂ邽߁Aۂɂ͊荞݂ł͂Ȃwakeup
	 *  CxgߑAɔ荞݂邱ƂɂȂB
	 *   SIC_IMASKSIC_IWR͓ɂĂȂ΂ȂȂB
	 *  ̓AvP[VvO}̐ӔCōsB
	 */
	r0 = [p4];					// reqflag擾
	cc = r0;
	if !cc jump wait_for_intr;	// reqflg0Ȃ犄荞ݑ҂
	r0 = 0;
	[p4] = r0;					// reqflgNA
	jump dispatcher;


			// ^XN̍ĊJԒnB^XNȌȂA
			// dispatch()߂
			// ̃AhXւ͕K dispatcherłB
			// āAp3͕Kschedtsk̓eɂȂĂB
dispatch_r:
	fp = [sp++];
	r2 = [p3+TCB_texptn];		// schedtsk->texptn
	cc = r2 == 0;				// texptrn0Ȃcc => 1
	r0 = [p3+TCB_enatex];
	LOAD( r1, TCB_enatex_mask )
	r0 = r0 & r1;				// enatex0ȂAaz => 1
	cc |= az;					// cc = ( !enatex || ! texptn ) = !( enatex && texptn )
	if cc jump dispatch_r_1(bp);	// if ( !enatex || !texptn ) ^[
	sp += -12;					// _~[̈m
	call _call_texrtn;
	sp += 12;					// _~[̈J
dispatch_r_1:
	rets = [sp++];
	(r7:4, p5:3) = [sp++];
	rts;
_dispatch.end:

/*	
 *	TOPPERS/JSPJn:
 *	 start.asm  kernel_startCPUbNԁA^XND揇ʂŌĂԁB
 *	 kernel_start͂̂܂exit_and_dispatchĂԁB
 *	 _exit_and_dispatch́A܂ł̃X^bNԂȂǂPɔpA
 *	 XPW[ꂽ^XNJnB
*/
_exit_and_dispatch:
		// dispatcherȍ~Ŏg|C^ݒ
	LOAD( p0,  _runtsk )
	LOAD( p1,  _schedtsk)
	jump dispatcher;
_exit_and_dispatch.end:

/*
 *  ^XNN
 *  _activate_rւ͂Ȃ炸dispatcherłB̂߁ACPUbN
 * ͂Ȃ΂ȂȂB
 */
	.section program;
	.global _activate_r;
_activate_r:
	r1 = 0xffff(z);
#ifdef UNMANAGED_INT
	cli r0;						// ݂̃}XNo
	r2 = UNMANAGED_INT(z);
	r0 = r0 & r2;				// ǗO荞݂̂ݎo
	r2 = ~r2;					// t}XN
	r1 = r1 & r2;				// 
	r1 = r1 | r0;				// ǗO荞݂l}XN
#endif
	sti r1;				// CPU AbN
	p0 = [sp++];		// ^XNGg[o
	r0 = [sp++];		// ext_tsk̔Ԓno
	rets = r0;			// ext_tsk_~[̖߂Ԓnɂ
	r0 = [sp++];		// ext_info : r0 ͈1
	sp += -12;
	jump (p0);			// ^XN̊Jn
_activate_r.end:
/*
 *  ԑ҂
 *  ̃[v12TCNŉB
 */
	.global _sil_dly_nse;
_sil_dly_nse:
	r1 = SIL_DLY_TIM1;
	r2 = SIL_DLY_TIM2;
	r0 = r0 - r1;			// dilay - SIL_DLY_TIM1
	cc = an;			// ʂ0傫
	if !cc jump _sil_dly_nse_1;	// [v
	rts;
_sil_dly_nse_1:
	r0 = r0 - r2;
	nop;
	cc = an;			// ʂ0傫
	if !cc jump _sil_dly_nse_1;	// [v
	rts;
_sil_dly_nse.end:

