/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004-2005 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: sample1.c,v 1.22 2005/11/12 15:01:44 hiro Exp $
 */

/* 
 *  TvvO(1)̖{
 *
 *  JSPJ[l̊{IȓmF邽߂̃TvvOD
 *
 *  vO̊Tv:
 *
 *  [UC^tF[X󂯎C^XNi^XNID: MAIN_TASKC
 *  Dx: MAIN_PRIORITYjƁCO̕s^XNi^XNID:
 *  TASK1`TASK3CDx: MID_PRIORITYjō\D܂CN
 *  2b̎nhinhID: CYCHDR1jpD
 *
 *  s^XŃCtask_loop 󃋁[vsxɁC^XN
 *  sł邱Ƃ킷bZ[W\D
 *
 *  nh́CO̗DxiHIGH_PRIORITYCMID_PRIORITYC
 *  LOW_PRIORITYj̃fBL[]DvŐŃC
 *  nh͒~ԂɂȂĂD
 *
 *  C^XŃCVAI/O|[g͂̕si͂
 *  ҂ĂԂ́Cs^XNsĂjC͂ꂽ
 *  ɑΉsD͂ꂽƏ̊֌W͎̒ʂD
 *  Control-C ܂ 'Q' ͂ƁCvOID
 *
 *  '1' : ȍ~̃R}h TASK1 ɑ΂čsD
 *  '2' : ȍ~̃R}h TASK2 ɑ΂čsD
 *  '3' : ȍ~̃R}h TASK3 ɑ΂čsD
 *  'a' : ^XN act_tsk ɂND
 *  'A' : ^XNɑ΂Nv can_act ɂLZD
 *  'e' : ^XN ext_tsk ĂяoCID
 *  't' : ^XN ter_tsk ɂ苭ID
 *  '>' : ^XN̗Dx HIGH_PRIORITY ɂD
 *  '=' : ^XN̗Dx MID_PRIORITY ɂD
 *  '<' : ^XN̗Dx LOW_PRIORITY ɂD
 *  'G' : ^XN̗Dx get_pri œǂݏoD
 *  's' : ^XN slp_tsk ĂяoCN҂ɂD
 *  'S' : ^XN tslp_tsk(10b) ĂяoCN҂ɂD
 *  'w' : ^XN wup_tsk ɂND
 *  'W' : ^XNɑ΂Nv can_wup ɂLZD
 *  'l' : ^XN rel_wai ɂ苭Iɑ҂ɂD
 *  'u' : ^XN sus_tsk ɂ苭҂ԂɂD
 *  'm' : ^XN̋҂Ԃ rsm_tsk ɂD
 *  'M' : ^XN̋҂Ԃ frsm_tsk ɂ苭D
 *  'd' : ^XN dly_tsk(10b) ĂяoCԌoߑ҂ɂD
 *  'x' : ^XNɃp^[ 0x0001 ̗OvD
 *  'X' : ^XNɃp^[ 0x0002 ̗OvD
 *  'y' : ^XN dis_tex ĂяoC^XNO֎~D
 *  'Y' : ^XN ena_tex ĂяoC^XNOD
 *  'r' : O̗DxiHIGH_PRIORITYCMID_PRIORITYCLOW_PRIORITYj
 *        fBL[]D
 *  'c' : nh𓮍삳D
 *  'C' : nh~D
 *  'z' : CPUO𔭐D
 *  'Z' : CPUbNԂCPUO𔭐ivOIjD
 *  'V' : vxget_tim Ő\]pVXe2ǂށD
 *  'v' : sVXeR[\iftHgjD
 *  'q' : sVXeR[\ȂD
 */

#include <t_services.h>
#include <s_services.h>
#include "kernel_id.h"
#include "sample1.h"

/*
 *  ss^XNւ̃bZ[Ẅ
 */
char	message[3];

/*
 *  [v
 */
UW	task_loop;		/* ^XNł̃[v */
UW	tex_loop;		/* O[`ł̃[v */

/*
 *  ss^XN
 */
void task(VP_INT exinf)
{
	volatile UW	i;
	INT		n = 0;
	INT		tskno = (INT) exinf;
	const char	*graph[] = { "|", "  +", "    *" };
	char		c;

	ena_tex();
	while (1) {
		syslog(LOG_NOTICE, "task%d is running (%03d).   %s",
					tskno, ++n, graph[tskno-1]);
		for (i = 0; i < task_loop; i++);
		c = message[tskno-1];
		message[tskno-1] = 0;
		switch (c) {
		case 'e':
			syslog(LOG_INFO, "#%d#ext_tsk()", tskno);
			ext_tsk();
		case 's':
			syslog(LOG_INFO, "#%d#slp_tsk()", tskno);
			syscall(slp_tsk());
			break;
		case 'S':
			syslog(LOG_INFO, "#%d#tslp_tsk(10000)", tskno);
			syscall(tslp_tsk(10000));
			break;
		case 'd':
			syslog(LOG_INFO, "#%d#dly_tsk(10000)", tskno);
			syscall(dly_tsk(10000));
			break;
		case 'y':
			syslog(LOG_INFO, "#%d#dis_tex()", tskno);
			syscall(dis_tex());
			break;
		case 'Y':
			syslog(LOG_INFO, "#%d#ena_tex()", tskno);
			syscall(ena_tex());
			break;
#ifdef CPUEXC1
		case 'z':
			syslog(LOG_NOTICE, "#%d#raise CPU exception", tskno);
			RAISE_CPU_EXCEPTION;
			break;
		case 'Z':
			loc_cpu();
			syslog(LOG_NOTICE, "#%d#raise CPU exception", tskno);
			RAISE_CPU_EXCEPTION;
			unl_cpu();
			break;
#endif /* CPUEXC1 */
		default:
			break;
		}
	}
}

/*
 *  sĎs^XNp̃^XNO[`
 */
void tex_routine(TEXPTN texptn, VP_INT exinf)
{
	volatile UW	i;
	INT	tskno = (INT) exinf;

	syslog(LOG_NOTICE, "task%d receives exception 0x%04x. ",
					tskno, texptn);
	for (i = 0; i < tex_loop; i++);

	if (texptn & 0x8000) {
		syslog(LOG_INFO, "#%d#ext_tsk()", tskno);
		ext_tsk();
	}
}

/*
 *  CPUOnh
 */
#ifdef CPUEXC1

void
cpuexc_handler(VP p_excinf)
{
	ID	tskid;

	syslog(LOG_NOTICE, "CPU exception handler (p_excinf = %08p).",
							p_excinf);
	if (sns_ctx() != TRUE) {
		syslog(LOG_WARNING,
			"sns_ctx() is not TRUE in CPU exception handler.");
	}
	if (sns_dpn() != TRUE) {
		syslog(LOG_WARNING,
			"sns_dpn() is not TRUE in CPU exception handler.");
	}
	syslog(LOG_DEBUG,
		"sns_loc = %d sns_dsp = %d", sns_loc(), sns_dsp());
	syslog(LOG_DEBUG,
		"vxsns_loc = %d vxsns_ctx = %d vxsns_dsp = %d vxsns_dpn = %d",
		vxsns_loc(p_excinf), vxsns_ctx(p_excinf),
		vxsns_dsp(p_excinf), vxsns_dpn(p_excinf));

	if (!vxsns_loc(p_excinf) && !vxsns_ctx(p_excinf)) {
		syscall(iget_tid(&tskid));
		syscall(iras_tex(tskid, 0x8000));
	}
	else {
		syslog(LOG_NOTICE, "Sample program ends with exception.");
		kernel_exit();
	}
}

#endif /* CPUEXC1 */

/*
 *  nh
 *
 *  HIGH_PRIORITYCMID_PRIORITYCLOW_PRIORITY ̊eDx̃fBL[
 *  ]D
 */
void cyclic_handler(VP_INT exinf)
{
	irot_rdq(HIGH_PRIORITY);
	irot_rdq(MID_PRIORITY);
	irot_rdq(LOW_PRIORITY);
}

/*
 *  C^XN
 */
void main_task(VP_INT exinf)
{
	char	c;
	ID	tskid = TASK1;
	volatile UW	i;
	INT	tskno = 1;
	ER_UINT	ercd;	
	PRI	tskpri;
	SYSTIM	stime1, stime2;
#ifndef OMIT_VGET_TIM
	SYSUTIM	utime1, utime2;
#endif /* OMIT_VGET_TIM */

	ena_int( INTNO_UART_TX );
	ena_int( INTNO_UART_RX );
	vmsk_log(LOG_UPTO(LOG_INFO), LOG_UPTO(LOG_EMERG));
	syslog(LOG_NOTICE, "Sample program starts (exinf = %d).", (INT) exinf);

	syscall(serial_ctl_por(TASK_PORTID,
			(IOCTL_CRLF | IOCTL_FCSND | IOCTL_FCRCV)));

	/*
 	 *  [v񐔂̐ݒ
	 */
	task_loop = LOOP_REF;
	get_tim(&stime1);
	for (i = 0; i < task_loop; i++);
	get_tim(&stime2);
	task_loop = LOOP_REF * 400 / (stime2 - stime1);
	tex_loop = task_loop / 5;

	/*
 	 *  ^XN̋N
	 */
	act_tsk(TASK1);
	act_tsk(TASK2);
	act_tsk(TASK3);

	/*
 	 *  C[v
	 */
	do {
		syscall(serial_rea_dat(TASK_PORTID, &c, 1));
		switch (c) {
		case 'e':
		case 's':
		case 'S':
		case 'd':
		case 'y':
		case 'Y':
		case 'z':
		case 'Z':
			message[tskno-1] = c;
			break;
		case '1':
			tskno = 1;
			tskid = TASK1;
			break;
		case '2':
			tskno = 2;
			tskid = TASK2;
			break;
		case '3':
			tskno = 3;
			tskid = TASK3;
			break;
		case 'a':
			syslog(LOG_INFO, "#act_tsk(%d)", tskno);
			syscall(act_tsk(tskid));
			break;
		case 'A':
			syslog(LOG_INFO, "#can_act(%d)", tskno);
			syscall(ercd = can_act(tskid));
			if (MERCD(ercd) >= 0) {
				syslog(LOG_NOTICE, "can_act(%d) returns %d",
						tskno, ercd);
			}
			break;
		case 't':
			syslog(LOG_INFO, "#ter_tsk(%d)", tskno);
			syscall(ter_tsk(tskid));
			break;
		case '>':
			syslog(LOG_INFO, "#chg_pri(%d, HIGH_PRIORITY)", tskno);
			chg_pri(tskid, HIGH_PRIORITY);
			break;
		case '=':
			syslog(LOG_INFO, "#chg_pri(%d, MID_PRIORITY)", tskno);
			chg_pri(tskid, MID_PRIORITY);
			break;
		case '<':
			syslog(LOG_INFO, "#chg_pri(%d, LOW_PRIORITY)", tskno);
			chg_pri(tskid, LOW_PRIORITY);
			break;
		case 'G':
			syslog(LOG_INFO, "#get_pri(%d, &tskpri)", tskno);
			syscall(ercd = get_pri(tskid, &tskpri));
			if (MERCD(ercd) >= 0) {
				syslog(LOG_NOTICE, "priority of task %d is %d",
						tskno, tskpri);
			}
			break;
		case 'w':
			syslog(LOG_INFO, "#wup_tsk(%d)", tskno);
			syscall(wup_tsk(tskid));
			break;
		case 'W':
			syslog(LOG_INFO, "#can_wup(%d)", tskno);
			syscall(ercd = can_wup(tskid));
			if (MERCD(ercd) >= 0) {
				syslog(LOG_NOTICE, "can_wup(%d) returns %d",
						tskno, ercd);
			}
			break;
		case 'l':
			syslog(LOG_INFO, "#rel_wai(%d)", tskno);
			syscall(rel_wai(tskid));
			break;
		case 'u':
			syslog(LOG_INFO, "#sus_tsk(%d)", tskno);
			syscall(sus_tsk(tskid));
			break;
		case 'm':
			syslog(LOG_INFO, "#rsm_tsk(%d)", tskno);
			syscall(rsm_tsk(tskid));
			break;
		case 'M':
			syslog(LOG_INFO, "#frsm_tsk(%d)", tskno);
			syscall(frsm_tsk(tskid));
			break;
		case 'x':
			syslog(LOG_INFO, "#ras_tex(%d, 0x0001)", tskno);
			syscall(ras_tex(tskid, 0x0001));
			break;
		case 'X':
			syslog(LOG_INFO, "#ras_tex(%d, 0x0002)", tskno);
			syscall(ras_tex(tskid, 0x0002));
			break;
		case 'r':
			syslog(LOG_INFO, "#rot_rdq(three priorities)");
			rot_rdq(HIGH_PRIORITY);
			rot_rdq(MID_PRIORITY);
			rot_rdq(LOW_PRIORITY);
			break;
		case 'c':
			sta_cyc(CYCHDR1);
			break;
		case 'C':
			stp_cyc(CYCHDR1);
			break;
#ifndef OMIT_VGET_TIM
		case 'V':
			syscall(vxget_tim(&utime1));
			syscall(vxget_tim(&utime2));
			syslog(LOG_NOTICE, "utime1 = %d, utime2 = %d",
						(UINT) utime1, (UINT) utime2);
			break;
#endif /* OMIT_VGET_TIM */
		case 'v':
			vmsk_log(LOG_UPTO(LOG_INFO), LOG_UPTO(LOG_EMERG));
			break;
		case 'q':
			vmsk_log(LOG_UPTO(LOG_NOTICE), LOG_UPTO(LOG_EMERG));
			break;
		default:
			break;
		}
	} while (c != '\003' && c != 'Q');

	syslog(LOG_NOTICE, "Sample program ends.");
	kernel_exit();
}
