/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  TOPPERS/JSP for Blackfin
 *
 *  Copyright (C) 2004 by Suikan
 *  Copyright (C) 2004 by Ujinosuke
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  
 */


/*
 *	vZbTˑW[ AZuꕔiBLACKfinpj
 *    by Suikan ( 2004 )
 */

#define	_MACRO_ONLY
#include "jsp_kernel.h"
#include "offset.h"

/*
 *  ^XNfBXpb`
 *
 *  dispatch ́C݋֎~ԂŌĂяoȂ΂Ȃ
 *  Dexit_and_dispatch C݋֎~ԂŌĂяoB
 */
.section program;
.global _dispatch;
.global _exit_and_dispatch;
.extern _reqflg;
.extern _call_texrtn;
.extern _runtsk, _schedtsk;
	
_dispatch:
	[--sp] = (r7:4, p5:3);
	[--sp] = rets;
	[--sp] = fp;
	p0.H = _runtsk;
	p0.L = _runtsk;
	p0 = [p0];					// p0  runtsk  
	[p0+TCB_sp] = sp;			// ^XNX^bNۑ
	p1.H = dispatch_r;			// sĊJԒnۑ
	p1.L = dispatch_r;
	[p0+TCB_pc] = p1;
	jump dispatcher;

dispatch_r:
	fp = [sp++];
	p1.H = _runtsk;
	p1.L = _runtsk;
	p0 = [p1];
	r0 = [p0+TCB_texptn];		// runtsk->texptn
	cc = r0;
	cc = !cc;					// texptn0Ȃ1
	r0 = [p0+TCB_enatex];
	r1.L = TCB_enatex_mask&0xffff;
	r1.H = TCB_enatex_mask>>16;
	r0 = r0 & r1;
	cc |= az;					// texptrn0Aenatex0Ȃ
	if cc jump dispatch_r_1;	// ̂Ƃ͑^[
	sp += -12;					// _~[̈m
	call _call_texrtn;
	sp += 12;					// _~[̈J
dispatch_r_1:
	rets = [sp++];
	(r7:4, p5:3) = [sp++];
	rts;
_dispatch.end:

	
_exit_and_dispatch:
		// start.asm  kernel_startCPUbNԁA^XND揇ʂŌĂԁB
		// kernel_start͂̂܂exit_and_dispatchĂԂ̂łł͉ȂĂB
	jump dispatcher;
_exit_and_dispatch.end:


dispatcher:
	/*
	 *  ł͊݋֎~ԂłȂ΂ȂȂD
	 */
	p0.H = _schedtsk;
	p0.L = _schedtsk;
	p1.H = _runtsk;
	p1.L = _runtsk;
	r0 = [p0];
	[p1] = r0;					// schedtsk  runtsk
	cc = r0;
	if !cc jump dispatcher_1;	// runtskΊ荞ݑ҂ɁB
	p0 = r0;					// p0runtsk
	sp = [p0+TCB_sp];			// ^XNX^bNA
	p1 = [p0+TCB_pc];			// sĊJԒnA
	jump (p1);					// sĊJԒn֔
dispatcher_1:
	csync;
	raise 14;					// 荞ݑ҂ԂɈڍs
	csync;
	/*
	 *  荞ݑ҂IVG14̊荞ݏԂōsBIVG14ɑJڂ̂
	 *  ǂ̃X^bNgƂ̉ƁC݃nh
	 *  ̃^XNfBXpb`̖h~Ƃ2̈ӖD
	 *
	 *  ݂҂Ԃ́Cruntsk  NULLi=0jɐݒ肵Ȃ΂Ȃ
	 *  ȂD̂悤ɐݒ肵ȂƁC݃nh iget_tid 
	 *  Ăяoۂ̓삪dlɍvȂȂD
	 *
	 *  荞ݑ҂ԂidleɂȂ邽߁Aۂɂ͊荞݂ł͂Ȃwakeup
	 *  CxgߑAɔ荞݂邱ƂɂȂB
	 *   SIC_IMASKSIC_IWR͓ɂĂȂ΂ȂȂB
	 *  ̓AvP[VvO}̐ӔCōsB
	 */
	p1.L = _reqflg;
	p1.H = _reqflg;
	r0 = [p1];					// reqflag擾
	cc = r0;
	if !cc jump dispatcher_1;	// reqflg0Ȃ犄荞ݑ҂
	r0 = 0;
	[p1] = r0;					// reqflgNA
	jump dispatcher;
dispatcher.end:

/*
 *  ^XNN
 */
	.section program;
	.global _activate_r;
_activate_r:
	r1 = 0xffff(z);
#ifdef UNMANAGED_INT
	cli r0;						// ݂̃}XNo
	r2 = UNMANAGED_INT(z);
	r0 = r0 & r2;				// ǗO荞݂̂ݎo
	r2 = ~r2;					// t}XN
	r1 = r1 & r2;				// 
	r1 = r1 | r0;				// ǗO荞݂l}XN
#endif
	sti r1;				// CPU AbN
	p0 = [sp++];		// ^XNGg[o
	r0 = [sp++];		// ext_tsk̔Ԓno
	rets = r0;			// ext_tsk_~[̖߂Ԓnɂ
	jump (p0);			// ^XN̊Jn
_activate_r.end:
/*
 *  ԑ҂
 *  ̃[v12TCNŉB
 */
	.global _sil_dly_nse;
_sil_dly_nse:
	r1 = SIL_DLY_TIM1;
	r2 = SIL_DLY_TIM2;
	r0 = r0 - r1;			// dilay - SIL_DLY_TIM1
	cc = an;			// ʂ0傫
	if !cc jump _sil_dly_nse_1;	// [v
	rts;
_sil_dly_nse_1:
	r0 = r0 - r2;
	nop;
	cc = an;			// ʂ0傫
	if !cc jump _sil_dly_nse_1;	// [v
	rts;
_sil_dly_nse.end:

