/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  
 */

/*
 * BLACKfin port. By Suikan, 2004
 */
 
/*
 *	vZbTˑW[iBLACKfinpj
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"
#include <sys/exception.H>
#include <cdefBF53x.h>

void (* exc_vector[32])(void);
void (* dev_vector[27])(void) ;
unsigned int priority_mask[16];

void dummy_interrupt_handler(void)	{}


/*
 *  vZbTˑ̏
 */
void
cpu_initialize()
{
	int i;
	
	for ( i=0; i<27; i++ )
		dev_vector[i] = &dummy_interrupt_handler;
	for ( i=0; i<32; i++ )
		exc_vector[i] = &dummy_interrupt_handler;
}

/*
 *  vZbTˑ̏I
 */
void
cpu_terminate()
{

}


/*
 *  荞݂foCXɊ蓖Ă
 */
void device_dispatcher( unsigned int priority )
{
	unsigned int candidates, count, device;
	
	candidates = priority_mask[priority] & *pSIC_ISR & *pSIC_IMASK;	// ݂̃vCIeBɑ銄݌肷
	asm ( "%0 = ones %1;" :"=l"(count) :"d"(candidates)  );
	
	if ( ! count )
	{
		if ( priority == ik_hardware_err)
			dev_vector[INHNO_HW_ERROR]();
		else if ( priority == ik_timer)
			dev_vector[INHNO_TIMER]();
		else
			dev_vector[INHNO_RAISE]();		//@\tgEFA荞

	}
	else 
	{
		asm( "%0 = signbits %1;\n" : "=l"( device ) : "d"( candidates ) : "r2" );
		device = 30 - device;		// bit mask is converted to bit number
		dev_vector[device]();
	}
}


