/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *	^C}hCoiADSP-BF533pj
 *  B
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>


#ifndef _MACRO_ONLY
#include <cdefBF53x.h>
#include <ccblkfn.h>




/**************************************************************
 *  ^C}̋N
 *
 *  ^C}CIȃ^C}ݗv𔭐D
 *  
 **************************************************************/
Inline void
hw_timer_initialize()
{
#ifndef USE_TIC_CORE
	UW	reg;
#endif	
	
#ifdef USE_TIC_CORE
	// Core timer
	*pTCNTL = TMPWR;					// power up timer;
	asm("csync;");
	*pTPERIOD = CORECLOCK/1000;			// CORE CLOCK is defined in sys_config.h
	asm("csync;");
	*pTCNTL = TMPWR | TMREN | TAUTORLD;
	asm("csync;");
#else
	// GPT2(General-purpose timer2)
	
	reg = *pSIC_IMASK;
	reg |= SIC_MASK(18);				// No.18 is for GPT2
	*pSIC_IMASK = reg;					// Interrupt enable

	*pTIMER2_CONFIG = PERIOD_CNT | OUT_DIS |IRQ_ENA | PWM_OUT;	// PWM_OUT, Output Pad disable
	asm("csync;");
	*pTIMER2_PERIOD = SYSCLOCK/1000;	// SYS CLOCK is defined in sys_config.h
	*pTIMER2_WIDTH = 1;					// 0 < width < period
	asm("csync;");
	*pTIMER_ENABLE = TIMEN2;			// timer2 start
	asm("csync;");
	
#endif

}

/**************************************************************
 *  ^C}ݗṽNA
 **************************************************************/
Inline void
hw_timer_int_clear()
{
#ifdef USE_TIC_CORE
	// Core timer
	*pTCNTL = TMPWR | TMREN | TAUTORLD | TINT;
	asm("csync;");
#else
	// GPT2(General-purpose timer2)
	*pTIMER_STATUS = TIMIL2;
	asm("csync;");
#endif
}

/**************************************************************
 *  ^C}̒~
 *
 *  ^C}̓~D
 **************************************************************/
Inline void
hw_timer_terminate()
{
	/*
	 *  ^C}̓~D
	 */
#ifdef USE_TIC_CORE
	// Core timer
	*pTCNTL = TMPWR | TAUTORLD | TINT;		// ~
	asm("csync;");
	*pTCNTL = 0;							// p[_E[h
	asm("csync;");
#else
	// GPT2(General-purpose timer2)
	*pTIMER_DISABLE = TIMEN2;			// timer2 disable
	asm("csync;");
#endif
}


#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */
