/*
 *	main_task.c
 */

#include "jsp_kernel.h"
#include "kernel_id.h"
#include <cdefBF533.h>

#define pFLASHA_PORTB_OUT ((volatile unsigned char * )0x20270005)
#define pFLASHA_PORTB_DIR ((volatile unsigned char * )0x20270007)

extern volatile SYSUTIM sysutim;

void Init_port(void)
{
	*pFIO_DIR = 1 | 2;	// set output for PF0 and PF1
	*pFIO_FLAG_D = 0x0002;
    *pEBIU_AMBCTL0 = 0x7bb07bb0;  // 񓯊|[g0,1̏
    *pEBIU_AMBCTL1 = 0x7bb07bb0;  // 񓯊|[g2,3̏
    *pEBIU_AMGCTL  = 0x000f;      // S񓯊|[gCl[u

    *pFLASHA_PORTB_DIR = 0x3f;    // bit0-5o͂
    *pFLASHA_PORTB_OUT = 0x00;    // LED It	
}


void main_task(void)
{
	int j = 0;
	SYSUTIM tim;
	
	Init_port();
	*pFLASHA_PORTB_OUT ^= 0x2;    // 000010o		
	
	while(1)
	{
		int i;

		*pFLASHA_PORTB_OUT ^= 0x31;    // 110001o		
		wai_sem( TEST_SEM );
		vxget_tim(&tim);
		sysutim = tim - sysutim;
	}
}

