/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */
 
/*
 * BLACKfin port. By Suikan, 2004
 */

/*
 *	vZbTˑ̃J[liBLACKfinpj
 *
 *  ̃CN[ht@ĆCt_config.h ݂̂CN[hD
 *  ̃t@C璼ڃCN[hĂ͂ȂȂD
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

#include <api.h>
/*
 *  BLACKfin֘At@C̓ǂݍ
 */
#include <cdef_LPBLACKFIN.h>
/*
 *  J[l̓ʖ̃l[
 */
#include <cpu_rename.h>

/*
*	BLACKfiñrbg}bv@\g
*   BLACKfinMSB琔B
*/
#define	CPU_BITMAP_SEARCH
#define	PRIMAP_BIT(pri)		(0x40000000u >> (pri))


/*
 *  TCB ̃tB[h̃rbg̒`
 *
 *  cpu_context.h ɓGKgCQƂ̈ˑ̊֌WŁC
 *  cpu_context.h ɂ͓ȂD
 */
#define	TBIT_TCB_TSTAT		8	/* tstat tB[h̃rbg */
#define	TBIT_TCB_PRIORITY	8	/* priority tB[h̃rbg */


/*
*	BLACKfinIMASKւ̐ݒp^[
*
*/
#define IMASK_LOCK   0xc01f
#define IMASK_UNLOCK 0xffff

#ifndef _MACRO_ONLY
/*
 *  vZbT̓ꖽ߂̃CC֐`
 */
/*
 *  fBL[T[`̂߂̃rbg}bvT[`֐
 *
 *  rbg}bv̉16rbggpCŉʃrbgŒDxɑΉ
 *  D
 */


#if 0
Inline UINT
bitmap_search(UINT bitmap)
{
	UINT	numOfSign;

	/*
	 *  ̃R[h́CbitmapiUINT^j32rbgł邱Ƃ肵
	 *  ĂDSignbits ߂32rbgMSBA
	 *  rbg - 1 ԂBall 0̂Ƃ31ԂBLSB݂̂1
	 *  Ƃ30ԂB
	 */
	asm( "%0=signbits %1;": "=l"(numOfSign) : "d"(bitmap) );
	return( numOfSign );
}
#else
#include <fract.h>
#define bitmap_search(bitmap)	norm_fr1x32(bitmap)
#endif


/*
 *  ^XNReLXgubN̒`
 */
typedef struct task_context_block {
	VP	sp;		/* X^bN|C^ */
	FP	pc;		/* vOJE^ */
} CTXB;


/*
 *  VXeԎQ
 *	Ԃl͈ȉ̂Ƃ
 *	TRUE : ^XNReLXg
 *	FALSE: ^XNReLXg
 *				IPEND$8000$8010̎A^XNReLXgłBȊÔƂ͔^XNReLXgB
 */

Inline BOOL
sense_context()
{
	return( *pIPEND & 0x7FEF );
}

Inline BOOL
sense_lock()
{
	return(*pIMASK == 0xC01F );
}

#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock


/*
 *  CPUbNƂ̉i^XNReLXgpj
 *
 *  task_intmask ́Cchg_ipm T|[g邽߂̕ϐDchg_ipm T|[
 *  gȂꍇɂ́Ctask_intmask  0 ɂȂĂƍl΂悢D
 *
 */

#ifdef SUPPORT_CHG_IPM
extern UH	task_intmask;	/* ^XNReLXgł̊݃}XN */
#endif /* SUPPORT_CHG_IPM */

// BLACKfinłIMASK0xC01FCPUbNB
Inline void
t_lock_cpu()
{
	asm( "r0=0xc01f(z); sti r0;" : : : "r0" );
	asm("csync;");
}

Inline void
t_unlock_cpu()
{
	asm("csync;");
	asm( "r0=0xffff(z); sti r0;" : : : "r0" );
}

/*
 *  CPUbNƂ̉i^XNReLXgpj
 */


Inline void
i_lock_cpu()
{
	asm( "r0=0xc01f(z); sti r0;" : : : "r0" );
	asm("csync;");
}

Inline void
i_unlock_cpu()
{
	asm("csync;");
	asm( "r0=0xffff(z); sti r0;" : : : "r0" );
}

/*
 *  ^XNfBXpb` 
 */

/*
 *  ōD揇ʃ^XNւ̃fBXpb`icpu_support.Sj
 *
 *  dispatch ́C^XNReLXgĂяoꂽT[rXR[
 *  ŁCCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void	dispatch(void);

/*
 *  ݂̃ReLXĝĂăfBXpb`icpu_support.Sj
 *
 *  exit_and_dispatch ́CCPUbNԂŌĂяoȂ΂ȂȂD
 */
extern void	exit_and_dispatch(void);

/*
 *  ݃nh^CPUOnh̐ݒ
 */


/*
 *  ݃nh̐ݒ
 *
 *  xNgԍ inhno ̊݃nh̋NԒn inthdr ɐݒ肷D
 * evtvector start.asmŒ`ĂB
 */
extern void *evtvector[];
Inline void
define_inh(INHNO inhno, FP inthdr)
{
	evtvector[inhno] = inthdr;
}

/*
 *  CPUOnh̐ݒ
 *
 *  xNgԍ excno CPUOnh̋NԒn exchdr ɐݒ肷D
 */
Inline void
define_exc(EXCNO excno, FP exchdr)
{
	define_inh(3, exchdr);		// O͏ɃCxgԍ3
}

/*
 *  ݃nh^CPUOnh̏o
 */

/*
 *  ݃nh̏o̐}N
 *
 *  reqflg `FbNOɊ݂֎~ȂƁCreqflg `FbN
 *  ɋNꂽ݃nhŃfBXpb`vꂽꍇɁCfB
 *  Xpb`ȂD
 */

#define	INTHDR_ENTRY(inthdr)	extern void inthdr(void);	
#define	INT_ENTRY(inthdr)	inthdr

/*
 *  CPUOnh̏o̐}N
 *
 *  reqflg `FbNOɊ݂֎~ȂƁCreqflg `FbN
 *  ɋNꂽ݃nhŃfBXpb`vꂽꍇɁCfB
 *  Xpb`ȂD
 */

#define	EXCHDR_ENTRY(exchdr)	extern void exchdr( void );
#define	EXC_ENTRY(exchdr)	exchdr

/*
 *  CPUO̔̃VXeԂ̎Q
 */

/*
 *  CPUO̔̃ReLXg̎Q
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
	return( *pIPEND & 0x7FE6 );				// IVG15, GIE, EXP, EMU ȊÕrbgĂΔ^XNReLXg
}



/*
 *  CPUO̔CPUbNԂ̎Q
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
	return(*pIMASK == 0xC01F );				// 0xC01FȂ烍bNA0xFFFFȂAbN
}

/*
 *  vZbTˑ̏
 */
extern void	cpu_initialize(void);

/*
 *  vZbTˑ̏I
 */
extern void	cpu_terminate(void);

#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */
