/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *	^[QbgVXeˑW[iEZKIT-BF533pj
 *
 *  ̃CN[ht@ĆCt_config.h ݂̂CN[hD
 *  ̃t@C璼ڃCN[hĂ͂ȂȂD
 *
 * EZ-KIT̃̕o[WɑΉ邽߂EZKIT600MHzEZKIT750MHz
 * ꂩ`ďRpCł悤ɂĂB͈ȉ
 * Ƃ
 * EZKIT600MHz	CCLK:594MHz		SCLK:119MHz
 * EZKIT750MHz	CCLK:756MHz		SCLK:126MHz
 */
 
#define CSELVAL 1
#define SSELVAL 5
#define MSELVAL 22
#define CLKIN 27000000
 

#ifndef _SYS_CONFIG_H_
#define _SYS_CONFIG_H_

/*
 *  J[l̓ʖ̃l[
 */
#include <sys_rename.h>

/*
 *  ^[QbgVXẽn[hEFA̒`
 */

/*
 *  NbZ[W̃^[QbgVXe
 */
#define	TARGET_NAME	"EZKIT BF533"


/*
 *  TICp^C}[̎
 */
#define PLLCLOCK (CLKIN*MSELVAL)
#define SYSCLOCK  (PLLCLOCK / SSELVAL)
#define CORECLOCK (PLLCLOCK / CSELVAL)

/*
 * TICp^C}[̐ݒ
 * TIC_COREdefineƁACORE^C}[gp܂B
 * TIC_GPT2defineƁAGPT2gp܂B
 * gpȂقRgAEgĂ
 *
 * TVEC_TT0GPT2gpƂɗLłB
 * TIC Timer̊荞݃xݒ肵܂B
 * ݒ\Ȋ荞݃x͂V`PRłB
 * CORE^C}[IIVTMRxŒłB
 */

//#define TIC_CORE
#define TIC_GPT2

#define TVEC_TT0 13

/*
 *  VA|[g̒`
 *  pidc/simple_sio/uart.cŎgB
 */
#define TNUM_PORT	1	/* T|[gVA|[g̐ */
#define TNUM_SIOP	1	/* T|[gVA|[g̐ */

/*
 *  VA|[gԍɊւ`
 */
#define	LOGTASK_PORTID	0	/* VXeOɗpVA|[gԍ */

/*
 *  SIO̊݃nh̃xN^ԍ
 */
#define INHNO_SIO	ik_IVG10



/*
 *  VA|[g̃{[[gɊւ`
 *
 *  UART̃{[[gWFl[^ɐݒ肷ׂlD
 *  pidc/simple_sio/uart.cŎgB
 */

#define DLH_VAL	SYSCLOCK/16/115200/256		/* 115200bpsiʁj*/
#define DLL_VAL	SYSCLOCK/16/115200%256		/* 115200bpsiʁj*/

/*
 *  VA|[g̃AhX
 *  pidc/simple_sio/uart.cŎgB
 *
 */
#define UART_0 0xFFC00400	// UART THR̃AhXB

/*
 *  ԑ҂̂߂̒`
 *  sil_dly_nsěĂяoI[o[wbhƃ[v{fB[TCN
 *  nSŕ\B֐cpu_support.asmɒ`ĂB
 *  SIL_DLY_TIM124TCNB32nS( 750MHz ), 40nS( 600MHz )
 *  SIL_DLY_TIM212TCNB16nS( 750MHz ), 20nS( 600MHz )
 */


#define	SIL_DLY_TIM1	(24*1000000000/CORECLOCK)
#define	SIL_DLY_TIM2	(12*1000000000/CORECLOCK)


#ifndef _MACRO_ONLY


/*
 *  ^[QbgVXeˑ̏
 */
extern void	sys_initialize(void);

/*
 *  ^[QbgVXȅI
 *
 *  VXeI鎞ɎgDROMj^^GDB STUBďoŎD
 */
extern void	sys_exit(void);

/*
 *  ^[QbgVXe̕o
 *
 *  VXe̒჌x̕o̓[`DROMj^^GDB STUBďoŎ
 *  D
 */
extern void	sys_putc(char c);

#endif /* _MACRO_ONLY */
#endif /* _SYS_CONFIG_H_ */
