/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *	^[QbgVXeˑW[iADSP-BF533pj
 */

#include "jsp_kernel.h"
#include <sil.h>
#include <cdefBF53x.h>

/*
 *  ^[QbgVXeˑ̏
 */
void
sys_initialize()
{
	/*
	 *  PLL̐ݒ
	 *
	 */
	/*
	 *  27MHz*22{=594MHzɐݒ肷(600MHz)
	 *  27MHz*28{=756MHzɐݒ肷(750MHz)
	 *  CSEL = 1; SSEL = 5 (600MHz)
	 *  CSEL = 1; SSEL = 6 (750MHz)
	 */
	*pSIC_IWR = IWR_ENABLE(0);				// PLL̂IWR
#if CSELVAL == 1 
	*pPLL_DIV = CCLK_DIV1 | SCLK_DIV(SSELVAL);
#elif CSELVAL == 2
	*pPLL_DIV = CCLK_DIV2 | SCLK_DIV(SSELVAL);
#elif CSELVAL == 4
	*pPLL_DIV = CCLK_DIV4 | SCLK_DIV(SSELVAL);
#elif CSELVAL == 8
	*pPLL_DIV = CCLK_DIV8 | SCLK_DIV(SSELVAL);
#else
#error Wrong CSELVAL. Must be one of 1,2,4,8.
#endif
	
	*pPLL_CTL = MSELVAL << 9;
		
	asm("cli r0; csync; idle; sti r0;": : :"r0");
	*pSIC_IWR = IWR_ENABLE_ALL;
}

/*
 *  ^[QbgVXȅI
 */
void
sys_exit()
{
}

/*
 *  ^[QbgVXe̕o
 */
void
sys_putc(char c)
{
}
