/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2006 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cyclic.c,v 1.11 2006/02/12 05:29:32 hiro Exp $
 */

/*
 *	ϥɥ鵡ǽ
 */

#include "jsp_kernel.h"
#include "check.h"
#include "cyclic.h"

/*
 *  ϥɥIDκ͡kernel_cfg.c
 */
extern const ID	tmax_cycid;

/*
 *  ϥɥ֥åΥꥢkernel_cfg.c
 */
extern const CYCINIB	cycinib_table[];

/*
 *  ϥɥ֥åΥꥢkernel_cfg.c
 */
extern CYCCB	cyccb_table[];

/*
 *  ϥɥο
 */
#define TNUM_CYC	((UINT)(tmax_cycid - TMIN_CYCID + 1))

/*
 *  ϥɥIDϥɥ֥åФΥޥ
 */
#define INDEX_CYC(cycid)	((UINT)((cycid) - TMIN_CYCID))
#define get_cyccb(cycid)	(&(cyccb_table[INDEX_CYC(cycid)]))

/*
 *  ޤϥɥη
 */
typedef void	(*CYCHDR)(VP_INT exinf);

/*
 *  ϥɥ鵡ǽν
 */
#ifdef __cycini

void
cyclic_initialize()
{
	UINT	i;
	CYCCB	*cyccb;

	for (cyccb = cyccb_table, i = 0; i < TNUM_CYC; cyccb++, i++) {
		cyccb->cycinib = &(cycinib_table[i]);
		if ((cyccb->cycinib->cycatr & TA_STA) != 0) {
			cyccb->cycsta = TRUE;
			tmevtb_enqueue_cyc(cyccb,
					(EVTTIM)(cyccb->cycinib->cycphs));
		}
		else {
			cyccb->cycsta = FALSE;
		}
	}
}

#endif /* __cycini */

/*
 *  ϥɥ鵯ưΤΥ।٥ȥ֥åϿ
 */
#ifdef __cycenq

void
tmevtb_enqueue_cyc(CYCCB *cyccb, EVTTIM evttim)
{
	tmevtb_enqueue_evttim(&(cyccb->tmevtb), evttim,
				(CBACK) call_cychdr, (VP) cyccb);
	cyccb->evttim = evttim;
}

#endif /* __cycenq */

/*
 *  ϥɥư
 */
#ifdef __sta_cyc

SYSCALL ER
sta_cyc(ID cycid)
{
	CYCCB	*cyccb;
	ER	ercd;

	LOG_STA_CYC_ENTER(cycid);
	CHECK_TSKCTX_UNL();
	CHECK_CYCID(cycid);
	cyccb = get_cyccb(cycid);

	t_lock_cpu();
	if (cyccb->cycsta) {
		tmevtb_dequeue(&(cyccb->tmevtb));
	}
	else {
		cyccb->cycsta = TRUE;
	}
	tmevtb_enqueue_cyc(cyccb, base_time + cyccb->cycinib->cyctim);
	ercd = E_OK;
	t_unlock_cpu();

    exit:
	LOG_STA_CYC_LEAVE(ercd);
	return(ercd);
}

#endif /* __sta_cyc */

/*
 *  ϥɥư
 */
#ifdef __stp_cyc

SYSCALL ER
stp_cyc(ID cycid)
{
	CYCCB	*cyccb;
	ER	ercd;

	LOG_STP_CYC_ENTER(cycid);
	CHECK_TSKCTX_UNL();
	CHECK_CYCID(cycid);
	cyccb = get_cyccb(cycid);

	t_lock_cpu();
	if (cyccb->cycsta) {
		cyccb->cycsta = FALSE;
		tmevtb_dequeue(&(cyccb->tmevtb));
	}
	ercd = E_OK;
	t_unlock_cpu();

    exit:
	LOG_STP_CYC_LEAVE(ercd);
	return(ercd);
}

#endif /* __stp_cyc */

/*
 *  ϥɥ鵯ư롼
 */
#ifdef __cyccal

void
call_cychdr(CYCCB *cyccb)
{
	/*
	 *  εưΤΥ।٥ȥ֥åϿ롥
	 *
	 *  ƱƥåǼϥɥٵư٤ˤϡ
	 *  δؿ isig_tim äˡ٤δؿƤФ
	 *  Ȥˤʤ롥
	 */
	tmevtb_enqueue_cyc(cyccb, cyccb->evttim + cyccb->cycinib->cyctim);

	/*
	 *  ϥɥCPUå֤ǸƤӽФ
	 */
	i_unlock_cpu();
	LOG_CYC_ENTER(cyccb);
	(*((CYCHDR)(cyccb->cycinib->cychdr)))(cyccb->cycinib->exinf);
	LOG_CYC_LEAVE(cyccb);
	i_lock_cpu();
}

#endif /* __cyccal */
