/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2006 by Witz Corporation, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_context.h,v 1.1 2006/04/10 08:19:25 honda Exp $
 */

/*
 *	ƥ롼TLCS-900L1ѡ
 *
 *  Υե cpu_config.h ʬΥƤΤϡΥե TCB
 *  줿ɤɬפΤФơcpu_config.h ˤ TCB 
 *  ɤɬפޤǤ뤿Ǥ롥
 */

#ifndef _CPU_CONTEXT_H_
#define _CPU_CONTEXT_H_

#include "task.h"

/*
 *  ƥȤν
 *
 *  ٻ߾֤˰ܹԤʥνλˤ˸
 *  Ф롥ŪˤϡƥȤ򥿥ưǤ֤
 *  ꤹcreate_context  activate_context ǹԤФ褤
 */
#pragma inline create_context
void
create_context(TCB *tcb)
{
}

/*
 *  εư
 *
 *  ٻ߾֤¹ԤǤ֤˰ܹԤ˸ƤФ롥
 */
extern void	activate_r(void);

#pragma inline activate_context
void
activate_context(TCB *tcb)
{
	VW	*sp;

	sp = (VW *)((UW)(tcb->tinib->stk) + (UW)(tcb->tinib->stksz));
	*--sp = (VW)(tcb->tinib->exinf);
	*--sp = (VW) ext_tsk;
	*--sp = (VW)(tcb->tinib->task);
	tcb->tskctxb.xsp = sp;
	tcb->tskctxb.pc = activate_r;
}

/*
 *  ext_tsk å˳ݤߡΰΥ
 */
#define	ACTIVATED_STACK_SIZE	(sizeof(VW) * 3)

/*
 *  calltex ϻѤʤ
 */
#define OMIT_CALLTEX

#endif /* _CPU_CONTEXT_H_ */
