/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *                     2003         by Advanced Data Controls, Corp
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.h,v 1.5 2004/09/04 16:38:40 honda Exp $
 */


/*
 *  ץå¸⥸塼SH3/4ѡ
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_


/*
 *  ͥ̾Υ͡
 */
#include <cpu_rename.h>


#ifdef SH4
#include "sh4.h"        
#else  /* SH3 */
#include "sh3.h"        
#endif /* SH4 */


/*
 *  ǽʺǹͥ
 */
#ifdef GHS_STUB
#define MAX_IPM  0xe
#else
#define MAX_IPM  0xf 
#endif 


/*
 *  ץåü̿Υ饤ؿ
 */
#ifndef _MACRO_ONLY
#include <cpu_insn.h>
#endif /* _MACRO_ONLY */

/*
 *  chg_ipm/get_ipm 򥵥ݡȤ뤫ɤ
 */
#define	SUPPORT_CHG_IPM



/*
 *  TCB Ϣ
 *
 *  cpu_context.h 쥬ȤȤΰ¸δطǡ
 *  cpu_context.h ˤʤ
 */

/*
 *  TCB ΥեɤΥӥå
 */
#define	TBIT_TCB_PRIORITY	8	/* priority եɤΥӥå */
#define	TBIT_TCB_TSTAT		8	/* tstat եɤΥӥå */
#define	TBIT_TCB_TWAIT		8	/* twait եɤΥӥå */

#ifndef _MACRO_ONLY
/*
 *  ƥȥ֥å
 */
typedef struct task_context_block {
        VP	sp;             /* åݥ */
        FP  pc;             /* ץ५ */
} CTXB;

/*
 *  ߥޥ饤֥
 *
 *  ߥޥintmaskˤϡIPMInterrupt Priority Maskˤ4ӥå
 *  ˥եȤΤǤ롥
 */


/*
 *  ߤγߥޥɽФ
 */
Inline UW
current_intmask()
{
	return(current_sr() & 0x000000f0);
}


/*
 *  ߥޥ
 */
Inline void
set_intmask(UW intmask)
{
	set_sr((current_sr() & ~0x000000f0) | intmask);
}


/*
 *  ƥֻ
 */

asm unsigned int _context()
{
%
    stc     r7_bank,r0
}

#define sense_context() (_context() > 0)


Inline BOOL
sense_lock()
{
	return(current_intmask() == MAX_IPM << 4);
}


#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock


/*
 *  CPUåȤβʥƥѡ
 *
 *  task_intmask ϡchg_ipm 򥵥ݡȤ뤿ѿchg_ipm 򥵥ݡ
 *  Ȥʤˤϡt_unlock_cpu  task_intmask  0 ֤
 *  褤
 */

#ifdef SUPPORT_CHG_IPM
extern UW	task_intmask;	/* ƥȤǤγߥޥ */
#endif /* SUPPORT_CHG_IPM */


Inline void
t_lock_cpu()
{
	disint();
}


Inline void
t_unlock_cpu()
{
#ifdef SUPPORT_CHG_IPM
	/*
	 *  t_unlock_cpu ƤӽФΤ CPUå֤ΤߤǤ뤿
	 *  ᡤ task_intmask 񤭴뤳ȤϤʤ
	 */
	set_intmask(task_intmask);
#else /* SUPPORT_CHG_IPM */
	enaint();
#endif /* SUPPORT_CHG_IPM */
}


/*
 *  CPUåȤβ󥿥ƥѡ
 */

extern UW	int_intmask;	/* 󥿥ƥȤǤγߥޥ */

Inline void
i_lock_cpu()
{
	UW	intmask;

	/*
	 *  ѿ intmask ȤäƤΤϡcurrent_intmask()Ƥ
	 *  ľ˳ߤȯư줿ߥϥɥ
	 *  int_intmask ѹǽ뤿Ǥ롥
	 */
	intmask = current_intmask();
	disint();
	int_intmask = intmask;
}


Inline void
i_unlock_cpu()
{
	set_intmask(int_intmask);
}


/*
 *  ǥѥå
 */

/*
 *  ǹ̥ͥؤΥǥѥåcpu_support.S
 *
 *  dispatch ϡƥȤƤӽФ줿ӥ
 *  ǡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	dispatch(void);


/*
 *  ߤΥƥȤΤƤƥǥѥåcpu_support.S
 *
 *  exit_and_dispatch ϡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	exit_and_dispatch(void);


/*
 *  ߥϥɥ顿CPU㳰ϥɥ
 */

/*
 *  ٥١
 */
extern void   BASE_VBR(void);


/*
 *  㳰٥ơ֥ι¤
 */
typedef struct exc_vector_entry {
	FP	exchdr;			/* 㳰ϥɥεư */
} EXCVE;



/*
 *  ߥϥɥεơ֥
 *  SH3ʹߤϥ٥ơ֥ʤ߽㳰װ
 *  եåȤˤ鵿ơ֥ϥɥμ¹ϵڤ
 *  ߥޥͤ
 */
extern FP	int_table[0x50];
extern VW   int_plevel_table[0x50];


/*
 *  CPU㳰ϥɥεơ֥
 */
extern FP	exc_table[(0x1E0 >> 5) + 1];


/*
 *
 *  ߥϥɥ
 *
 *  ٥ȥֹ inhno γߥϥɥεưϤ inthdr ꤹ롥
 *  ơ֥Ͽ
 *  stubȤstubƤӽФˤstubϿ
 *  
 */

extern FP general_exception();
extern FP interrupt();


Inline void
define_inh(INHNO inhno, FP inthdr)
{
        int_table[inhno >> 5] = inthdr;

}


/*
 *   CPU㳰ϥɥ
 *   ٥ơ֥Ͽ
 */   
Inline void
define_exc(EXCNO excno, FP exchdr)
{
        exc_table[excno >> 5] = exchdr;

}


/*
 *  ߥ٥
 */
Inline void
define_int_plevel(UINT dintno, UW plevel)
{
    int_plevel_table[dintno >> 5] = (plevel << 4) | 0x40000000;
}


/*
 *  ߥϥɥ顿CPU㳰ϥɥν
 *  
 */

/*
 *  ߥϥɥνޥ
 */

#define	INTHDR_ENTRY(inthdr)  extern void inthdr(void)

#define INT_ENTRY(inthdr) inthdr

/*
 *  CPU㳰ϥɥνޥ
 *
 */
#define	EXCHDR_ENTRY(exchdr)  extern void exchdr(VP sp)

#define	EXC_ENTRY(exchdr)     exchdr


/*
 *  CPU㳰ȯΥƥ֤λ
 */

/*
 *  CPU㳰ȯΥƥȽ
 */

Inline BOOL
exc_sense_context(VP p_excinf)
{
	return(_context() > 1);
}

/*
 *  CPU㳰ȯCPUå֤λ
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
	return((*((UW *)p_excinf + 11) & 0x00000f0) == MAX_IPM << 4);
}


/*
 *  ץå¸ν
 */
extern void	cpu_initialize(void);


/*
 *  ץå¸νλ
 */
extern void	cpu_terminate(void);


/*
 * ̤Ͽγ/㳰ȯΥ
 */
extern void     cpu_expevt(VW,VW,VW,VW);
extern void     cpu_interrupt(VW,VW,VW,VW);
extern void     no_reg_interrupt(void);


/*
 *  ꥢ륳ȥΥܡ졼Ԥ֤
 *  ХơȥȥΥեå奫󥿤Ȥ
 */
#define WAIT_RFCR_FOR_SCI    200


#endif /* _MACRO_ONLY_ */
#endif /* _CPU_CONFIG_H_ */
