/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sh7615scif.h,v 1.1 2005/07/06 00:45:07 honda Exp $
 */

/*
 *   SH2¢ꥢ륳ߥ˥󥤥󥿥եSCI ʰץɥ饤
 */

#ifndef _SH2SCIF_H_
#define _SH2SCIF_H_

#include <t_config.h>

/*
 *  ꥢI/OݡȽ֥å
 */
typedef struct sio_port_initialization_block
{
	UW reg_base;				/* 쥸Υ١ɥ쥹 */
	UB brr;						/* ܡ졼Ȥ   */
	UB smr;						/* ⡼ɥ쥸   */
	UB int_level;				/* ߥ٥   */
} SIOPINIB;

/*
 *  ꥢI/Oݡȴ֥å
 */
typedef struct sio_port_control_block
{
	const SIOPINIB *siopinib;	/* ꥢI/OݡȽ֥å */
	VP_INT exinf;				/* ĥ */
	BOOL openflag;				/* ץѤߥե饰 */
	BOOL sendflag;				/* ߥ֥͡ե饰 */
	BOOL getready;				/* ʸ */
	BOOL putready;				/* ʸǤ */
} SIOPCB;

#if defined(TTM)
/*
 *  ȥ쥸Υɥ쥹 
 */
#define SCIF_SC1SSR	(VH *)0xfffffcc8
#define SCIF_SC2SSR	(VB *)0xfffffcca
#define SCIF_SCFRDR	(VB *)0xfffffccc
#define SCIF_SCFTDR	(VB *)0xfffffcc6
#define SCIF_SCSCR	(VB *)0xfffffcc4
#define SCIF_SCFCR	(VB *)0xfffffcce
#define SCIF_SCSMR	(VB *)0xfffffcc0
#define SCIF_SCBRR	(VB *)0xfffffcc2
#endif
/*
 *  ȥ쥸Υɥ쥹Υեå 
 */
#define SCIF_SC1SSR	0x08
#define SCIF_SC2SSR	0x0a
#define SCIF_SCFRDR	0x0c
#define SCIF_SCFTDR	0x06
#define SCIF_SCSCR	0x04
#define SCIF_SCFCR	0x0e
#define SCIF_SCSMR	0x00
#define SCIF_SCBRR	0x02

/*
 *  ȥ쥸
 */
/*  FIFOȥ쥸SCFCRΥӥå  */
#define SCFCR_TFRST	0x04		/* ȥ󥹥ߥåFIFOǡ쥸ꥻå */
#define SCFCR_RFRST	0x02		/* 쥷FIFOǡ쥸ꥻå */
/*  ꥢ륳ȥ쥸SCSCRΥӥå  */
#define SCSCR_TIE	0x80		/* ȥ󥹥ߥåȥ󥿥ץȥ֥͡ */
#define SCSCR_RIE	0x40		/* 쥷֥󥿥ץȥ֥͡   */
#define SCSCR_TE	0x20		/* ȥ󥹥ߥåȥ֥͡         */
#define SCSCR_RE	0x10		/* 쥷֥֥͡           */
/*  ꥢ륹ơ쥸SC1SSRΥӥå  */
#define SC1SSR_TDFE	0x0020		/* ȥ󥹥ߥåFIFOǡ쥸ץƥ */
#define SC1SSR_ER	0x0080		/* 쥷֥顼       */
#define SC1SSR_FER	0x0008		/* ե졼ߥ󥰥顼       */
#define SC1SSR_PER	0x0004		/* ѥƥ顼       */
#define SC1SSR_RDRF	0x0002		/* 쥷֥ǡ쥸ե       */
#define SC1SSR_BRK	0x0010		/* ֥졼 */
/*  ꥢ륹ơ쥸SC2SSRΥӥå  */
#define SC2SSR_ORER	0x01		/* С󥨥顼 */

#define sh2scif_DELAY 	105000


/*
 *  SCI
 */
#define SMR_CKS 	0x0			/*  ʬ          */
#define BRR9600 	47			/*  9600 ӥåȥ졼    */
#define BRR19200	23			/*  19200 ӥåȥ졼    */
#define BRR38400	11			/*  38400 ӥåȥ졼    */
#define BRR57600 	7			/*  57600 ӥåȥ졼 	*/
#define BRR115200 	3			/*  115200 ӥåȥ졼 */

/*
 *  Хå롼μֹ
 */
#define SIO_ERDY_SND	1u		/* ǽХå */
#define SIO_ERDY_RCV	2u		/* ΥХå */

/*
 *  SIOɥ饤Фν롼
 */
extern void sh2scif_initialize (void);

/*
 *  ץ󤷤ƤݡȤ뤫
 */
extern BOOL sh2scif_openflag (ID siopid);

/*
 *  ꥢI/OݡȤΥץ
 */
extern SIOPCB *sh2scif_opn_por (ID siopid, VP_INT exinf);

/*
 *  ꥢI/OݡȤΥ
 */
extern void sh2scif_cls_por (SIOPCB * siopcb);

/*
 *  ꥢI/OݡȤؤʸ
 */
extern BOOL sh2scif_snd_chr (SIOPCB * siopcb, char c);

/*
 *  ꥢI/OݡȤʸ
 */
extern INT sh2scif_rcv_chr (SIOPCB * siopcb);

/*
 *  ꥢI/OݡȤΥХåε
 */
extern void sh2scif_ena_cbr (SIOPCB * siopcb, UINT cbrtn);

/*
 *  ꥢI/OݡȤΥХåζػ
 */
extern void sh2scif_dis_cbr (SIOPCB * siopcb, UINT cbrtn);

/*
 *  SIOγߥӥ롼
 */
extern void sh2scif_isr (void);

/*
 *  ꥢI/OݡȤǽХå
 */
extern void sh2scif_ierdy_snd (VP_INT exinf);

/*
 *  ꥢI/OݡȤμΥХå
 */
extern void sh2scif_ierdy_rcv (VP_INT exinf);

#endif /* _SH2SCIF_H_ */
