/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2003-2004 by CHUO ELECTRIC WORKS Co.,LTD. JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 */

/*
 *ꥢI/OǥХSIO˥ɥ饤
 *()ITRONSH1CPUܡ
 *SH1¢ꥢ륳ߥ˥󥤥󥿥եSCI
 *
 *sh1sci.{c,h}hw_serial.hʬδ
 *sh1sci.{c,h}ꥢǥХ˰¸ʬΤߵ
 *hw_serial.hꥢǥХʳ˵
 * hw_serial.h˵Ҥ
 *ߥȥ¸ʤ
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>
#ifndef _MACRO_ONLY
#include "sh1sci2.h"
#endif /* _MACRO_ONLY */

/*
 *  SIOγߥϥɥΥ٥ֹ
 */
#define INHNO_SERIAL_IN		RXI0
#define INHNO_SERIAL_OUT	TXI0
#define INHNO_SERIAL_ERROR  	ERI0

#define INHNO_SERIAL2_IN	RXI1
#define INHNO_SERIAL2_OUT	TXI1
#define INHNO_SERIAL2_ERROR	ERI1
#define INHNO_SERIAL2_TEI  	TEI1

#define LEVEL0		0	/*  ߲Υ٥  */

#ifndef _MACRO_ONLY

/*
 *  SIOɥ饤Фν롼
 */
#define	sio_initialize	sh1sci_initialize

/*
 *  ꥢI/OݡȤΥץ
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB	*siopcb;
	BOOL	openflag;

	/*
	 *  ݡȥץ󤷤 openflag ɤǤ
	 */
	openflag = sh1sci_openflag(siopid);

	/*
	 *  ǥХ¸Υץ
	 */
	siopcb = sh1sci_opn_por(siopid, exinf);

	/*
	 *  ߥȥ¸
	 *  ꥢI/Oߤγߥ٥ꤹ
	 */
	 if (!openflag) {
		define_int_plevel(siopcb->inib->ipr, SCI_INTLVL, siopcb->inib->shift);
	 }
	 
	return(siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
	/*
	 *  ǥХ¸Υ
	 */
	sh1sci_cls_por(siopcb);

	/*
	 *  ꥢI/Oߥ٥٥ˤ
	 */
	define_int_plevel(siopcb->inib->ipr, LEVEL0, siopcb->inib->shift);

}

/*
 *  SIOγߥϥɥ
 */
#define	sio_handler_in		sh1sci_isr_in		/*  ߥϥɥ  */
#define	sio_handler_out		sh1sci_isr_out		/*  ߥϥɥ  */
#define	sio_handler_error	sh1sci_isr_error	/*  顼ߥϥɥ */

#define	sio2_handler_in		sh1sci2_isr_in		/*  ߥϥɥ  */
#define	sio2_handler_out	sh1sci2_isr_out		/*  ߥϥɥ  */
#define	sio2_handler_error	sh1sci2_isr_error	/*  顼ߥϥɥ */
#define	sio2_handler_tend	sh1sci2_isr_tend	/*  λߥϥɥ   */

/*
 *  ꥢI/OݡȤؤʸ
 */
#define	sio_snd_chr	sh1sci_snd_chr

/*
 *  ꥢI/OݡȤʸ
 */
#define	sio_rcv_chr	sh1sci_rcv_chr

/*
 *  ꥢI/OݡȤΥХåε
 */
#define	sio_ena_cbr	sh1sci_ena_cbr

/*
 *  ꥢI/OݡȤΥХåζػ
 */
#define	sio_dis_cbr	sh1sci_dis_cbr

/*
 *  ꥢI/OݡȤǽХå
 *  jsp/systask/serial.cˤΤ͡षƤ
 *  ʰȡ
 */
#define	sio_ierdy_snd	sh1sci_ierdy_snd

/*
 *  ꥢI/OݡȤμΥХå
 *  jsp/systask/serial.cˤΤ͡षƤ
 *  ʰȡ
 */
#define	sio_ierdy_rcv	sh1sci_ierdy_rcv

#endif /* _MACRO_ONLY */
#endif /* _HW_SERIAL_H_ */
