/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2003-2004 by CHUO ELECTRIC WORKS Co.,LTD. JAPAN
 *
 *  嵭ԤϡFree Software Foundation ˤäƸɽƤ 
 *  GNU General Public License  Version 2 ˵ҤƤ狼
 *  (1)(4)ξ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥѲǽʥХʥꥳɡʥ֥륪
 *      ȥե饤֥ʤɡˤηѤˤϡ
 *      ȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭ɽ
 *      Ѿ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥԲǽʥХʥꥳɤηޤϵ
 *      ߹ѤˤϡΤ줫ξȡ
 *    (a) ѤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) Ѥη֤̤ˡˤäơ嵭Ԥ𤹤
 *        ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭Ԥդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥϡ
 *  ܥեȥ˴ؤơŬѲǽޤơʤݾڤԤ
 *  ʤޤܥեȥѤˤľŪޤϴŪ
 *  ʤ»˴ؤƤ⡤Ǥʤ
 * 
 */
 
#ifndef _DEVICE_H_
#define _DEVICE_H_

/*
 *  LED ID
 */
#define LED1		1		/* LED1ID */
#define LED2		2		/* LED2ID */
#define LED3		3		/* LED3ID */

/*
 *  LEDӥå
 */
#define LED_CTL1	0x0100		/* LED1  */
#define LED_CTL2	0x0040		/* LED2  */
#define LED_CTL3	0x1000		/* LED3  */

/*
 *  å꡼ɥɥ쥹
 */
#define SW_DR		((VB *)0x6000200)

/*
 *  ǥåץåѤΥޥӥå
 */
#define DSW11		0x10
#define DSW12		0x20
#define DSW13		0x40
#define DSW14		0x80

/*
 *  ꡼åѤΥޥӥå
 */
#define RSW_CTL		0x0F

/*
 *  ON OFF 
 */
#define ON		1
#define OFF		0

/*
 *  åɥåޥꥢ
 */
Inline void
wdt_clear(void)
{
	sil_wrh_mem(PA_DR, (sil_reh_mem(PA_DR) ^ (1<<5)));
}

/*
 *  ǥХΥץȥ
 */
void	initial_led(void );
void	set_led( int led, int req );
int	get_led( int led );
int	get_dsw( int sw );
int	get_rsw( void );

#endif /* _DEVICE_H_ */
