/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sh1_sil.h,v 1.4 2004/09/22 08:47:52 honda Exp $
 */

/*
 *  SH1¢쥸ؤΥ桼ƥƥʥӥåȱ黻
 *  
 *  sh1.h˵ҤΤ쥬Ȥsil.hȤΥ󥯥롼ɤ
 *  ֤δطΩեȤ
 *  t_config.hľܥ󥯥롼ɤȤsil.hˤ
 *  ե뤬󥯥롼ɤǽ롣
 *  
 *  ѥηåǽͭˤ뤿ᡢݥ󥿷
 *  VB *VH *VW *ѤƤ롣
 *  
 */

#ifndef _SIL_SH1_H_
#define _SIL_SH1_H_

#ifndef _MACRO_ONLY

/*
 *  8ӥåȥ쥸AND黻
 */
Inline void
sh1_anb_reg(VB *mem, VB data)
{
	VB reg = sil_reb_mem((VP)mem);
	reg &= data;
	sil_wrb_mem((VP)mem, reg);
}

/*
 *  8ӥåȥ쥸OR黻
 */
Inline void
sh1_orb_reg(VB *mem, VB data)
{
	VB reg = sil_reb_mem((VP)mem);
	reg |= data;
	sil_wrb_mem((VP)mem, reg);
}


/*
 *  16ӥåȥ쥸AND黻
 */
Inline void
sh1_anh_reg(VH *mem, VH data)
{
	VH reg = sil_reh_mem((VP)mem);
	reg &= data;
	sil_wrh_mem((VP)mem, reg);
}

/*
 *  16ӥåȥ쥸OR黻
 */
Inline void
sh1_orh_reg(VH *mem, VH data)
{
	VH reg = sil_reh_mem((VP)mem);
	reg |= data;
	sil_wrh_mem((VP)mem, reg);
}

/*
 *  32ӥåȥ쥸AND黻
 */
Inline void
sh1_anw_reg(VW *mem, VW data)
{
	VW reg = sil_rew_mem((VP)mem);
	reg &= data;
	sil_wrw_mem((VP)mem, reg);
}

/*
 *  32ӥåȥ쥸OR黻
 */
Inline void
sh1_orw_reg(VW *mem, VW data)
{
	VW reg = sil_rew_mem((VP)mem);
	reg |= data;
	sil_wrw_mem((VP)mem, reg);
}


/*
 *  ߥ٥
 *  
 *  mem  ѹ쥸
 *  levelꤹߥ٥
 *  shiftӥåȺեȤȤĽ꤫
 *  
 */
Inline void
define_int_plevel(VH *mem, UW level, UINT shift)
{
	VH reg = sil_reh_mem((VP)mem);
	reg = (VH)((reg & ~(0xfu << shift)) | (level << shift));
	sil_wrh_mem((VP)mem, reg);
}



#endif /* _MACRO_ONLY */
#endif	/*  _SIL_SH1_H_  */
