/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: vea_oea.h,v 1.2 2004/10/07 17:10:56 honda Exp $
 */

/*  
 *   PowerPCƥVEA,OEA¸
 *   ꥸʥPowerPCƥξ
 *   ȥMPC꡼IPM PowerPC6xx/7xx꡼
 *   ˳롣
 *   
 *   PowerPCƥϰʲΣĤΥ٥뤫
 *   USIA:User Instruction Set Architecture
 *   VEA: Virtual Environment Architecture
 *   OEA: Operating Environment Architecture
 *   
 *   USIAˤĤƤﶦ̤Ǥ뤬VEAOEAˤĤƤ
 *   ꥸʥPowerPCƥThe IBM PowerPC 
 *   Embedded Environment줾̤Ƥ뤿ᡢ
 *   VEAOEAϥեʬơ򥤥󥯥롼
 *   Ƥ롣
 */   

#ifndef _VEA_OEA_H_
#define _VEA_OEA_H_

/*  
 *  쥸ֹ
 */   

/*  
 *  Configuration Register
 */   
#define PVR	287	/*  ץåС󡦥쥸  */

/*  
 *  Memory Management Registers
 */   
/*  Instruction BAT Registers  */
#define IBAT0U	528
#define IBAT0L	529
#define IBAT1U	530
#define IBAT1L	531
#define IBAT2U	532
#define IBAT2L	533
#define IBAT3U	534
#define IBAT3L	535

/*  Instruction BAT Registers  */
#define DBAT0U	536
#define DBAT0L	537
#define DBAT1U	538
#define DBAT1L	539
#define DBAT2U	540
#define DBAT2L	541
#define DBAT3U	542
#define DBAT3L	543

#define SDR1	 25
#define ASR	280

/*  
 *  Exception Handling Registers
 */   
#define DAR	 19	/*  Data Address Register  */

#define SPRG0   272     /*  ü쥸OS  */
#define SPRG1   273     /*  ü쥸OS  */
#define SPRG2   274     /*  ü쥸OS  */
#define SPRG3   275     /*  ü쥸OS  */

#define DSISR    18     /*  DSIơ쥸(*)  */
                        /*  DSIǡȥ  */
#define SRR0     26     /*  쥸0  */
#define SRR1     27     /*  쥸1  */

#define FPECR	1022	/*  Floating-Point Exception Cause Register  */


/*  
 *  Miscellaneous Registers
 */   
/*  Time Base Facility(OEA:for Writing)  */
#define TBLw	284
#define TBUw	285

/*  Time Base Facility(VEA:for Reading)  */
#define TBL	268
#define TBU	269

#define DEC      22     /*  ǥȡ쥸(*)  */

#define PIR	1023	/*  Processor Identification Register  */

#define DABR	1013	/*  DATA Address Breakpint Register(option)  */
#define EAR	 282	/*  Exception Access Register(option)  */



/*  
 *   ӥåֹ
 *   աPowerPCΥӥåֹ̾ȵդˤʤäƤ
 *   ޤ32ӥåȥ쥸16ӥåȥ쥸Ǥ
 *   ǲ̥ӥåȤΥӥåֹ椬ۤʤˤ
 */   

/*  ޥ󥹥ơ쥸γƥӥåȤ  */
/*  ա32ӥåȡץ  */
#define MSR_POW BIT13_32    /*  ѥޥ͡ȡ֥͡  */
#define MSR_ILE BIT15_32    /*  㳰Υǥ⡼  */
                            /*  㳰ջMSR.LEMSR.ILE  */
#define MSR_EE  BIT16_32    /*  ߥ֥͡  */
#define MSR_PR  BIT17_32    /*  ø٥  */
                            /*  0ѥХ٥  */
                            /*  1桼٥  */
#define MSR_FP  BIT18_32    /*  ư֥͡  */
#define MSR_ME  BIT19_32    /*  ޥå֥͡  */
#define MSR_FE0 BIT20_32    /*  ư㳰⡼0  */
#define MSR_FE1 BIT23_32    /*  ư㳰⡼1  */
                            /*  աֹ椬Ϣ³  */
#define MSR_SE  BIT21_32    /*  󥰥륹ƥåץȥ졼֥͡  */
#define MSR_BE  BIT22_32    /*  ʬȥ졼֥͡  */
#define MSR_IP  BIT25_32    /*  㳰ץեå  */
                            /*  00x000n,nnnn  */
                            /*  10xfffn,nnnn  */
#define MSR_IR  BIT26_32    /*  ̿ᥢɥ쥹Ѵ֥͡  */
#define MSR_DR  BIT27_32    /*  ǡɥ쥹Ѵ֥͡  */
#define MSR_RI  BIT30_32    /*  ǽ㳰  */
                            /*  0:Բǽ  */
                            /*  1:ǽ  */
#define MSR_LE  BIT31_32    /*  ȥ륨ǥ󡦥⡼  */
                            /*  0ӥåǥ  */
                            /*  1ȥ륨ǥ  */
/*  0ͽ󤵤ƤӥåȤΤΥޥ  */
#define MSR_MASK    ~(BIT0_32 | BIT1_32 | BIT2_32 | BIT3_32 | BIT4_32 \
                    | BIT5_32 | BIT6_32 | BIT7_32 | BIT8_32 | BIT9_32 \
                    | BIT10_32 | BIT11_32 | BIT12_32 | BIT24_32 \
                    | BIT28_32 | BIT29_32)


/*  
 *   CPU㳰װ
 *   ֹ椬Ϣ³ʤΤCPU㳰٥ơ֥˰̵̤뤬
 *   PowerPCƥ˹碌ͥ褷
 */   
#define EXC_NO_SYSTEM_RESET             0x1   /*  ƥꥻå㳰  */
#define EXC_NO_MACHINE_CHECK            0x2   /*  ޥ󡦥å㳰  */
#define EXC_NO_DSI                      0x3   /*  DSI㳰  */
                                        /*  ʥǡꡦ  */
#define EXC_NO_ISI                      0x4   /*  ISI㳰̿եå  */
#define EXC_NO_EXTERNAL_INTERRUPT       0x5   /*    */
#define EXC_NO_ALIGNMENT                0x6   /*  饤㳰  */
#define EXC_NO_PROGRAM                  0x7   /*  ץ㳰  */
#define EXC_NO_FLOATING_POINT_UNAVAILABLE 0x8   /*  ưԲ  */
#define EXC_NO_DECREMENTER              0x9   /*  ǥ㳰  */
                            /*  ץơͭ㳰0x00a00  */
#define EXC_NO_IMPLEMENT_EXCEPTION_00A00 0xa 
#define EXC_NO_SYSTEM_CALL              0xc /*  ƥॳ  */
#define EXC_NO_TRACE                    0xd /*  ȥ졼ʥץ  */
#define EXC_NO_FLOATING_POINT_ASSIST    0xe /*  ư  */
                            /*  ץơͭ㳰0x01000  */
#define EXC_NO_IMPLEMENT_EXCEPTION_01000 0x10    


/*  
 *   㳰μ̿
 *   ߤ⣱Ĥȿ
 *   0֤̤
 *   㳰٥ΥեåȤб
 *   ߤ⣱Ĥȿ
 *   Τᡢ+1Ƥ
 */   

#ifdef IMPLEMENT_EXCEPTION_01000    /*  㳰٥0x1000Ѥ  */
#define TMAX_EXCNO       ( 0x10 + 1 )

#else /* IMPLEMENT_EXCEPTION_01000 */
#define TMAX_EXCNO       ( 0xe + 1 )

#endif /* IMPLEMENT_EXCEPTION_01000 */




#endif /* _VEA_OEA_H_ */
/*  end of file  */
