/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *
 *  嵭ԤϡFree Software Foundation ˤäƸɽƤ
 *  GNU General Public License  Version 2 ˵ҤƤ狼
 *  (1)(4)ξ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥѲǽʥХʥꥳɡʥ֥륪
 *      ȥե饤֥ʤɡˤηѤˤϡ
 *      ȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭ɽ
 *      Ѿ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥԲǽʥХʥꥳɤηޤϵ
 *      ߹ѤˤϡΤ줫ξȡ
 *    (a) ѤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) Ѥη֤̤ˡˤäơ嵭Ԥ𤹤
 *        ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭Ԥդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥϡ
 *  ܥեȥ˴ؤơŬѲǽޤơʤݾڤԤ
 *  ʤޤܥեȥѤˤľŪޤϴŪ
 *  ʤ»˴ؤƤ⡤Ǥʤ
 *
 *  @(#) $Id: sample_elf.ld,v 1.1 2004/09/03 16:39:56 honda Exp $
 */

OUTPUT_FORMAT("elf32-powerpc","elf32-powerpc","elf32-powerpc")
OUTPUT_ARCH(powerpc)

MEMORY
{
	ROM(rxai):ORIGIN = 0x10000000, LENGTH =  4M
	ROM_reset(rxai):ORIGIN = 0xffffffec, LENGTH = 0x14
	RAM(wxai):ORIGIN = 0x00000000, LENGTH = 16M
}

PROVIDE (__stack = 0) ;
PROVIDE(hardware_init_hook = 0);
PROVIDE(software_init_hook = 0);
PROVIDE(software_term_hook = 0);
PROVIDE(memcpy = _dummy_memcpy);
SECTIONS
{
    .exception_vector 0x10000100 :
    {
	*(.exception_vector)
    } >ROM
    .init :
    {
        KEEP (*(.init))
    } >ROM
    .text :
    {
        __text = . ;
        *(.text .stub .text.* .gnu.linkonce.t.*)
    } >ROM
    .fini :
    {
        KEEP (*(.fini))
    } >ROM
    _etext = . ;
    PROVIDE (etext = .) ;
    .rodata :
    {
        *(.rodata .rodata.* .gnu.linkonce.r.*)
    } >ROM
    . = ALIGN(4) ;

    __idata_start = . ;
    .data : AT(__idata_start) 
    {
        __data_start = . ;
        *(.data)
    } >RAM

    __isdata_start = . ;
    .sdata : AT(__idata_start + SIZEOF(.data)) 
    {
        __sdata_start = . ;
        *(.sdata)
    } >RAM

    /*  ꥻåȥ٥  */
    .system_reset_vector :	/*  0xffff,ffecϤ֤롣  */
    {
	*(.system_reset_vector)
    } >ROM_reset

    .eh_frame : { KEEP (*(.eh_frame)) }
    .gcc_except_table : { *(.gcc_except_table) }
    .ctors :
    {
        KEEP (*crtbegin.o(.ctors))
        KEEP (*(EXCLUDE_FILE (*crtend.o ) .ctors))
        KEEP (*(SORT(.ctors.*)))
        KEEP (*(.ctors))
    }
    .dtors :
    {
        KEEP (*crtbegin.o(.dtors))
        KEEP (*(EXCLUDE_FILE (*crtend.o ) .dtors))
        KEEP (*(SORT(.dtors.*)))
        KEEP (*(.dtors))
    }
/*     __idata_end = __idata_start + SIZEOF(.data) ; */
    __idata_end = __idata_start + SIZEOF(.data) + SIZEOF(.sdata) ;
    _edata  = . ;
    PROVIDE (edata = .) ;
    . = ALIGN(4) ;
    __sbss_start = . ;
    .sbss :
    {
        *(.sbss)
    } >RAM
    __bss_start = . ;
    .bss :
    {
        *(.bss)
        *(COMMON)
    } >RAM
    _end = . ;
    __bss_end = . ;
    PROVIDE (end = .) ;
    .comment        0 : { *(.comment) }
    .debug          0 : { *(.debug) }
    .line           0 : { *(.line) }
    .debug_srcinfo  0 : { *(.debug_srcinfo) }
    .debug_sfnames  0 : { *(.debug_sfnames) }
    .debug_aranges  0 : { *(.debug_aranges) }
    .debug_pubnames 0 : { *(.debug_pubnames) }
}
